/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.Iterator;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecTreeTraverser
extends TreeTraverser {
    public ExecTreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation) {
        super(rootNode, operation);
    }

    public ExecTreeTraverser(INodePO rootNode) {
        super(rootNode);
    }

    @Override
    protected void traverseImpl(ITreeTraverserContext<INodePO> context, INodePO parent, INodePO node) {
        context.append(node);
        if (context.isContinue()) {
            INodePO next;
            Iterator<INodePO> iter;
            for (ITreeNodeOperation<INodePO> operation : this.getOperations()) {
                operation.operate(context, parent, node, false);
            }
            if (node instanceof IProjectPO) {
                IProjectPO project = (IProjectPO)node;
                for (IExecPersistable exec : project.getExecObjCont().getExecObjList()) {
                    this.traverseImpl(context, project, exec);
                }
            } else if (node instanceof ICategoryPO) {
                ICategoryPO category = (ICategoryPO)node;
                iter = category.getNodeListIterator();
                while (iter.hasNext()) {
                    next = iter.next();
                    this.traverseImpl(context, parent, next);
                }
            } else if (node instanceof ITestSuitePO) {
                ITestSuitePO suite = (ITestSuitePO)node;
                iter = suite.getNodeListIterator();
                while (iter.hasNext()) {
                    next = iter.next();
                    this.traverseImpl(context, parent, next);
                }
            } else if (node instanceof IExecTestCasePO) {
                IExecTestCasePO execTC = (IExecTestCasePO)node;
                iter = execTC.getNodeListIterator();
                while (iter.hasNext()) {
                    this.traverseImpl(context, parent, iter.next());
                }
            }
            for (ITreeNodeOperation<INodePO> operation : this.getOperations()) {
                operation.postOperate(context, parent, node, false);
            }
        }
        context.removeLast();
    }
}

