/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverserContext;
import org.eclipse.jubula.tools.exception.JBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTraverser {
    public static final int NO_DEPTH_LIMIT = -1;
    private List<ITreeNodeOperation<INodePO>> m_operations = new ArrayList<ITreeNodeOperation<INodePO>>();
    private INodePO m_rootNode;
    private boolean m_traverseEventHandlers = false;
    private boolean m_traverseSpecPart = false;
    private int m_maxDepth = -1;
    private Set<String> m_visited = new HashSet<String>(1001);

    public TreeTraverser(INodePO rootNode) {
        this.m_rootNode = rootNode;
    }

    public TreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation) {
        this(rootNode);
        this.m_operations.add(operation);
    }

    public TreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation, boolean traverseSpecPart) {
        this(rootNode, operation);
        this.m_traverseSpecPart = traverseSpecPart;
    }

    public TreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation, int maxTraversalDepth) {
        this(rootNode, operation);
        this.m_maxDepth = maxTraversalDepth;
    }

    public TreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation, boolean traverseSpecPart, int maxTraversalDepth) {
        this(rootNode, operation, traverseSpecPart);
        this.m_maxDepth = maxTraversalDepth;
    }

    protected void traverseImpl(ITreeTraverserContext<INodePO> context, INodePO parent, INodePO node) {
        if (this.m_maxDepth == -1 || this.m_maxDepth > context.getCurrentTreePath().size()) {
            context.append(node);
            boolean alreadyVisited = this.alreadyVisited(node);
            HashSet<ITreeNodeOperation<INodePO>> suspendedOps = null;
            for (ITreeNodeOperation<INodePO> operation : this.m_operations) {
                boolean continueWork = operation.operate(context, parent, node, alreadyVisited);
                if (continueWork) continue;
                if (suspendedOps == null) {
                    suspendedOps = new HashSet<ITreeNodeOperation<INodePO>>(this.m_operations.size());
                }
                suspendedOps.add(operation);
            }
            if (suspendedOps != null) {
                this.m_operations.removeAll(suspendedOps);
            }
            this.addToVisited(node);
            if (context.isContinue() && !this.m_operations.isEmpty()) {
                if (node instanceof IProjectPO) {
                    IProjectPO project = (IProjectPO)node;
                    this.traverseProject(context, project);
                } else {
                    ISpecTestCasePO testCase;
                    Iterator<INodePO> it = node.getNodeListIterator();
                    while (it.hasNext()) {
                        INodePO child = it.next();
                        this.traverseImpl(context, node, child);
                    }
                    Class nodePoClass = Persistor.getClass(node);
                    if (this.m_traverseEventHandlers && Persistor.isPoClassSubclass(nodePoClass, ITestCasePO.class) && (testCase = Persistor.isPoClassSubclass(nodePoClass, IExecTestCasePO.class) ? ((IExecTestCasePO)node).getSpecTestCase() : (ISpecTestCasePO)node) != null) {
                        for (IEventExecTestCasePO child : testCase.getAllEventEventExecTC()) {
                            this.traverseImpl(context, node, child);
                        }
                    }
                    for (ITreeNodeOperation<INodePO> operation : this.m_operations) {
                        operation.postOperate(context, parent, node, alreadyVisited);
                    }
                }
            }
            context.removeLast();
            if (suspendedOps != null) {
                this.m_operations.addAll(suspendedOps);
            }
        }
    }

    private void traverseProject(ITreeTraverserContext<INodePO> context, IProjectPO project) {
        if (this.m_traverseSpecPart) {
            for (ISpecPersistable specNode : project.getSpecObjCont().getSpecObjList()) {
                this.traverseImpl(context, project, specNode);
            }
            for (IReusedProjectPO reused : project.getUsedProjects()) {
                try {
                    IProjectPO reusedProject = ProjectPM.loadReusedProjectInMasterSession(reused);
                    if (reusedProject == null) continue;
                    for (ISpecPersistable specNode : reusedProject.getSpecObjCont().getSpecObjList()) {
                        this.traverseImpl(context, reusedProject, specNode);
                    }
                }
                catch (JBException jBException) {}
            }
        } else {
            for (IExecPersistable exec : project.getExecObjCont().getExecObjList()) {
                this.traverseImpl(context, project, exec);
            }
        }
    }

    public void traverse() {
        this.traverse(false);
    }

    public void traverse(boolean traverseEventHandlers) {
        this.clearVisited();
        this.m_traverseEventHandlers = traverseEventHandlers;
        this.traverseImpl(new TreeTraverserContext<INodePO>(this.m_rootNode), null, this.m_rootNode);
    }

    protected List<ITreeNodeOperation<INodePO>> getOperations() {
        return this.m_operations;
    }

    public void addOperation(ITreeNodeOperation<INodePO> op) {
        this.m_operations.add(op);
    }

    private void addToVisited(INodePO node) {
        this.m_visited.add(node.getGuid());
    }

    private boolean alreadyVisited(INodePO node) {
        return this.m_visited.contains(node.getGuid());
    }

    private void clearVisited() {
        this.m_visited.clear();
    }
}

