/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.actions;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.actions.AbstractPasteTreeItemAction;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.swt.dnd.Transfer;

public class PasteTreeItemActionOMEditor
extends AbstractPasteTreeItemAction {
    public void run() {
        ObjectMappingMultiPageEditor ome = (ObjectMappingMultiPageEditor)Plugin.getActiveEditor();
        LocalSelectionClipboardTransfer transfer = LocalSelectionClipboardTransfer.getInstance();
        if (!(ome.getEditorHelper().getClipboard().getContents((Transfer)transfer) instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection pasteSelection = (IStructuredSelection)ome.getEditorHelper().getClipboard().getContents((Transfer)transfer);
        if (pasteSelection != null) {
            ISelection sel = ome.getSite().getSelectionProvider().getSelection();
            if (!(sel instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)sel;
            Object[] selArray = selection.toArray();
            Object target = selArray[selArray.length - 1];
            if (ome.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                return;
            }
            if (transfer.containsOnlyType(IObjectMappingAssoziationPO.class)) {
                List toMove = transfer.getSelection().toList();
                if (target instanceof IObjectMappingCategoryPO) {
                    OMEditorDndSupport.checkAndMoveAssociations(toMove, (IObjectMappingCategoryPO)target, ome);
                }
            } else if (transfer.containsOnlyType(IObjectMappingCategoryPO.class)) {
                if (target instanceof IObjectMappingCategoryPO) {
                    IObjectMappingCategoryPO targetCategory = (IObjectMappingCategoryPO)target;
                    List toMove = transfer.getSelection().toList();
                    if (!OMEditorDndSupport.isMergeIfNeeded(toMove, targetCategory)) {
                        return;
                    }
                }
            } else if (transfer.containsOnlyType(IComponentNamePO.class)) {
                List toMove = transfer.getSelection().toList();
                if (target instanceof IObjectMappingAssoziationPO) {
                    OMEditorDndSupport.checkTypeCompatibilityAndMove((List<IComponentNamePO>)toMove, (IObjectMappingAssoziationPO)target, ome);
                } else if (target instanceof IObjectMappingCategoryPO) {
                    OMEditorDndSupport.checkTypeCompatibilityAndMove((List<IComponentNamePO>)toMove, (IObjectMappingCategoryPO)target, ome);
                }
            }
            this.handlePostPaste(ome, transfer, target);
        }
    }

    private void handlePostPaste(ObjectMappingMultiPageEditor ome, LocalSelectionClipboardTransfer transfer, Object target) {
        ome.getEditorHelper().getClipboard().clearContents();
        transfer.setSelection(null, null);
        this.setEnabled(false);
        ome.getTreeViewer().setSelection((ISelection)new StructuredSelection(target));
        LocalSelectionTransfer.getInstance().setSelection(null);
        ome.getEditorHelper().setDirty(true);
    }
}

