/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.AbstractActionBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionGUIController;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.registration.AutIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseTestSuiteBP
extends AbstractActionBP {
    private static ChooseTestSuiteBP instance = null;
    private ITestSuitePO m_lastUsedTestSuite;
    private AutIdentifier m_lastUsedAUT;
    private boolean m_isTestRunning = false;
    private boolean m_isAutStarted = false;
    private boolean m_isProjectLoaded = false;
    private boolean m_atLeastOneTsAvailable = true;
    private boolean m_isOmMode = false;
    private boolean m_isRecordMode = false;
    private DataEventDispatcher.ILanguageChangedListener m_langChangedListener = new DataEventDispatcher.ILanguageChangedListener(){

        public void handleLanguageChanged(Locale locale) {
            ChooseTestSuiteBP.this.updateTestSuiteButtonState(true);
        }
    };
    private DataEventDispatcher.IProjectPropertiesModifyListener m_projPropModifyListener = new DataEventDispatcher.IProjectPropertiesModifyListener(){

        public void handleProjectPropsChanged() {
            ChooseTestSuiteBP.this.updateTestSuiteButtonState(true);
        }
    };
    private DataEventDispatcher.IProjectLoadedListener m_projLoadedListener = new DataEventDispatcher.IProjectLoadedListener(){

        public void handleProjectLoaded() {
            ChooseTestSuiteBP.this.m_isProjectLoaded = true;
            ChooseTestSuiteBP.this.m_lastUsedTestSuite = null;
            ChooseTestSuiteBP.this.m_isTestRunning = false;
            ChooseTestSuiteBP.this.m_isAutStarted = false;
            ChooseTestSuiteBP.this.m_atLeastOneTsAvailable = false;
            ChooseTestSuiteBP.this.updateTestSuiteButtonState(false);
        }
    };
    private DataEventDispatcher.ITestSuiteStateListener m_testSuiteStateListener = new DataEventDispatcher.ITestSuiteStateListener(){

        public void handleTSStateChanged(TestExecutionEvent event) {
            switch (event.getState()) {
                case 1: 
                case 9: 
                case 14: {
                    ChooseTestSuiteBP.this.m_isTestRunning = true;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    ChooseTestSuiteBP.this.m_isTestRunning = false;
                    break;
                }
            }
            ChooseTestSuiteBP.this.updateTestSuiteButtonState(false);
        }
    };
    private DataEventDispatcher.IAutStateListener m_autStateListener = new DataEventDispatcher.IAutStateListener(){

        public void handleAutStateChanged(DataEventDispatcher.AutState state) {
            switch (state) {
                case running: {
                    ChooseTestSuiteBP.this.m_isAutStarted = true;
                    ChooseTestSuiteBP.this.updateTestSuiteButtonState(true);
                    break;
                }
                case notRunning: {
                    ChooseTestSuiteBP.this.m_isAutStarted = false;
                    ChooseTestSuiteBP.this.m_isOmMode = false;
                    ChooseTestSuiteBP.this.m_isRecordMode = false;
                    ChooseTestSuiteBP.this.updateTestSuiteButtonState(false);
                    break;
                }
                default: {
                    Assert.notReached((String)Messages.UnhandledAutState);
                }
            }
        }
    };
    private DataEventDispatcher.IDataChangedListener m_currentProjDeletedListener = new DataEventDispatcher.IDataChangedListener(){

        public void handleDataChanged(DataChangedEvent ... events) {
            DataChangedEvent[] dataChangedEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DataChangedEvent e = dataChangedEventArray[n2];
                this.handleDataChanged(e.getPo(), e.getDataState(), e.getUpdateState());
                ++n2;
            }
        }

        public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
            if (updateState == DataEventDispatcher.UpdateState.onlyInEditor) {
                return;
            }
            if (dataState == DataEventDispatcher.DataState.Deleted && po instanceof IProjectPO && GeneralStorage.getInstance().getProject() == null) {
                ChooseTestSuiteBP.this.m_isProjectLoaded = false;
                ChooseTestSuiteBP.this.m_lastUsedTestSuite = null;
                ChooseTestSuiteBP.this.m_isAutStarted = false;
                ChooseTestSuiteBP.this.m_atLeastOneTsAvailable = false;
                ChooseTestSuiteBP.this.updateTestSuiteButtonState(false);
            }
        }
    };
    private DataEventDispatcher.IOMStateListener m_omStateListener = new DataEventDispatcher.IOMStateListener(){

        public void handleOMStateChanged(DataEventDispatcher.OMState state) {
            switch (state) {
                case running: {
                    ChooseTestSuiteBP.this.m_isOmMode = true;
                    ChooseTestSuiteBP.this.m_isRecordMode = false;
                    break;
                }
                case notRunning: {
                    ChooseTestSuiteBP.this.m_isOmMode = false;
                    break;
                }
                default: {
                    Assert.notReached((String)Messages.UnsupportedObjectMappingState);
                }
            }
            ChooseTestSuiteBP.this.updateTestSuiteButtonState(true);
        }
    };
    private DataEventDispatcher.IRecordModeStateListener m_recordModeStateListener = new DataEventDispatcher.IRecordModeStateListener(){

        public void handleRecordModeStateChanged(DataEventDispatcher.RecordModeState state) {
            switch (state) {
                case running: {
                    ChooseTestSuiteBP.this.m_isRecordMode = true;
                    ChooseTestSuiteBP.this.m_isOmMode = false;
                    break;
                }
                case notRunning: {
                    ChooseTestSuiteBP.this.m_isRecordMode = false;
                    break;
                }
                default: {
                    Assert.notReached((String)Messages.UnsupportedRecordModeState);
                }
            }
            ChooseTestSuiteBP.this.updateTestSuiteButtonState(true);
        }
    };
    private DataEventDispatcher.IDataChangedListener m_dataChangedListener = new DataEventDispatcher.IDataChangedListener(){

        public void handleDataChanged(DataChangedEvent ... events) {
            ChooseTestSuiteBP.this.updateTestSuiteButtonState(true);
        }
    };

    private ChooseTestSuiteBP() {
        this.init();
    }

    public static ChooseTestSuiteBP getInstance() {
        if (instance == null) {
            instance = new ChooseTestSuiteBP();
        }
        return instance;
    }

    public SortedSet<ITestSuitePO> getAllTestSuites() {
        TreeSet<ITestSuitePO> testSuites = new TreeSet<ITestSuitePO>();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            List tsInProject = TestSuiteBP.getListOfTestSuites((IProjectPO)project);
            for (ITestSuitePO ts : tsInProject) {
                if (!this.isTestSuiteStartable(ts)) continue;
                testSuites.add(ts);
            }
        }
        return testSuites;
    }

    public boolean isTestSuiteStartable(ITestSuitePO ts) {
        return this.areGeneralRequirementsAchieved(ts) && this.isTestSuiteComplete(ts);
    }

    public boolean areGeneralRequirementsAchieved(ITestSuitePO ts) {
        Locale workingLanguage = WorkingLanguageBP.getInstance().getWorkingLanguage();
        return workingLanguage != null && ts.getAut() != null && AutAgentRegistration.getRunningAuts((IProjectPO)GeneralStorage.getInstance().getProject(), null).keySet().contains(ts.getAut()) && ts.getNodeListSize() > 0;
    }

    public boolean isTestSuiteComplete(ITestSuitePO ts) {
        Locale workingLanguage = WorkingLanguageBP.getInstance().getWorkingLanguage();
        return ts.getSumOMFlag(ts.getAut()) && ts.getSumTdFlag(workingLanguage) && ts.getSumSpecTcFlag();
    }

    public void setLastUsedTestSuite(ITestSuitePO testSuite) {
        this.m_lastUsedTestSuite = testSuite;
    }

    public ITestSuitePO getLastUsedTestSuite() {
        for (ITestSuitePO ts : this.getAllTestSuites()) {
            if (!ts.equals((Object)this.m_lastUsedTestSuite)) continue;
            this.m_lastUsedTestSuite = ts;
            return ts;
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.m_isProjectLoaded && this.m_isAutStarted && this.m_atLeastOneTsAvailable && !this.m_isTestRunning && !this.m_isOmMode && !this.m_isRecordMode;
    }

    public boolean isInfrastructureReady() {
        return this.m_isProjectLoaded && this.m_isAutStarted && !this.m_isTestRunning && !this.m_isOmMode && !this.m_isRecordMode;
    }

    private void updateTestSuiteButtonState(boolean validateNumberOfTS) {
        if (validateNumberOfTS) {
            this.validateNumberOfAvailableTestSuites();
        }
        this.setEnabledStatus();
    }

    private void validateNumberOfAvailableTestSuites() {
        SortedSet<ITestSuitePO> allTestSuites = this.getAllTestSuites();
        this.m_atLeastOneTsAvailable = allTestSuites.size() >= 1;
    }

    private void init() {
        DataEventDispatcher dataEventDispatcher = DataEventDispatcher.getInstance();
        dataEventDispatcher.addProjectLoadedListener(this.m_projLoadedListener, true);
        dataEventDispatcher.addDataChangedListener(this.m_currentProjDeletedListener, true);
        dataEventDispatcher.addAutStateListener(this.m_autStateListener, true);
        dataEventDispatcher.addLanguageChangedListener(this.m_langChangedListener, true);
        dataEventDispatcher.addProjectPropertiesModifyListener(this.m_projPropModifyListener, true);
        dataEventDispatcher.addTestSuiteStateListener(this.m_testSuiteStateListener, true);
        dataEventDispatcher.addOMStateListener(this.m_omStateListener, true);
        dataEventDispatcher.addRecordModeStateListener(this.m_recordModeStateListener, true);
        dataEventDispatcher.addDataChangedListener(this.m_dataChangedListener, true);
    }

    public void runTestSuite(ITestSuitePO ts, AutIdentifier autId, boolean autoScreenshot) {
        TestSuiteState state = this.validateSaveState(ts);
        if (state != TestSuiteState.incomplete) {
            this.executeTestSuite(ts, autId, autoScreenshot);
        }
    }

    public TestSuiteState validateSaveState(ITestSuitePO ts) {
        boolean isSaved;
        if (Plugin.getDefault().anyDirtyStar() && (isSaved = Plugin.getDefault().showSaveEditorDialog())) {
            SortedSet<ITestSuitePO> allTestSuites = this.getAllTestSuites();
            if (allTestSuites.contains(ts)) {
                return TestSuiteState.complete;
            }
            return TestSuiteState.incomplete;
        }
        return TestSuiteState.unchanged;
    }

    public void executeTestSuite(ITestSuitePO tsToStart, AutIdentifier autId, boolean autoScreenshot) {
        if (!Utils.openPerspective("org.eclipse.jubula.client.ui.rcp.perspectives.ExecutionPerspective")) {
            return;
        }
        TestExecutionGUIController.startTestSuite(tsToStart, autId, autoScreenshot);
        ChooseTestSuiteBP.getInstance().setLastUsedTestSuite(tsToStart);
        ChooseTestSuiteBP.getInstance().setLastUsedAUT(autId);
    }

    public void setLastUsedAUT(AutIdentifier lastUsedAUT) {
        this.m_lastUsedAUT = lastUsedAUT;
    }

    public AutIdentifier getLastUsedAUT() {
        return this.m_lastUsedAUT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestSuiteState {
        unchanged,
        complete,
        incomplete;

    }
}

