/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.contributionitems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ChooseTestSuiteBP;
import org.eclipse.jubula.client.ui.rcp.contributionitems.NodePOComparator;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunningAutsStartTestSuiteContributionItem
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        ArrayList<Object> contributionItems = new ArrayList<Object>();
        Collection<AutIdentifier> selectedAutIds = RunningAutsStartTestSuiteContributionItem.getSelectedRunningAuts();
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null) {
            if (selectedAutIds.isEmpty()) {
                selectedAutIds.addAll(AutAgentRegistration.getInstance().getRegisteredAuts());
            }
            Map runningAuts = AutAgentRegistration.getRunningAuts((IProjectPO)currentProject, selectedAutIds);
            HashSet<ITestSuitePO> startableSuites = new HashSet<ITestSuitePO>();
            for (ITestSuitePO suite : TestSuiteBP.getListOfTestSuites((IProjectPO)currentProject)) {
                if (!runningAuts.keySet().contains(suite.getAut()) || !ChooseTestSuiteBP.getInstance().isTestSuiteStartable(suite)) continue;
                startableSuites.add(suite);
            }
            ArrayList startableSuiteList = new ArrayList(startableSuites);
            Collections.sort(startableSuiteList, new NodePOComparator());
            for (ITestSuitePO suite : startableSuiteList) {
                Collection autIds = (Collection)runningAuts.get(suite.getAut());
                if (autIds != null) {
                    for (AutIdentifier autId : autIds) {
                        IContributionItem item = RunningAutsStartTestSuiteContributionItem.createItem(suite, autId);
                        contributionItems.add(item);
                    }
                }
                contributionItems.add(new Separator());
            }
        }
        if (!contributionItems.isEmpty()) {
            contributionItems.remove(contributionItems.size() - 1);
        }
        return contributionItems.toArray(new IContributionItem[contributionItems.size()]);
    }

    private static Collection<AutIdentifier> getSelectedRunningAuts() {
        ISelectionService selectionService;
        ISelection sel;
        HashSet<AutIdentifier> selectedRunningAuts = new HashSet<AutIdentifier>();
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (sel = (selectionService = activeWindow.getSelectionService()).getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSel = (IStructuredSelection)sel;
            Object[] objectArray = structuredSel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObj = objectArray[n2];
                if (selectedObj instanceof AutIdentifier) {
                    selectedRunningAuts.add((AutIdentifier)selectedObj);
                }
                ++n2;
            }
        }
        return selectedRunningAuts;
    }

    private static IContributionItem createItem(ITestSuitePO suiteToStart, AutIdentifier autId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("org.eclipse.jubula.client.ui.rcp.commands.StartTestSuiteCommand.parameter.testSuiteToStart", suiteToStart);
        params.put("org.eclipse.jubula.client.ui.rcp.commands.StartTestSuiteCommand.parameter.runningAut", autId);
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append(suiteToStart.getAut().getName()).append(" ").append("(").append(autId.getExecutableName()).append(")").append(" ").append(":").append(" ").append(suiteToStart.getName());
        return CommandHelper.createContributionItem((String)"org.eclipse.jubula.client.ui.rcp.commands.StartTestSuiteCommand", params, (String)labelBuilder.toString(), (int)32);
    }
}

