/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractGuiNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.IPropertyController;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertySource<GUINODE_TYPE>
implements IPropertySource {
    public static final Image DEFAULT_IMAGE = null;
    public static final Image DEPRECATED_IMAGE = IconConstants.DEPRECATED_IMAGE;
    public static final Image READONLY_IMAGE = IconConstants.READ_ONLY_IMAGE;
    public static final Image INCOMPL_DATA_IMAGE = IconConstants.INCOMPLETE_DATA_IMAGE;
    public static final Image WARNING_IMAGE = IconConstants.WARNING_IMAGE;
    private List<IPropertyDescriptor> m_propDescriptors = new ArrayList<IPropertyDescriptor>();
    private GUINODE_TYPE m_guiNode;

    public AbstractPropertySource(GUINODE_TYPE guiNode) {
        this.m_guiNode = guiNode;
    }

    protected void addPropertyDescriptor(IPropertyDescriptor propDescr) {
        this.m_propDescriptors.add(propDescr);
    }

    protected void addPropertyDescriptor(Collection<IPropertyDescriptor> propDescriptors) {
        this.m_propDescriptors.addAll(propDescriptors);
    }

    protected void clearPropertyDescriptors() {
        this.m_propDescriptors.clear();
    }

    protected abstract void initPropDescriptor();

    public IPropertyDescriptor[] getPropertyDescriptors() {
        this.initPropDescriptor();
        IPropertyDescriptor[] propdescr = this.m_propDescriptors.toArray(new IPropertyDescriptor[this.m_propDescriptors.size()]);
        return propdescr;
    }

    protected List<IPropertyDescriptor> getPropertyDescriptorList() {
        return this.m_propDescriptors;
    }

    protected IPropertyDescriptor getPropertyDescriptorById(IPropertyController id) {
        for (IPropertyDescriptor descriptor : this.getPropertyDescriptorList()) {
            if (id != descriptor.getId()) continue;
            return descriptor;
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        if (id instanceof IPropertyController) {
            IPropertyController pc = (IPropertyController)id;
            pc.setProperty(value);
        } else {
            Assert.notReached((String)(String.valueOf(Messages.PropertyIDInexistent) + ":" + " " + id));
        }
        this.initPropDescriptor();
        DataEventDispatcher.getInstance().firePropertyChanged(false);
        DataEventDispatcher.getInstance().fireParamChangedListener();
    }

    public Object getPropertyValue(Object id) {
        Object obj = null;
        if (id instanceof IPropertyController) {
            obj = ((IPropertyController)id).getProperty();
            return obj != null ? obj : "";
        }
        Assert.notReached((String)(String.valueOf(Messages.PropertyIDInexistent) + ":" + " " + id));
        return obj;
    }

    public Object getEditableValue() {
        return this;
    }

    public void resetPropertyValue(Object id) {
    }

    protected void checkEntrySets(IParamNodePO nodePo) {
        Locale locale = WorkingLanguageBP.getInstance().getWorkingLanguage();
        boolean bool = nodePo.isTestDataComplete(locale);
        CompletenessGuard.setCompFlagForTD((IParamNodePO)nodePo, (Locale)locale, (boolean)bool);
    }

    protected GUINODE_TYPE getGuiNode() {
        return this.m_guiNode;
    }

    public static abstract class AbstractPropertyController
    implements IPropertyController {
        private AbstractGuiNodePropertySource m_propertySource;

        public AbstractPropertyController(AbstractGuiNodePropertySource s) {
            this.setPropertySource(s);
        }

        public AbstractPropertyController() {
        }

        public Image getImage(Object value) {
            if (value == null || "".equals(value)) {
                return INCOMPL_DATA_IMAGE;
            }
            return DEFAULT_IMAGE;
        }

        public Image getImage() {
            return this.getImage(this.getProperty());
        }

        public AbstractGuiNodePropertySource getPropertySource() {
            return this.m_propertySource;
        }

        public void setPropertySource(AbstractGuiNodePropertySource propertySource) {
            this.m_propertySource = propertySource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DummyController
    extends AbstractPropertyController {
        protected DummyController() {
        }

        @Override
        public boolean setProperty(Object value) {
            return true;
        }

        @Override
        public Object getProperty() {
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }
}

