/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.MonitoringValuePM;
import org.eclipse.jubula.tools.objects.IMonitoringValue;
import org.eclipse.jubula.tools.objects.MonitoringValue;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class MonitoringValuePropertySource
implements IPropertySource {
    private IPropertyDescriptor[] m_descriptors = null;
    private Map<String, IMonitoringValue> m_monitoringValueMap = null;

    public MonitoringValuePropertySource(ITestResultSummaryPO summary) {
        Long id = summary.getId();
        this.m_monitoringValueMap = MonitoringValuePM.loadMonitoringValues((Object)id);
    }

    public Object getEditableValue() {
        return "editableValue";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        LinkedList<PropertyDescriptor> tmpList = new LinkedList<PropertyDescriptor>();
        for (Map.Entry<String, IMonitoringValue> pairs : this.m_monitoringValueMap.entrySet()) {
            MonitoringValue tmp = (MonitoringValue)pairs.getValue();
            PropertyDescriptor p = new PropertyDescriptor((Object)pairs.getKey(), pairs.getKey());
            if (!tmp.getCategory().equals("NO_CATEGORY")) {
                p.setCategory(tmp.getCategory());
            }
            tmpList.add(p);
        }
        this.m_descriptors = tmpList.toArray(new IPropertyDescriptor[tmpList.size()]);
        return this.m_descriptors;
    }

    public Object getPropertyValue(Object id) {
        IMonitoringValue m = this.m_monitoringValueMap.get(id);
        if (m.getType().equals("PERCENT")) {
            DecimalFormat n = new DecimalFormat("0.0#%");
            Double doubleValue = Double.valueOf(m.getValue());
            return StringUtils.defaultString((String)n.format(doubleValue));
        }
        return m.getValue();
    }

    public boolean isPropertySet(Object arg0) {
        return false;
    }

    public void resetPropertyValue(Object arg0) {
    }

    public void setPropertyValue(Object arg0, Object arg1) {
    }
}

