/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.factory;

import org.eclipse.jubula.client.core.model.IDocAttributeDescriptionPO;
import org.eclipse.jubula.client.ui.rcp.attribute.EmptyAttributeRenderer;
import org.eclipse.jubula.client.ui.rcp.attribute.ErrorRenderer;
import org.eclipse.jubula.client.ui.rcp.attribute.IAttributeRenderer;

public class AttributeRendererFactory {
    private AttributeRendererFactory() {
    }

    public static IAttributeRenderer getRenderer(IDocAttributeDescriptionPO attributeDescription) {
        try {
            Class<?> displayClass = Class.forName(attributeDescription.getDisplayClassName());
            Object instance = displayClass.newInstance();
            if (instance instanceof IAttributeRenderer) {
                return (IAttributeRenderer)instance;
            }
            return new EmptyAttributeRenderer();
        }
        catch (ClassNotFoundException e) {
            return new ErrorRenderer(e);
        }
        catch (InstantiationException e) {
            return new ErrorRenderer(e);
        }
        catch (IllegalAccessException e) {
            return new ErrorRenderer(e);
        }
    }
}

