/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractNewComponentNameHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewLogicalNameHandler
extends AbstractNewComponentNameHandler {
    public Object execute(ExecutionEvent event) {
        ObjectMappingMultiPageEditor omEditor;
        IWritableComponentNameMapper compNameMapper;
        String newName;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof ObjectMappingMultiPageEditor && (newName = this.openDialog((IComponentNameMapper)(compNameMapper = (omEditor = (ObjectMappingMultiPageEditor)activePart).getEditorHelper().getEditSupport().getCompMapper()), HandlerUtil.getActiveShell((ExecutionEvent)event))) != null) {
            if (omEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                return null;
            }
            this.performOperation(omEditor, newName);
        }
        return null;
    }

    private void performOperation(ObjectMappingMultiPageEditor omEditor, String newName) {
        IObjectMappingPO objMap = omEditor.getAut().getObjMap();
        IWritableComponentNameMapper mapper = omEditor.getEditorHelper().getEditSupport().getCompMapper();
        try {
            IObjectMappingAssoziationPO assoc = PoMaker.createObjectMappingAssoziationPO(null, new ArrayList());
            mapper.changeReuse((IComponentNameReuser)assoc, null, this.performOperation(newName, mapper).getGuid());
            objMap.getUnmappedLogicalCategory().addAssociation(assoc);
            omEditor.logicalNameAdded();
            omEditor.getEditorHelper().setDirty(true);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)objMap.getUnmappedLogicalCategory(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
            omEditor.getTreeViewer().setExpandedState((Object)objMap.getUnmappedLogicalCategory(), true);
        }
        catch (IncompatibleTypeException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), (Object[])e.getErrorMessageParams(), null);
        }
        catch (PMException pme) {
            PMExceptionHandler.handlePMExceptionForEditor(pme, omEditor);
        }
    }
}

