/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.IRecordListener;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.commands.CAPRecordedCommand;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractRunningAutHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.KeyConverter;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartObservationModeHandler
extends AbstractRunningAutHandler {
    public static final String RUNNING_AUT = "org.eclipse.jubula.client.ui.rcp.commands.StartObservationModeCommand.parameter.runningAut";
    private static final Logger LOG = LoggerFactory.getLogger(StartObservationModeHandler.class);

    public Object execute(ExecutionEvent event) {
        AutIdentifier runningAut = this.getRunningAut(event, RUNNING_AUT);
        if (!Utils.openPerspective("org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective")) {
            return null;
        }
        TestCaseEditor editor = Plugin.getActiveEditor() instanceof TestCaseEditor ? (TestCaseEditor)Plugin.getActiveEditor() : this.askForNewTC();
        if (editor != null && editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
            this.setEditor(editor, runningAut);
        }
        return null;
    }

    private TestCaseEditor askForNewTC() {
        TestCaseEditor editor = null;
        String standardName = "Observed";
        int index = 1;
        String newName = String.valueOf(standardName) + index;
        HashSet<String> usedNames = new HashSet<String>();
        for (Object node : GeneralStorage.getInstance().getProject().getSpecObjCont().getSpecObjList()) {
            if (!Persistor.isPoSubclass((IPersistentObject)((INodePO)node), ITestCasePO.class) || !((INodePO)node).getName().startsWith(standardName)) continue;
            usedNames.add(((INodePO)node).getName());
        }
        while (usedNames.contains(newName)) {
            newName = String.valueOf(standardName) + ++index;
        }
        InputDialog dialog = this.createDialog(newName, usedNames);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogObsTestcaseSaveContextId");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String tcName = dialog.getName();
            ICategoryPO parentPO = ISpecObjContPO.TCB_ROOT_NODE;
            ISpecTestCasePO recSpecTestCase = NodeMaker.createSpecTestCasePO((String)tcName);
            try {
                NodePM.addAndPersistChildNode((INodePO)parentPO, (INodePO)recSpecTestCase, null, (NodePM.AbstractCmdHandleChild)NodePM.getCmdHandleChild((INodePO)parentPO, (INodePO)recSpecTestCase));
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)recSpecTestCase, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
                editor = (TestCaseEditor)AbstractOpenHandler.openEditor((IPersistentObject)recSpecTestCase);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleGDProjectDeletedException();
            }
        }
        dialog.close();
        return editor;
    }

    private void setEditor(TestCaseEditor editor, AutIdentifier autId) {
        if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            editor.getEditorHelper().setDirty(true);
        }
        int recordCompMods = Plugin.getDefault().getPreferenceStore().getInt("RECORDMOD1_PREF_KEY");
        int recordCompKey = Plugin.getDefault().getPreferenceStore().getInt("RECORDMOD2_PREF_KEY");
        int recordApplMods = Plugin.getDefault().getPreferenceStore().getInt("RECORDMOD3_PREF_KEY");
        int recordApplKey = Plugin.getDefault().getPreferenceStore().getInt("RECORDMOD4_PREF_KEY");
        int checkModeMods = Plugin.getDefault().getPreferenceStore().getInt("CHECKMODE_MODS_PREF_KEY");
        int checkModeKey = Plugin.getDefault().getPreferenceStore().getInt("CHECKMODE_KEY_PREF_KEY");
        int checkCompMods = Plugin.getDefault().getPreferenceStore().getInt("CHECKCOMP_MODS_PREF_KEY");
        int checkCompKey = Plugin.getDefault().getPreferenceStore().getInt("CHECKCOMP_KEY_PREF_KEY");
        boolean dialogOpen = Plugin.getDefault().getPreferenceStore().getBoolean("SHOWRECORDDIALOG_PREF_KEY");
        TreeSet<String> singleLineTrigger = new TreeSet();
        TreeSet<String> multiLineTrigger = new TreeSet();
        try {
            singleLineTrigger = org.eclipse.jubula.client.ui.preferences.utils.Utils.decodeStringToSet((String)Plugin.getDefault().getPreferenceStore().getString("SINGLELINETRIGGER_PREF_KEY"), (String)";");
            multiLineTrigger = org.eclipse.jubula.client.ui.preferences.utils.Utils.decodeStringToSet((String)Plugin.getDefault().getPreferenceStore().getString("MULTILINETRIGGER_PREF_KEY"), (String)";");
        }
        catch (JBException e) {
            e.printStackTrace();
        }
        Locale localeForRecord = WorkingLanguageBP.getInstance().getWorkingLanguage();
        ISpecTestCasePO workCopy = (ISpecTestCasePO)editor.getEditorHelper().getEditSupport().getWorkVersion();
        IWritableComponentNameMapper compNamesMapper = editor.getEditorHelper().getEditSupport().getCompMapper();
        StartObservationModeJob startObservationModeJob = new StartObservationModeJob(workCopy, compNamesMapper, recordCompMods, recordCompKey, recordApplMods, recordApplKey, checkModeMods, checkModeKey, checkCompMods, checkCompKey, dialogOpen, singleLineTrigger, multiLineTrigger, localeForRecord, editor, autId);
        startObservationModeJob.setSystem(true);
        JobUtils.executeJob((Job)startObservationModeJob, null);
    }

    private InputDialog createDialog(String newName, final Set<String> usedNames) {
        InputDialog dialog = new InputDialog(Plugin.getShell(), Messages.RecordTestCaseActionTCTitle, newName, Messages.RecordTestCaseActionTCMessage, Messages.RecordTestCaseActionTCLabel, Messages.RenameActionTCError, Messages.RecordTestCaseActionDoubleTCName, "recordTestCaseDialog.gif", Messages.RecordTestCaseActionTCShell, false){

            protected boolean isInputAllowed() {
                if (usedNames.contains(this.getInputFieldText())) {
                    return false;
                }
                return super.isInputAllowed();
            }
        };
        return dialog;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StartObservationModeJob
    extends Job {
        private ISpecTestCasePO m_workCopy;
        private IWritableComponentNameMapper m_compNamesMapper;
        private int m_checkModeMods;
        private int m_checkModeKey;
        private int m_checkCompMods;
        private int m_checkCompKey;
        private int m_recordCompMods;
        private int m_recordCompKey;
        private int m_recordApplMods;
        private int m_recordApplKey;
        private boolean m_dialogOpen;
        private SortedSet<String> m_singleLineTrigger;
        private SortedSet<String> m_multiLineTrigger;
        private Locale m_localeForRecord;
        private TestCaseEditor m_editor;
        private AutIdentifier m_autId;

        public StartObservationModeJob(ISpecTestCasePO workCopy, IWritableComponentNameMapper compNamesMapper, int recordCompMods, int recordCompKey, int recordApplMods, int recordApplKey, int checkModeMods, int checkModeKey, int checkCompMods, int checkCompKey, boolean dialogOpen, SortedSet<String> singleLineTrigger, SortedSet<String> multiLineTrigger, Locale localeForRecord, TestCaseEditor editor, AutIdentifier autId) {
            super("Start Observation Mode");
            this.m_workCopy = workCopy;
            this.m_compNamesMapper = compNamesMapper;
            this.m_recordCompMods = recordCompMods;
            this.m_recordCompKey = recordCompKey;
            this.m_recordApplMods = recordApplMods;
            this.m_recordApplKey = recordApplKey;
            this.m_checkModeMods = checkModeMods;
            this.m_checkModeKey = checkModeKey;
            this.m_checkCompMods = checkCompMods;
            this.m_checkCompKey = checkCompKey;
            this.m_dialogOpen = dialogOpen;
            this.m_singleLineTrigger = singleLineTrigger;
            this.m_multiLineTrigger = multiLineTrigger;
            this.m_localeForRecord = localeForRecord;
            this.m_editor = editor;
            this.m_autId = autId;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (AUTConnection.getInstance().connectToAut(this.m_autId, (IProgressMonitor)new NullProgressMonitor())) {
                    String toolkit = TestExecution.getInstance().getConnectedAut().getToolkit();
                    if (toolkit.equals("com.bredexsw.guidancer.SwtToolkitPlugin") || toolkit.equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
                        this.m_checkModeMods = KeyConverter.convertSwingStateMask(this.m_checkModeMods);
                        this.m_checkModeKey = KeyConverter.convertSwingToSwt(this.m_checkModeKey);
                        this.m_checkCompMods = KeyConverter.convertSwingStateMask(this.m_checkCompMods);
                        this.m_checkCompKey = KeyConverter.convertSwingToSwt(this.m_checkCompKey);
                    }
                    TestExecutionContributor.getInstance().getClientTest().startRecordTestCase(this.m_workCopy, this.m_compNamesMapper, this.m_recordCompMods, this.m_recordCompKey, this.m_recordApplMods, this.m_recordApplKey, this.m_checkModeMods, this.m_checkModeKey, this.m_checkCompMods, this.m_checkCompKey, this.m_dialogOpen, this.m_singleLineTrigger, this.m_multiLineTrigger, this.m_localeForRecord);
                }
            }
            catch (CommunicationException ce) {
                LOG.error(ce.getMessage());
            }
            CAPRecordedCommand.setRecordListener((IRecordListener)this.m_editor);
            DataEventDispatcher.getInstance().fireRecordModeStateChanged(DataEventDispatcher.RecordModeState.running);
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof StartObservationModeHandler) {
                return true;
            }
            return super.belongsTo(family);
        }
    }
}

