/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.open;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.events.InteractionEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public abstract class AbstractOpenHandler
extends AbstractHandler {
    public INodePO findEditableNode(INodePO selected) {
        INodePO candidate = selected;
        while (candidate != null && !this.isEditableImpl(candidate)) {
            candidate = candidate.getParentNode();
        }
        return candidate;
    }

    protected boolean isEditableImpl(INodePO selected) {
        return true;
    }

    protected void openEditorForSpecTC(ISpecTestCasePO specTc) {
        boolean isNodeEditable = TestCaseBP.belongsToCurrentProject((ISpecTestCasePO)specTc);
        if (isNodeEditable) {
            AbstractOpenHandler.openEditor((IPersistentObject)specTc);
            InteractionEventDispatcher.getDefault().fireProgammableSelectionEvent((IStructuredSelection)new StructuredSelection((Object)specTc));
        } else {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NON_EDITABLE_NODE);
        }
    }

    private static IEditorInput createEditorInput(IPersistentObject node) throws PMException {
        if (Persistor.isPoSubclass((IPersistentObject)node, INodePO.class)) {
            return new NodeEditorInput((INodePO)node);
        }
        return new PersistableEditorInput(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IEditorPart openEditor(IPersistentObject node) {
        if (node == null) return null;
        if (!Utils.openPerspective("org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective")) {
            return null;
        }
        try {
            IEditorInput input = AbstractOpenHandler.createEditorInput(node);
            String editorId = AbstractOpenHandler.getEditorId(node);
            IWorkbenchPage page = Plugin.getActivePage();
            IEditorPart editor = page.findEditor(input);
            if (editor == null) {
                try {
                    return page.openEditor(input, editorId);
                }
                catch (PartInitException e) {
                    if (e.getStatus().getSeverity() == 8) return editor;
                    String msg = String.valueOf(Messages.EditorCanNotBeOpened) + ".";
                    throw new JBFatalException(msg, (Throwable)e, MessageIDs.E_CANNOT_OPEN_EDITOR);
                }
            }
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
            return editor;
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForEditor(e, null);
            return null;
        }
    }

    protected static String getEditorId(Object node) {
        if (node instanceof ISpecTestCasePO || node instanceof ISpecTestCasePO) {
            return "org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor";
        }
        if (node instanceof ITestSuitePO) {
            return "org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor";
        }
        if (node instanceof IAUTMainPO) {
            return "org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingEditor";
        }
        if (node instanceof ITestJobPO) {
            return "org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor";
        }
        if (node instanceof ITestDataCategoryPO) {
            return "org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor";
        }
        Assert.notReached();
        return "";
    }
}

