/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ExportAllBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAllHandler
extends AbstractProjectHandler {
    private static Logger log = LoggerFactory.getLogger(ExportAllHandler.class);

    private void showExportDialog() {
        String dirName;
        DirectoryDialog dirDialog = new DirectoryDialog(Plugin.getShell(), 65536);
        dirDialog.setText(Messages.ActionBuilderExportAll);
        dirDialog.setFilterPath(Utils.getLastDirPath());
        boolean done = false;
        String tempDirName = null;
        while (!done) {
            tempDirName = dirDialog.open();
            Plugin.startLongRunning(Messages.ExportFileActionWaitWhileExporting);
            if (tempDirName == null) {
                done = true;
                Plugin.stopLongRunning();
            } else {
                File dir = new File(tempDirName);
                if (dir.list().length > 0) {
                    MessageBox mb = new MessageBox(dirDialog.getParent(), 40);
                    mb.setMessage(NLS.bind((String)Messages.ExportAllActionDirectoryNotEmpty, (Object)tempDirName));
                    mb.open();
                } else {
                    done = true;
                }
            }
            dirDialog.setFilterPath(tempDirName);
        }
        if (tempDirName != null && tempDirName.charAt(tempDirName.length() - 1) != '/') {
            tempDirName = String.valueOf(tempDirName) + "/";
        }
        if ((dirName = tempDirName) != null) {
            ExportOperation op = new ExportOperation(dirName, dirDialog);
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
            }
            catch (InvocationTargetException ite) {
                log.error("An error occured: ", ite.getCause());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Object executeImpl(ExecutionEvent event) {
        if (GeneralStorage.getInstance().getProject() != null && Plugin.getDefault().anyDirtyStar()) {
            if (Plugin.getDefault().showSaveEditorDialog()) {
                this.showExportDialog();
            }
            return null;
        }
        this.showExportDialog();
        return null;
    }

    private static class ExportOperation
    implements IRunnableWithProgress {
        private String m_dirName;
        private DirectoryDialog m_dirDialog;

        public ExportOperation(String dirName, DirectoryDialog dirDialog) {
            this.m_dirName = dirName;
            this.m_dirDialog = dirDialog;
        }

        public void run(IProgressMonitor monitor) {
            if (this.m_dirName != null) {
                ExportAllBP.getInstance().showStartingExport();
                Persistor hib = Persistor.instance();
                EntityManager exportSession = null;
                boolean nodeCacheIsUsed = NodePM.getInstance().isUseCache();
                if (!nodeCacheIsUsed) {
                    NodePM.getInstance().setUseCache(true);
                }
                try {
                    try {
                        exportSession = hib.openSession();
                        List allProjects = ProjectPM.findAllProjects((EntityManager)exportSession);
                        ExportAllBP.getInstance().exportProjectList(allProjects, this.m_dirName, exportSession, monitor, false, null);
                        Utils.storeLastDirPath(this.m_dirDialog.getFilterPath());
                        ExportAllBP.getInstance().showFinishedExport();
                    }
                    catch (JBException gde) {
                        log.error(Messages.ExportAborted, (Throwable)gde);
                        ExportAllBP.getInstance().showAbortExport(gde);
                        if (!nodeCacheIsUsed) {
                            NodePM.getInstance().setUseCache(false);
                        }
                        hib.dropSession(exportSession);
                        Plugin.stopLongRunning();
                        monitor.done();
                    }
                    catch (InterruptedException interruptedException) {
                        block12: {
                            ExportAllBP.getInstance().showCancelExport();
                            if (nodeCacheIsUsed) break block12;
                            NodePM.getInstance().setUseCache(false);
                        }
                        hib.dropSession(exportSession);
                        Plugin.stopLongRunning();
                        monitor.done();
                    }
                }
                finally {
                    if (!nodeCacheIsUsed) {
                        NodePM.getInstance().setUseCache(false);
                    }
                    hib.dropSession(exportSession);
                    Plugin.stopLongRunning();
                    monitor.done();
                }
            }
        }
    }
}

