/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.properties;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.properties.AbstractProjectPropertyPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentExtensionPropertyPage
extends AbstractProjectPropertyPage {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentExtensionPropertyPage.class);

    public ComponentExtensionPropertyPage(EditSupport es) {
        super(es);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        ListViewer viewer = new ListViewer(composite);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput((Object)this.getProject().getProjectProperties().getSimpleExtensionClassNames());
        GridDataFactory.generate((Control)viewer.getControl(), (int)1, (int)1);
        Button addButton = this.createAddButton(composite, viewer);
        final Button editButton = this.createEditButton(composite, viewer);
        final Button removeButton = this.createRemoveButton(composite, viewer);
        GridDataFactory.generate((Control)addButton, (int)1, (int)1);
        GridDataFactory.generate((Control)editButton, (int)1, (int)1);
        GridDataFactory.generate((Control)removeButton, (int)1, (int)1);
        editButton.setEnabled(false);
        removeButton.setEnabled(false);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                removeButton.setEnabled(!selection.isEmpty());
                editButton.setEnabled(selection.size() == 1);
            }
        });
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.projectSettingsPageContextId");
        return composite;
    }

    private Button createAddButton(Composite composite, final ListViewer viewer) {
        Button addButton = new Button(composite, 0);
        addButton.setText(Messages.ComponentExtensions_AddButton_Text);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(ComponentExtensionPropertyPage.this.getShell(), Messages.ComponentExtensionDialog_Title, Messages.ComponentExtensionDialog_Message, "", null);
                if (dialog.open() == 0) {
                    if (ComponentExtensionPropertyPage.this.getProject().getProjectProperties().addSimpleExtensionClassName(dialog.getValue())) {
                        viewer.add((Object)dialog.getValue());
                    }
                    viewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getValue()));
                }
            }
        });
        return addButton;
    }

    private Button createEditButton(Composite composite, final ListViewer viewer) {
        Button editButton = new Button(composite, 0);
        editButton.setText(Messages.ComponentExtensions_EditButton_Text);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedObj = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
                if (!(selectedObj instanceof String)) {
                    LOG.error("Component Extension Property Page: Selected object for editing not of expected type.");
                    return;
                }
                String originalName = (String)selectedObj;
                InputDialog dialog = new InputDialog(ComponentExtensionPropertyPage.this.getShell(), Messages.ComponentExtensionEditDialog_Title, Messages.ComponentExtensionEditDialog_Message, originalName, null);
                if (dialog.open() == 0) {
                    ComponentExtensionPropertyPage.this.getProject().getProjectProperties().removeSimpleExtensionClassName(originalName);
                    viewer.remove((Object)originalName);
                    if (ComponentExtensionPropertyPage.this.getProject().getProjectProperties().addSimpleExtensionClassName(dialog.getValue())) {
                        viewer.add((Object)dialog.getValue());
                    }
                    viewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getValue()));
                }
            }
        });
        return editButton;
    }

    private Button createRemoveButton(Composite composite, final ListViewer viewer) {
        Button removeButton = new Button(composite, 0);
        removeButton.setText(Messages.ComponentExtensions_RemoveButton_Text);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selectionArray;
                Object[] objectArray = selectionArray = ((IStructuredSelection)viewer.getSelection()).toArray();
                int n = selectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selectedObj = objectArray[n2];
                    String selectedName = (String)selectedObj;
                    ComponentExtensionPropertyPage.this.getProject().getProjectProperties().removeSimpleExtensionClassName(selectedName);
                    ++n2;
                }
                viewer.remove(selectionArray);
            }
        });
        return removeButton;
    }

    public boolean performOk() {
        return super.performOk();
    }
}

