/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.propertytester;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.ui.rcp.propertytester.AbstractBooleanPropertyTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterInterfacePropertyTester
extends AbstractBooleanPropertyTester {
    private static final String HAS_MULTIPLE_DATA_SETS_PROPERTY = "hasMultipleDataSets";
    private static final String USES_CTDS_PROPERTY = "usesCTDS";
    private static final String USES_EXCEL_PROPERTY = "usesExcel";
    private static final String[] PROPERTIES = new String[]{"usesExcel", "usesCTDS", "hasMultipleDataSets"};

    @Override
    public boolean testImpl(Object receiver, String property, Object[] args) {
        IParameterInterfacePO paramInterface = (IParameterInterfacePO)receiver;
        if (property.equals(USES_CTDS_PROPERTY)) {
            return this.testUsesCTDS(paramInterface);
        }
        if (property.equals(USES_EXCEL_PROPERTY)) {
            return this.testUsesExcel(paramInterface);
        }
        if (property.equals(HAS_MULTIPLE_DATA_SETS_PROPERTY)) {
            return this.testHasMultipleDataSets(paramInterface);
        }
        return false;
    }

    private boolean testHasMultipleDataSets(IParameterInterfacePO paramInterface) {
        return paramInterface.getDataManager().getDataSetCount() > 1;
    }

    private boolean testUsesExcel(IParameterInterfacePO paramInterface) {
        return !StringUtils.isEmpty((String)paramInterface.getDataFile());
    }

    private boolean testUsesCTDS(IParameterInterfacePO paramInterface) {
        return paramInterface.getReferencedDataCube() != null;
    }

    @Override
    public Class<? extends Object> getType() {
        return IParameterInterfacePO.class;
    }

    @Override
    public String[] getProperties() {
        return PROPERTIES;
    }
}

