/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.labelprovider;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.constants.RcpIconConstants;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class GeneralLabelProvider
extends ColumnLabelProvider
implements IColorProvider,
ILabelProvider {
    public static final String CLOSE_BRACKED = "]";
    public static final String OPEN_BRACKED = " [";
    public static final String SEPARATOR = "; ";
    private static final String UNNAMED_NODE = Messages.GeneralGDLabelProviderUnnamedNode;
    private static final String COMMENT_PREFIX = String.valueOf(Messages.AbstractGuiNodePropertySourceComment) + ":" + " ";
    private static final Color DISABLED_COLOR = LayoutUtil.GRAY_COLOR;
    private static final Color REUSED_PROJECTS_COLOR = Display.getDefault().getSystemColor(9);
    private static Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());

    public void dispose() {
    }

    public String getText(Object element) {
        return GeneralLabelProvider.getGDText(element);
    }

    public Image getImage(Object element) {
        IStructuredSelection sel;
        Object cbContents;
        Image image = GeneralLabelProvider.getGDImage(element);
        if (element instanceof INodePO && ((INodePO)element).isGenerated()) {
            image = IconConstants.getGeneratedImage((Image)image);
        }
        if ((cbContents = clipboard.getContents((Transfer)LocalSelectionClipboardTransfer.getInstance())) instanceof IStructuredSelection && (sel = (IStructuredSelection)cbContents).toList().contains(element)) {
            image = RcpIconConstants.getCutImage(image);
        }
        return image;
    }

    public String getToolTipText(Object element) {
        if (element instanceof INodePO) {
            INodePO node = (INodePO)element;
            StringBuilder toolTip = new StringBuilder();
            String comment = node.getComment();
            if (!StringUtils.isBlank((String)comment)) {
                toolTip.append(COMMENT_PREFIX);
                toolTip.append(ObjectUtils.toString((Object)comment));
                return toolTip.toString();
            }
        }
        return super.getToolTipText(element);
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 50;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }

    public Image getToolTipImage(Object object) {
        String tooltipText = this.getToolTipText(object);
        if (tooltipText != null) {
            if (tooltipText.startsWith(COMMENT_PREFIX)) {
                return IconConstants.INFO_IMAGE;
            }
            return IconConstants.ERROR_IMAGE;
        }
        return super.getToolTipImage(object);
    }

    public static String getGDText(Object element) {
        if (element instanceof INodePO) {
            INodePO node = (INodePO)element;
            if (node.getName() == null) {
                return UNNAMED_NODE;
            }
            if (node instanceof ICapPO) {
                return GeneralLabelProvider.getText((ICapPO)node);
            }
            if (node instanceof IExecTestCasePO) {
                return GeneralLabelProvider.getText((IExecTestCasePO)node);
            }
            if (node instanceof ISpecTestCasePO) {
                return GeneralLabelProvider.getText((ISpecTestCasePO)node);
            }
            return node.getName();
        }
        if (element instanceof IReusedProjectPO) {
            IReusedProjectPO reusedProject = (IReusedProjectPO)element;
            String projectName = reusedProject.getProjectName();
            if (projectName == null) {
                projectName = reusedProject.getProjectGuid();
            }
            return String.valueOf(projectName) + reusedProject.getVersionString();
        }
        if (element instanceof ISpecObjContPO) {
            return Messages.TreeBuilderTestCases;
        }
        if (element instanceof IExecObjContPO) {
            return GeneralStorage.getInstance().getProject().getName();
        }
        return element == null ? "" : element.toString();
    }

    public static Image getGDImage(Object element) {
        if (element instanceof ITestSuitePO) {
            ITestSuitePO testSuite = (ITestSuitePO)element;
            Locale workLang = WorkingLanguageBP.getInstance().getWorkingLanguage();
            if (testSuite.getAut() != null && !WorkingLanguageBP.getInstance().isTestSuiteLanguage(workLang, testSuite)) {
                return IconConstants.TS_DISABLED_IMAGE;
            }
            return IconConstants.TS_IMAGE;
        }
        if (element instanceof ICapPO) {
            return IconConstants.CAP_IMAGE;
        }
        if (element instanceof IExecObjContPO) {
            return IconConstants.PROJECT_IMAGE;
        }
        if (element instanceof IEventExecTestCasePO) {
            return IconConstants.EH_IMAGE;
        }
        if (element instanceof IExecTestCasePO) {
            return IconConstants.TC_REF_IMAGE;
        }
        if (element instanceof ISpecTestCasePO) {
            return IconConstants.TC_IMAGE;
        }
        if (element instanceof ITestJobPO) {
            return IconConstants.TJ_IMAGE;
        }
        if (element instanceof ICategoryPO || element instanceof IReusedProjectPO) {
            return IconConstants.CATEGORY_IMAGE;
        }
        if (element instanceof IRefTestSuitePO) {
            return IconConstants.TS_REF_IMAGE;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IExecTestCasePO || element instanceof ICapPO) {
            return DISABLED_COLOR;
        }
        if (element instanceof ISpecTestCasePO) {
            return null;
        }
        if (element instanceof IReusedProjectPO || element instanceof INodePO && !NodeBP.isEditable((IPersistentObject)((INodePO)element))) {
            return REUSED_PROJECTS_COLOR;
        }
        return null;
    }

    private static String getText(ICapPO testStep) {
        if (Plugin.getDefault().getPreferenceStore().getBoolean("SHOWCAPINFO_PREF_KEY")) {
            StringBuilder nameBuilder = new StringBuilder(testStep.getName());
            nameBuilder.append(OPEN_BRACKED);
            Map map = StringHelper.getInstance().getMap();
            IComponentNameMapper compMapper = Plugin.getActiveCompMapper();
            nameBuilder.append(Messages.CapGUIType).append((String)map.get(testStep.getComponentType())).append(SEPARATOR).append(Messages.CapGUIName);
            String componentName = testStep.getComponentName();
            componentName = compMapper != null ? compMapper.getCompNameCache().getName(componentName) : ComponentNamesBP.getInstance().getName(componentName);
            if (componentName != null) {
                nameBuilder.append(componentName);
            }
            nameBuilder.append(SEPARATOR).append(Messages.CapGUIAction).append((String)map.get(testStep.getActionName())).append(CLOSE_BRACKED);
            return nameBuilder.toString();
        }
        return testStep.getName();
    }

    private static String getText(IExecTestCasePO testCaseRef) {
        StringBuilder nameBuilder = new StringBuilder();
        if (!StringUtils.isBlank((String)testCaseRef.getRealName())) {
            nameBuilder.append(testCaseRef.getRealName());
            if (Plugin.getDefault().getPreferenceStore().getBoolean("SHOWORIGINALNAME_PREF_KEY")) {
                ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
                String testCaseName = testCase != null ? testCase.getName() : "";
                nameBuilder.append(" ").append("(").append(testCaseName).append(")");
            }
        } else {
            ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
            String testCaseName = testCase != null ? testCase.getName() : "";
            nameBuilder.append("<").append(testCaseName).append(">");
        }
        nameBuilder.append(GeneralLabelProvider.getParameterString((IParamNodePO)testCaseRef));
        return nameBuilder.toString();
    }

    private static String getText(ISpecTestCasePO testCase) {
        return String.valueOf(testCase.getName()) + GeneralLabelProvider.getParameterString((IParamNodePO)testCase);
    }

    private static String getParameterString(IParamNodePO paramNode) {
        StringBuilder nameBuilder = new StringBuilder();
        Iterator iter = paramNode.getParameterList().iterator();
        boolean parameterExist = false;
        if (iter.hasNext()) {
            parameterExist = true;
            nameBuilder.append(OPEN_BRACKED);
        }
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                IParamDescriptionPO descr = (IParamDescriptionPO)iter.next();
                nameBuilder.append(descr.getName());
                if (!iter.hasNext()) continue;
                nameBuilder.append(SEPARATOR);
            }
        }
        if (parameterExist) {
            nameBuilder.append(CLOSE_BRACKED);
        }
        return nameBuilder.toString();
    }
}

