/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.labelprovider;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.rcp.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;

public class TestSuiteBrowserLabelProvider
extends GeneralLabelProvider {
    public String getToolTipText(Object element) {
        if (element instanceof INodePO) {
            return this.createToolTipText((INodePO)element);
        }
        return super.getToolTipText(element);
    }

    public static boolean isNodeActive(INodePO node) {
        if (node == null || !node.isActive()) {
            return false;
        }
        INodePO parentNode = node.getParentNode();
        while (parentNode != null) {
            if (node != null && !node.isActive()) {
                return false;
            }
            parentNode = parentNode.getParentNode();
        }
        return true;
    }

    private String createToolTipText(INodePO node) {
        StringBuilder toolTip = new StringBuilder();
        WorkingLanguageBP workLangBP = WorkingLanguageBP.getInstance();
        Locale locale = workLangBP.getWorkingLanguage();
        ITestSuitePO testSuite = UINodeBP.getOwningTestSuite(node);
        if (node != null && TestSuiteBrowserLabelProvider.isNodeActive(node)) {
            if (testSuite != null) {
                IAUTMainPO aut = testSuite.getAut();
                if (node instanceof ITestSuitePO) {
                    if (testSuite.getAut() != null && !workLangBP.isTestSuiteLanguage(locale, testSuite)) {
                        toolTip.append("- ").append(Messages.TestDataDecoratorUnsupportedAUTLanguage);
                    } else {
                        this.checkNode(testSuite, aut, locale, toolTip);
                    }
                } else if (node instanceof IExecTestCasePO) {
                    this.checkNode((IExecTestCasePO)node, aut, locale, toolTip);
                } else if (node instanceof ICapPO) {
                    ICapPO cap = (ICapPO)node;
                    INodePO grandParent = node.getParentNode().getParentNode();
                    boolean overWrittenName = false;
                    if (grandParent instanceof IExecTestCasePO) {
                        IExecTestCasePO execTC = (IExecTestCasePO)grandParent;
                        for (ICompNamesPairPO pair : execTC.getCompNamesPairs()) {
                            if (!pair.getFirstName().equals(cap.getComponentName()) || pair.getSecondName() == null || pair.getSecondName().equals(cap.getComponentName())) continue;
                            overWrittenName = true;
                            break;
                        }
                    }
                    this.checkNode(aut, locale, cap, toolTip, overWrittenName);
                }
            }
            if (node instanceof ITestJobPO) {
                if (!TestSuiteBrowserLabelProvider.isTestJobGuiValid((ITestJobPO)node)) {
                    this.addMessage(toolTip, Messages.TestDataDecoratorTestJobIncompl);
                }
            } else if (node instanceof ICategoryPO) {
                IProblem worstProblem = ProblemFactory.getWorstProblem((Set)node.getProblems());
                if (worstProblem != null) {
                    this.addMessage(toolTip, worstProblem.getTooltipMessage());
                }
            } else if (node instanceof IRefTestSuitePO && !TestSuiteBrowserLabelProvider.isRefTestSuiteGuiValid((IRefTestSuitePO)node)) {
                this.addMessage(toolTip, Messages.TestDataDecoratorRefTsIncompl);
            }
            if (toolTip.length() == 0) {
                return super.getToolTipText(node);
            }
        }
        return toolTip.length() > 0 ? toolTip.toString() : null;
    }

    private StringBuilder checkNode(ITestSuitePO testSuite, IAUTMainPO aut, Locale locale, StringBuilder toolTip) {
        if (aut == null) {
            this.addMessage(toolTip, Messages.TestDataDecoratorTestSuiteWithoutAUT);
        }
        for (IProblem problem : testSuite.getProblems()) {
            this.addMessage(toolTip, problem.getTooltipMessage());
        }
        return toolTip;
    }

    private void addWhitespace(StringBuilder toolTip) {
        if (toolTip.length() > 0) {
            toolTip.append("\n");
        }
    }

    private StringBuilder checkNode(IExecTestCasePO execTC, IAUTMainPO aut, Locale locale, StringBuilder toolTip) {
        if (execTC == null) {
            return toolTip;
        }
        if (!execTC.getCompleteSpecTcFlag()) {
            this.addMessage(toolTip, Messages.TestDataDecoratorSpecTcMissing);
        } else {
            IExecTestCasePO realParamNode = execTC;
            if (execTC.getHasReferencedTD()) {
                realParamNode = execTC.getSpecTestCase();
            }
            if (aut != null && !execTC.getSumOMFlag(aut)) {
                this.addMessage(toolTip, Messages.TestDataDecoratorOMChildrenIncompl);
            }
            if (execTC.getDataFile() == null || execTC.getDataFile().length() == 0) {
                boolean isAlreadySet = false;
                if (!realParamNode.getCompleteTdFlag(locale)) {
                    this.addMessage(toolTip, Messages.TestDataDecoratorTdInTestCaseIncompl);
                    isAlreadySet = true;
                }
                if (!isAlreadySet && !execTC.getCompleteTdFlag(locale)) {
                    this.addMessage(toolTip, Messages.TestDataDecoratorTdInTestCaseIncompl);
                }
            }
            if (!execTC.getSumTdFlag(locale) && execTC.getCompleteTdFlag(locale)) {
                this.addMessage(toolTip, Messages.TestDataDecoratorTDChildrenIncompl);
            } else if (!execTC.getSumTdFlag(locale) && !execTC.getCompleteTdFlag(locale)) {
                Iterator it = execTC.getNodeListIterator();
                boolean tmpFlag = true;
                while (it.hasNext() && tmpFlag) {
                    INodePO child = (INodePO)it.next();
                    if (child instanceof IExecTestCasePO) {
                        tmpFlag = tmpFlag && child.getSumTdFlag(locale);
                        continue;
                    }
                    boolean bl = tmpFlag = tmpFlag && ((IParamNodePO)child).getCompleteTdFlag(locale);
                }
                if (!tmpFlag) {
                    this.addMessage(toolTip, Messages.TestDataDecoratorTDChildrenIncompl);
                }
            }
            boolean atLeastOneEvData = false;
            if (!execTC.getSumSpecTcFlag()) {
                this.addMessage(toolTip, Messages.TestDataDecoratorSpecTcChildrenMissing);
            }
            for (Object obj : execTC.getSpecTestCase().getAllEventEventExecTC()) {
                IEventExecTestCasePO ev = (IEventExecTestCasePO)obj;
                if (ev.getSumTdFlag(locale) || atLeastOneEvData) continue;
                this.addMessage(toolTip, Messages.TestDataDecoratorTDEvIncompl);
                atLeastOneEvData = true;
            }
        }
        this.addExternalTooltips(toolTip, (INodePO)execTC);
        return toolTip;
    }

    private void addExternalTooltips(StringBuilder toolTip, INodePO node) {
        for (IProblem problem : node.getProblems()) {
            if (problem.getProblemType() != ProblemType.EXTERNAL) continue;
            this.addMessage(toolTip, problem.getTooltipMessage());
        }
    }

    private void addMessage(StringBuilder toolTip, String message) {
        this.addWhitespace(toolTip);
        toolTip.append("- ").append(message);
    }

    private StringBuilder checkNode(IAUTMainPO aut, Locale locale, ICapPO cap, StringBuilder toolTip, boolean overWrittenName) {
        if (!overWrittenName && !cap.getCompleteOMFlag(aut)) {
            this.addMessage(toolTip, Messages.TestDataDecoratorOMInStepIncompl);
        }
        if (!cap.getCompleteTdFlag(locale)) {
            this.addMessage(toolTip, Messages.TestDataDecoratorTDInStepIncompl);
        }
        this.addExternalTooltips(toolTip, (INodePO)cap);
        return toolTip;
    }

    public static boolean isTestJobGuiValid(ITestJobPO tj) {
        List refTsList = tj.getUnmodifiableNodeList();
        for (INodePO node : refTsList) {
            IRefTestSuitePO refTs = (IRefTestSuitePO)node;
            if (!TestExecution.isAutNameSet((String)refTs.getTestSuiteAutID())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRefTestSuiteGuiValid(IRefTestSuitePO refTs) {
        return !TestExecution.isAutNameSet((String)refTs.getTestSuiteAutID());
    }
}

