/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewerIterator {
    private List<Object> m_elements = new ArrayList<Object>(25);
    private Iterator<Object> m_iter;
    private TreeViewer m_viewer;

    public TreeViewerIterator(TreeViewer viewer) {
        this(viewer, null, true);
    }

    public TreeViewerIterator(TreeViewer viewer, Object startNode, boolean iterateForward) {
        Object[] elements;
        this.m_viewer = viewer;
        Object[] objectArray = elements = ((ITreeContentProvider)this.m_viewer.getContentProvider()).getElements(viewer.getInput());
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.setElements(element);
            ++n2;
        }
        if (startNode != null && this.m_elements.contains(startNode)) {
            Collections.rotate(this.m_elements, this.m_elements.size() - this.m_elements.indexOf(startNode));
            this.m_elements.remove(0);
        }
        if (!iterateForward) {
            Collections.reverse(this.m_elements);
        }
        this.m_iter = this.m_elements.iterator();
    }

    public Object next() {
        return this.m_iter.next();
    }

    public boolean hasNext() {
        return this.m_iter.hasNext();
    }

    private void setElements(Object root) {
        if (root == null) {
            return;
        }
        Object[] children = ((ITreeContentProvider)this.m_viewer.getContentProvider()).getChildren(root);
        ViewerFilter[] viewerFilterArray = this.m_viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter vf = viewerFilterArray[n2];
            children = vf.filter((Viewer)this.m_viewer, root, children);
            ++n2;
        }
        ViewerSorter sorter = this.m_viewer.getSorter();
        if (sorter != null) {
            sorter.sort((Viewer)this.m_viewer, children);
        }
        Object[] objectArray = children;
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            Object node = objectArray[n];
            if (node != null) {
                this.m_elements.add(node);
            }
            this.setElements(node);
            ++n;
        }
    }

    public List<Object> getElements() {
        return this.m_elements;
    }
}

