/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views.imageview;

import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.views.JBPropertiesView;
import org.eclipse.jubula.client.ui.rcp.views.imageview.ImageProvider;
import org.eclipse.jubula.client.ui.rcp.views.imageview.ImageViewer;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class ImageView
extends ViewPart
implements IJBPart,
ISelectionProvider {
    private ImageViewer m_viewer;
    private ImageProvider m_provider;
    private Image m_image;
    private ISelection m_currSelection = null;
    private ISelectionListener m_selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ImageView.this.handleSelection(selection);
        }
    };

    private void handleSelection(ISelection selection) {
        IStructuredSelection ss;
        ImageProvider provider = null;
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() > 0) {
            Object object = ss.getFirstElement();
            if (this.m_currSelection != null && ObjectUtils.equals((Object)object, (Object)((IStructuredSelection)this.m_currSelection).getFirstElement())) {
                return;
            }
            this.m_currSelection = ss;
            if (object instanceof IAdaptable) {
                provider = (ImageProvider)((IAdaptable)object).getAdapter(ImageProvider.class);
            }
            if (provider == null) {
                provider = (ImageProvider)Platform.getAdapterManager().getAdapter(object, ImageProvider.class);
            }
        }
        if (provider == null) {
            this.clear();
        } else {
            this.handleSelection(provider);
        }
    }

    private void clear() {
        this.disposeImage();
        this.m_viewer.redraw();
    }

    private void handleSelection(final ImageProvider provider) {
        final String jobName = Messages.UIJobLoadingImage;
        Job job = new Job(jobName){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                ImageView.this.setImageProvider(provider);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        JobUtils.executeJob((Job)job, null);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.m_viewer = new ImageViewer(parent, 0);
        this.getSelectionService().addSelectionListener(this.m_selectionListener);
        this.handleSelection(this.getSelectionService().getSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    protected void setImageProvider(ImageProvider provider) {
        final Image image = provider.getImage((Device)this.m_viewer.getDisplay());
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (image != null) {
                    ImageView.this.m_viewer.setImage(image);
                } else {
                    ImageView.this.clear();
                }
            }
        });
        this.m_provider = provider;
        this.m_image = image;
    }

    public void dispose() {
        super.dispose();
        this.getSelectionService().removeSelectionListener(this.m_selectionListener);
        this.disposeImage();
    }

    private void disposeImage() {
        if (this.m_provider == null) {
            return;
        }
        if (this.m_image == null) {
            return;
        }
        this.m_provider.disposeImage(this.m_image);
        this.m_provider = null;
        this.m_image = null;
    }

    public void setFocus() {
        this.m_viewer.setFocus();
    }

    private ISelectionService getSelectionService() {
        return this.getSite().getWorkbenchWindow().getSelectionService();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            return new JBPropertiesView(true, null);
        }
        return super.getAdapter(adapter);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return this.m_currSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }
}

