/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers.open;

import javax.persistence.EntityManager;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.ui.editors.TestResultEditorInput;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTestResultViewerHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTestResultViewerHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSel = (IStructuredSelection)selection;
            for (Object firstElement : structuredSel) {
                TestResultEditorInput editorInput = null;
                if (firstElement instanceof ITestResultSummaryPO) {
                    ITestResultSummaryPO result = (ITestResultSummaryPO)firstElement;
                    if (TestResultPM.hasTestResultDetails((EntityManager)GeneralStorage.getInstance().getMasterSession(), (Long)result.getId())) {
                        editorInput = new TestResultEditorInput(result);
                    }
                } else {
                    LOG.info(String.valueOf(Messages.SelectedElementIsNotTestResultSummary) + ".");
                }
                if (editorInput != null) {
                    IWorkbenchPage currentPage = HandlerUtil.getActiveSiteChecked((ExecutionEvent)event).getPage();
                    if (currentPage == null) continue;
                    try {
                        currentPage.openEditor((IEditorInput)editorInput, "org.eclipse.jubula.client.ui.editors.TestResultViewer");
                    }
                    catch (PartInitException partInitException) {
                        ErrorHandlingUtil.createMessageDialog(MessageIDs.E_CANNOT_OPEN_EDITOR);
                    }
                    continue;
                }
                LOG.info(String.valueOf(Messages.NoEditorInputCouldBeCreated) + ".");
            }
        }
        return null;
    }
}

