/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.connection;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.eclipse.jubula.communication.connection.BroadcastException;
import org.eclipse.jubula.communication.connection.BroadcastInitException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

public class BroadcastSender {
    private int m_port;
    private DatagramSocket m_socket;
    private InetAddress m_network;

    public BroadcastSender(String network, int port) throws BroadcastInitException {
        try {
            this.m_port = port;
            this.m_socket = new DatagramSocket();
            this.m_network = InetAddress.getByName(network);
        }
        catch (SocketException e) {
            throw new BroadcastInitException("Can't open socket", e, MessageIDs.E_AUT_CONNECTION_INIT);
        }
        catch (UnknownHostException e) {
            throw new BroadcastInitException("Host network " + network + " unknown", e, MessageIDs.E_AUT_CONNECTION_INIT);
        }
    }

    public void send(byte[] data, int length) throws BroadcastException {
        try {
            DatagramPacket packet = new DatagramPacket(data, length, this.m_network, this.m_port);
            this.m_socket.send(packet);
        }
        catch (IOException e) {
            throw new BroadcastException("send failed", e, MessageIDs.E_GENERAL_CONNECTION);
        }
    }

    public void dispose() {
        if (this.m_socket != null) {
            this.m_socket.close();
            this.m_socket = null;
            this.m_network = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

