/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.StringParsing;

public class ListSelectionVerifier {
    private List m_itemList = new ArrayList();

    public void addItem(int index, String value, boolean isSelected) {
        this.m_itemList.add(index, new SelectionItem(value, isSelected));
    }

    public void verifySelection(String patternString, String op, boolean allowAdditionalSelections, boolean isSelected) {
        String[] pattern = StringParsing.splitToArray((String)patternString, (char)',', (char)'\\');
        int i = 0;
        while (i < pattern.length) {
            boolean hit = false;
            Iterator iter = this.m_itemList.iterator();
            while (iter.hasNext()) {
                SelectionItem item = (SelectionItem)iter.next();
                if (!MatchUtil.getInstance().match(item.getValue(), pattern[i], op)) continue;
                if (item.isSelected() != isSelected) {
                    throw new StepExecutionException("Unselected element matches " + patternString, EventFactory.createVerifyFailed((String)item.getValue(), (String)pattern[i], (String)op));
                }
                item.setVisited(true);
                hit = true;
            }
            if (!hit && isSelected) {
                throw new StepExecutionException("No list element matches " + patternString, EventFactory.createVerifyFailed((String)this.toString(), (String)pattern[i], (String)op));
            }
            ++i;
        }
        if (!allowAdditionalSelections) {
            Iterator iter = this.m_itemList.iterator();
            while (iter.hasNext()) {
                SelectionItem item = (SelectionItem)iter.next();
                if (!item.isSelected() || item.isVisited()) continue;
                throw new StepExecutionException("More list element match", EventFactory.createVerifyFailed((String)this.toString(), (String)patternString, (String)op));
            }
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        Iterator iter = this.m_itemList.iterator();
        while (iter.hasNext()) {
            SelectionItem element = (SelectionItem)iter.next();
            if (!element.isSelected()) continue;
            res.append(element.getValue());
            res.append(',');
        }
        if (res.length() > 0) {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString();
    }

    private class SelectionItem {
        private String m_value;
        private boolean m_selected;
        private boolean m_visited = false;

        public SelectionItem(String value, boolean selected) {
            this.m_value = value;
            this.m_selected = selected;
        }

        public boolean isVisited() {
            return this.m_visited;
        }

        public void setVisited(boolean visited) {
            this.m_visited = visited;
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

