/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.IRobotEventInterceptor;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.MenuUtilBase;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.driver.RobotFactorySwtImpl;
import org.eclipse.jubula.rc.swt.driver.SelectionSwtEventMatcher;
import org.eclipse.jubula.rc.swt.driver.ShowSwtEventMatcher;
import org.eclipse.jubula.rc.swt.implclasses.EventListener;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class MenuUtil
extends MenuUtilBase {
    private static AutServerLogger log;
    private static final String CLASSNAME;
    private static final IEventThreadQueuer EVENT_THREAD_QUEUER;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.driver.RobotSwtImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.MenuUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASSNAME = clazz2.getName();
        EVENT_THREAD_QUEUER = new EventThreadQueuerSwtImpl();
    }

    private MenuUtil() {
    }

    public static MenuItem navigateToMenuItem(IRobot robot, Menu menuBar, String[] path, String operator) {
        MenuItem menuItem = null;
        Menu currentMenu = menuBar;
        int pathLength = path.length;
        int beforeLast = pathLength - 1;
        int i = 0;
        while (i < pathLength) {
            menuItem = MenuUtil.findMenuItem(currentMenu, path[i], operator);
            if (menuItem == null) {
                return null;
            }
            if (i < beforeLast) {
                if (!MenuUtil.hasSubMenu(menuItem)) {
                    return null;
                }
                currentMenu = MenuUtil.openSubMenu(menuItem, robot);
            }
            ++i;
        }
        return menuItem;
    }

    public static MenuItem navigateToMenuItem(IRobot robot, Menu menuBar, int[] path) {
        MenuItem menuItem = null;
        Menu currentMenu = menuBar;
        int pathLength = path.length;
        int beforeLast = pathLength - 1;
        int i = 0;
        while (i < pathLength) {
            int pathIndex = path[i];
            if (pathIndex < 0) {
                MenuUtil.throwInvalidPathException();
            }
            if ((menuItem = MenuUtil.findMenuItem(currentMenu, pathIndex)) == null && i < beforeLast) {
                return null;
            }
            if (i < beforeLast) {
                if (!MenuUtil.hasSubMenu(menuItem)) {
                    return null;
                }
                currentMenu = MenuUtil.openSubMenu(menuItem, robot);
            }
            ++i;
        }
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Menu openSubMenu(final MenuItem menuItem, IRobot robot) throws StepExecutionException {
        MenuShownCondition cond = new MenuShownCondition(menuItem);
        EventLock lock = new EventLock();
        final EventListener listener = new EventListener(lock, cond);
        final Display d = menuItem.getDisplay();
        EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
        queuer.invokeAndWait("addMenuShownListeners", new IRunnable(){

            public Object run() {
                d.addFilter(22, (Listener)listener);
                return null;
            }
        });
        try {
            try {
                int clickCount = MenuUtil.isMenuBarItem(menuItem) ? 1 : 0;
                Menu menu = (Menu)EVENT_THREAD_QUEUER.invokeAndWait("openSubMenu", new IRunnable(){

                    public Object run() {
                        return menuItem.getMenu();
                    }
                });
                Rectangle bounds = MenuUtil.getMenuItemBounds(menuItem);
                Rectangle nullBounds = new Rectangle(0, 0, 0, 0);
                if (bounds.equals((Object)nullBounds)) {
                    MenuUtil.openSubMenuProgramatically(menu);
                } else {
                    MenuUtil.clickMenuItem(robot, menuItem, clickCount);
                }
                EventLock eventLock = lock;
                synchronized (eventLock) {
                    long timeout = 10000L;
                    long done = System.currentTimeMillis() + timeout;
                    while (true) {
                        block12: {
                            if (!lock.isReleased() && timeout > 0L) break block12;
                            break;
                        }
                        lock.wait(timeout);
                        long now = System.currentTimeMillis();
                        timeout = done - now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            queuer.invokeAndWait("removeMenuShownListeners", new IRunnable(d, listener){
                private final /* synthetic */ Display val$d;
                private final /* synthetic */ EventListener val$listener;
                {
                    this.val$d = display;
                    this.val$listener = eventListener;
                }

                public Object run() {
                    this.val$d.removeFilter(22, (Listener)this.val$listener);
                    return null;
                }
            });
            throw throwable;
        }
        {
            Object var18_18 = null;
        }
        queuer.invokeAndWait("removeMenuShownListeners", new /* invalid duplicate definition of identical inner class */);
        if (!lock.isReleased()) {
            String itemText = (String)EVENT_THREAD_QUEUER.invokeAndWait("getItemText", new IRunnable(){

                public Object run() throws StepExecutionException {
                    if (menuItem != null && !menuItem.isDisposed()) {
                        return menuItem.getText();
                    }
                    return "unknown menu item";
                }
            });
            itemText = SwtUtils.removeMnemonics(itemText);
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.MenuDidNotAppear", (Object[])new String[]{itemText}), EventFactory.createActionError((String)"TestErrorEvent.MenuDidNotAppear", (Object[])new String[]{itemText}));
        }
        return cond.getMenu();
    }

    private static boolean isMenuBarItem(final MenuItem menuItem) {
        return (Boolean)EVENT_THREAD_QUEUER.invokeAndWait("isMenuBarItem", new IRunnable(){

            public Object run() throws StepExecutionException {
                Menu parent;
                if (menuItem != null && !menuItem.isDisposed() && (parent = menuItem.getParent()) != null && !parent.isDisposed()) {
                    return (parent.getStyle() & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private static boolean hasSubMenu(MenuItem menuItem) {
        return MenuUtil.getMenu(menuItem) != null;
    }

    public static MenuItem findMenuItem(final Menu menu, final int index) {
        return (MenuItem)EVENT_THREAD_QUEUER.invokeAndWait(String.valueOf(CLASSNAME) + ".findMenuItem", new IRunnable(){

            public Object run() throws StepExecutionException {
                if (index < 0 || index >= menu.getItemCount()) {
                    return null;
                }
                int newIndex = index;
                int i = 0;
                while (i <= newIndex) {
                    if (MenuUtil.isSeparator(menu.getItem(i)) && ++newIndex >= menu.getItemCount()) {
                        return null;
                    }
                    ++i;
                }
                return menu.getItem(newIndex);
            }
        });
    }

    public static Menu getMenu(final MenuItem menuItem) {
        return (Menu)EVENT_THREAD_QUEUER.invokeAndWait(String.valueOf(CLASSNAME) + ".getMenu", new IRunnable(){

            public Object run() throws StepExecutionException {
                return menuItem.getMenu();
            }
        });
    }

    private static void throwInvalidPathException() {
        throw new StepExecutionException("invalid path", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
    }

    public static MenuItem findMenuItem(final Menu menu, final String name, final String operator) {
        return (MenuItem)EVENT_THREAD_QUEUER.invokeAndWait(String.valueOf(CLASSNAME) + ".findMenuItem", new IRunnable(){

            public Object run() throws StepExecutionException {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    MenuItem item = items[i];
                    String itemText = SwtUtils.removeMnemonics(item.getText());
                    if (MatchUtil.getInstance().match(itemText, name, operator) && !MenuUtil.isSeparator(item)) {
                        return item;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    private static boolean isSeparator(final MenuItem menuItem) {
        Boolean isSeparator = (Boolean)EVENT_THREAD_QUEUER.invokeAndWait(String.valueOf(CLASSNAME) + ".isSeparator", new IRunnable(){

            public Object run() throws StepExecutionException {
                return (menuItem.getStyle() & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isSeparator;
    }

    public static void clickMenuItem(IRobot robot, MenuItem item, int clickCount) {
        if (!MenuUtil.isMenuItemEnabled(item)) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        robot.click((Object)item, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED).setStepMovement(false).setClickCount(clickCount));
    }

    public static void selectProgramatically(final MenuItem menuItem) {
        if (!MenuUtil.isMenuItemEnabled(menuItem)) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        InterceptorOptions options = new InterceptorOptions(new long[]{13L});
        final SelectionSwtEventMatcher matcher = new SelectionSwtEventMatcher();
        RobotFactorySwtImpl robotSwt = new RobotFactorySwtImpl();
        IRobotEventInterceptor interceptor = robotSwt.getRobotEventInterceptor();
        final IRobotEventConfirmer confirmer = interceptor.intercept(options);
        final Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = menuItem;
        event.display = menuItem.getDisplay();
        event.type = 13;
        EVENT_THREAD_QUEUER.invokeLater("selectProgramatically", new IRunnable(){

            public Object run() {
                if ((menuItem.getStyle() & 0x20) == 0 || (menuItem.getStyle() & 0x10) == 0) {
                    if (menuItem.getSelection()) {
                        menuItem.setSelection(false);
                    } else {
                        menuItem.setSelection(true);
                    }
                }
                menuItem.notifyListeners(13, event);
                try {
                    confirmer.waitToConfirm((Object)menuItem, matcher);
                }
                catch (RobotException re) {
                    StringBuffer sb = new StringBuffer("Robot exception occurred while clicking...\n");
                    sb.append("Component: ");
                    EVENT_THREAD_QUEUER.invokeAndWait("getBounds", new IRunnable(this, sb, menuItem){
                        final /* synthetic */ 10 this$1;
                        private final /* synthetic */ StringBuffer val$sb;
                        private final /* synthetic */ MenuItem val$menuItem;
                        {
                            this.this$1 = var1_1;
                            this.val$sb = stringBuffer;
                            this.val$menuItem = menuItem;
                        }

                        public Object run() throws StepExecutionException {
                            this.val$sb.append(this.val$menuItem);
                            return null;
                        }
                    });
                    log.error((Object)sb.toString(), (Throwable)re);
                    throw re;
                }
                return null;
            }
        });
    }

    public static void openSubMenuProgramatically(final Menu menu) {
        if (!MenuUtil.isMenuEnabled(menu)) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        InterceptorOptions options = new InterceptorOptions(new long[]{22L});
        final ShowSwtEventMatcher matcher = new ShowSwtEventMatcher();
        RobotFactorySwtImpl robotSwt = new RobotFactorySwtImpl();
        IRobotEventInterceptor interceptor = robotSwt.getRobotEventInterceptor();
        final IRobotEventConfirmer confirmer = interceptor.intercept(options);
        final Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = menu;
        event.display = menu.getDisplay();
        event.type = 22;
        EVENT_THREAD_QUEUER.invokeAndWait("openSubMenuProgramatically", new IRunnable(){

            public Object run() {
                menu.notifyListeners(22, event);
                try {
                    confirmer.waitToConfirm((Object)menu, matcher);
                }
                catch (RobotException re) {
                    StringBuffer sb = new StringBuffer("Robot exception occurred while clicking...\n");
                    sb.append("Component: ");
                    EVENT_THREAD_QUEUER.invokeAndWait("getBounds", new IRunnable(this, sb, menu){
                        final /* synthetic */ 12 this$1;
                        private final /* synthetic */ StringBuffer val$sb;
                        private final /* synthetic */ Menu val$menu;
                        {
                            this.this$1 = var1_1;
                            this.val$sb = stringBuffer;
                            this.val$menu = menu;
                        }

                        public Object run() throws StepExecutionException {
                            this.val$sb.append(this.val$menu);
                            return null;
                        }
                    });
                    log.error((Object)sb.toString(), (Throwable)re);
                    throw re;
                }
                return null;
            }
        });
    }

    public static boolean isMenuItemEnabled(final MenuItem menuItem) {
        Boolean isEnabled = (Boolean)EVENT_THREAD_QUEUER.invokeAndWait(String.valueOf(CLASSNAME) + ".isMenuItemEnabled", new IRunnable(){

            public Object run() throws StepExecutionException {
                return menuItem.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEnabled;
    }

    public static boolean isMenuEnabled(final Menu menu) {
        Boolean isEnabled = (Boolean)EVENT_THREAD_QUEUER.invokeAndWait(String.valueOf(CLASSNAME) + ".isMenuEnabled", new IRunnable(){

            public Object run() throws StepExecutionException {
                return menu.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEnabled;
    }

    public static boolean isMenuItemSelected(final MenuItem menuItem) {
        Boolean isSelected = (Boolean)EVENT_THREAD_QUEUER.invokeAndWait(String.valueOf(CLASSNAME) + ".isMenuItemSelected", new IRunnable(){

            public Object run() throws StepExecutionException {
                return menuItem.getSelection() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isSelected;
    }

    public static boolean isMenuVisible(final Menu menu) {
        Boolean isVisible = (Boolean)EVENT_THREAD_QUEUER.invokeAndWait(String.valueOf(CLASSNAME) + ".isMenuVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                return menu.isVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isVisible;
    }

    public static Rectangle getMenuItemBounds(final MenuItem item) {
        Rectangle bounds = (Rectangle)EVENT_THREAD_QUEUER.invokeAndWait("getMenuItemBounds", new IRunnable(){

            public Object run() {
                return SwtUtils.getBounds(item);
            }
        });
        return bounds;
    }

    public static void closeMenu(IRobot robot, Menu menu, String name, String operator, int maxCascadeLength) {
        MenuItem item = MenuUtil.findMenuItem(menu, name, operator);
        MenuUtil.closeMenu(robot, item, maxCascadeLength);
    }

    public static void closeMenu(IRobot robot, Menu menu, int index, int maxCascadeLength) {
        MenuItem item = MenuUtil.findMenuItem(menu, index);
        MenuUtil.closeMenu(robot, item, maxCascadeLength);
    }

    private static void closeMenu(IRobot robot, MenuItem item, int maxCascadeLength) {
        Menu menuOfItem;
        if (item != null && (menuOfItem = MenuUtil.getMenu(item)) != null) {
            final MenuHiddenListener menuListener = new MenuHiddenListener();
            menuOfItem.getDisplay().syncExec(new Runnable(){

                public void run() {
                    menuOfItem.addMenuListener((MenuListener)menuListener);
                }
            });
            int i = 0;
            while (i < maxCascadeLength && !menuListener.isMenuHidden()) {
                robot.keyType((Object)menuOfItem, 27);
                ++i;
            }
        }
    }

    public static String[] splitPath(String path) {
        return MenuUtilBase.splitPath((String)path);
    }

    public static int[] splitIndexPath(String path) {
        return MenuUtilBase.splitIndexPath((String)path);
    }

    private static final class MenuHiddenListener
    implements MenuListener {
        private boolean m_eventOccurred = false;

        private MenuHiddenListener() {
        }

        public void menuHidden(MenuEvent e) {
            this.m_eventOccurred = true;
            ((Menu)e.widget).removeMenuListener((MenuListener)this);
        }

        public void menuShown(MenuEvent e) {
        }

        public boolean isMenuHidden() {
            return this.m_eventOccurred;
        }
    }

    public static class MenuShownCondition
    implements EventListener.Condition {
        private Menu m_shownMenu = null;
        private MenuItem m_parentItem;

        MenuShownCondition(MenuItem parentItem) {
            this.m_parentItem = parentItem;
        }

        public Menu getMenu() {
            return this.m_shownMenu;
        }

        public boolean isTrue(Event event) {
            if (event.type == 22 && event.widget instanceof Menu && ((Menu)event.widget).getParentItem() == this.m_parentItem) {
                this.m_shownMenu = (Menu)event.widget;
                return true;
            }
            return false;
        }
    }
}

