/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ChildTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.IndexNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.ParentTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.SiblingTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.StandardDepthFirstTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.StringNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.implclasses.AbstractControlImplClass;
import org.eclipse.jubula.rc.swt.implclasses.TreeOperationContext;
import org.eclipse.jubula.rc.swt.implclasses.tree.ToggleCheckboxOperation;
import org.eclipse.jubula.rc.swt.implclasses.tree.VerifyCheckboxOperation;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.utils.StringParsing;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeImplClass
extends AbstractControlImplClass {
    private Tree m_tree;

    public void setComponent(Object graphicsComponent) {
        this.m_tree = (Tree)graphicsComponent;
    }

    public Control getComponent() {
        return this.m_tree;
    }

    public void gdExpand(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.traverseTreeByPath(this.createStringNodePath(this.splitTextTreePath(treePath), operator), pathType, preAscend, (TreeNodeOperation)new ExpandCollapseTreeNodeOperation(false));
    }

    public void gdExpandByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        try {
            this.traverseTreeByPath(this.createIndexNodePath(this.splitIndexTreePath(indexPath)), pathType, preAscend, (TreeNodeOperation)new ExpandCollapseTreeNodeOperation(false));
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void gdCollapse(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.traverseLastElementByPath(this.createStringNodePath(this.splitTextTreePath(treePath), operator), pathType, preAscend, (TreeNodeOperation)new ExpandCollapseTreeNodeOperation(true));
    }

    public void gdCollapseByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        try {
            this.traverseLastElementByPath(this.createIndexNodePath(this.splitIndexTreePath(indexPath)), pathType, preAscend, (TreeNodeOperation)new ExpandCollapseTreeNodeOperation(true));
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void gdMove(String direction, int distance, int clickCount) throws StepExecutionException {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        TreeItem selectedNode = this.getSelectedNode(context);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(ClickOptions.create().setClickCount(clickCount));
        TreeNodeOperationConstraint constraint = new TreeNodeOperationConstraint();
        if ("up".equalsIgnoreCase(direction)) {
            ParentTraverser traverser = new ParentTraverser((AbstractTreeOperationContext)context, distance, constraint);
            traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
        } else if ("down".equalsIgnoreCase(direction)) {
            ExpandCollapseTreeNodeOperation expandOp = new ExpandCollapseTreeNodeOperation(false);
            ChildTraverser expandTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance - 1);
            expandTraverser.traversePath((TreeNodeOperation)expandOp, (Object)selectedNode);
            ChildTraverser selectTraverser = new ChildTraverser((AbstractTreeOperationContext)context, distance, constraint);
            selectTraverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
        } else if ("next".equalsIgnoreCase(direction)) {
            SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, true, constraint);
            traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
        } else if ("previous".equalsIgnoreCase(direction)) {
            SiblingTraverser traverser = new SiblingTraverser((AbstractTreeOperationContext)context, distance, false, constraint);
            traverser.traversePath((TreeNodeOperation)selectOp, (Object)selectedNode);
        }
    }

    public void gdSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int button, String extendSelection) throws StepExecutionException {
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void gdSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int button, String extendSelection) throws StepExecutionException {
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void gdVerifySelectedValue(String pattern) throws StepExecutionException {
        this.gdVerifySelectedValue(pattern, "equals");
    }

    public void gdVerifySelectedValue(String pattern, String operator) throws StepExecutionException {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        String text = (String)context.getNodeTextList(context.getSelectedNode()).toArray()[0];
        Verifier.match((String)text, (String)pattern, (String)operator);
    }

    public void gdVerifyPath(String pathType, int preAscend, String treePath, String operator, boolean exists) {
        try {
            this.gdExpand(pathType, preAscend, treePath, operator);
        }
        catch (StepExecutionException stepExecutionException) {
            if (exists) {
                throw new StepVerifyFailedException("Verify failed on tree-path: " + treePath, EventFactory.createVerifyFailed((String)treePath, (String)""));
            }
            return;
        }
        if (!exists) {
            throw new StepVerifyFailedException("Verify failed on tree-path: ", EventFactory.createVerifyFailed((String)"", (String)treePath));
        }
    }

    public void gdVerifyPathByIndices(String pathType, int preAscend, String treePath, boolean exists) {
        try {
            this.gdExpandByIndices(pathType, preAscend, treePath);
        }
        catch (StepExecutionException stepExecutionException) {
            if (exists) {
                throw new StepVerifyFailedException("Verify failed on tree-path: " + treePath, EventFactory.createVerifyFailed((String)treePath, (String)""));
            }
            return;
        }
        if (!exists) {
            throw new StepVerifyFailedException("Verify failed on tree-path: ", EventFactory.createVerifyFailed((String)"", (String)treePath));
        }
    }

    public void gdClick(int count, int button) {
        if (this.getRobot().isMouseInComponent((Object)this.m_tree)) {
            this.getRobot().clickAtCurrentPosition((Object)this.m_tree, count, button);
        } else {
            this.getRobot().click((Object)this.m_tree, null, ClickOptions.create().setClickCount(count).setMouseButton(button));
        }
    }

    public void gdClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        int correctedYPos = this.correctYPos(yPos, yUnits);
        super.gdClickDirect(count, button, xPos, xUnits, correctedYPos, yUnits);
    }

    public void gdToggleCheckbox(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.toggleCheckBoxByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator));
    }

    public void gdToggleCheckboxByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        this.toggleCheckBoxByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)));
    }

    public void gdVerifyCheckbox(String pathType, int preAscend, String treePath, String operator, boolean checked) throws StepExecutionException {
        this.verifyCheckBoxByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), checked);
    }

    public void gdVerifyCheckboxByIndices(String pathType, int preAscend, String indexPath, boolean checked) throws StepExecutionException {
        this.verifyCheckBoxByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), checked);
    }

    public void gdVerifySelectedCheckbox(boolean checked) throws StepExecutionException {
        Boolean checkSelected = (Boolean)this.getEventThreadQueuer().invokeAndWait("gdVerifyTreeCheckbox", new IRunnable(){

            public Object run() {
                TreeItem node = TreeImplClass.this.m_tree.getSelection()[0];
                return new Boolean(node.getChecked());
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkSelected);
    }

    private int correctYPos(int pos, String units) {
        int correctedPos = pos;
        int headerHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getHeaderHeight", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(((Tree)TreeImplClass.this.getComponent()).getHeaderHeight());
            }
        });
        if ("Pixel".equalsIgnoreCase(units)) {
            correctedPos += headerHeight;
        } else {
            int totalHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getHeaderHeight", new IRunnable(){

                public Object run() throws StepExecutionException {
                    return new Integer(SwtUtils.getWidgetBounds((Widget)TreeImplClass.this.getComponent()).height);
                }
            });
            long targetHeight = totalHeight - headerHeight;
            long targetPos = Math.round((double)targetHeight * (double)pos / 100.0);
            double heightPercentage = (double)(targetPos += (long)headerHeight) / (double)totalHeight * 100.0;
            correctedPos = (int)Math.round(heightPercentage);
            if (correctedPos > 100) {
                correctedPos = 100;
            }
        }
        return correctedPos;
    }

    private String[] splitTextTreePath(String treePath) {
        return StringParsing.splitToArray((String)treePath, (char)'/', (char)'\\', (boolean)true);
    }

    private Integer[] splitIndexTreePath(String treePath) throws StepExecutionException {
        Integer[] indexPath = null;
        String[] path = this.splitTextTreePath(treePath);
        if (path != null) {
            indexPath = new Integer[path.length];
            int i = 0;
            while (i < path.length) {
                indexPath[i] = new Integer(IndexConverter.intValue((String)path[i]));
                ++i;
            }
        }
        return IndexConverter.toImplementationIndices((Integer[])indexPath);
    }

    private INodePath createStringNodePath(String[] treePath, String operator) {
        return new StringNodePath(treePath, operator);
    }

    private INodePath createIndexNodePath(Integer[] treePath) {
        return new IndexNodePath(treePath);
    }

    private void traverseTreeByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        TreeItem startNode = this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath);
        traverser.traversePath(operation, (Object)startNode);
    }

    private void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        TreeItem startNode = this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser((AbstractTreeOperationContext)context, treePath, new TreeNodeOperationConstraint());
        traverser.traversePath(operation, (Object)startNode);
    }

    private TreeItem getStartNode(String pathType, final int preAscend, final TreeOperationContext context) {
        TreeItem startNode;
        if (pathType.equals("relative")) {
            startNode = (TreeItem)this.getEventThreadQueuer().invokeAndWait("getStartNode", new IRunnable(){

                public Object run() throws StepExecutionException {
                    TreeItem curNode;
                    TreeItem child = curNode = TreeImplClass.this.getSelectedNode(context);
                    int i = 0;
                    while (i < preAscend) {
                        if (curNode == null) {
                            TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.TreeNodeNotFound");
                            throw new StepExecutionException("Tree node not found: Parent of " + child.toString(), event);
                        }
                        child = curNode;
                        curNode = curNode.getParentItem();
                        ++i;
                    }
                    return curNode;
                }
            });
        } else if (pathType.equals("absolute")) {
            startNode = null;
        } else {
            throw new StepExecutionException(String.valueOf(pathType) + " is not a valid Path Type", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        return startNode;
    }

    private TreeItem getSelectedNode(TreeOperationContext context) {
        return (TreeItem)context.getSelectedNode();
    }

    private void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selectOp);
    }

    private void toggleCheckBoxByPath(String pathType, int preAscend, INodePath objectPath) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        ToggleCheckboxOperation selCheckboxOp = new ToggleCheckboxOperation(context);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)selCheckboxOp);
    }

    private void verifyCheckBoxByPath(String pathType, int preAscend, INodePath objectPath, boolean checked) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        VerifyCheckboxOperation checkboxOp = new VerifyCheckboxOperation(checked, context);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, (TreeNodeOperation)expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, (TreeNodeOperation)checkboxOp);
    }

    public void gdDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treePath, String operator) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelect(pathType, preAscend, treePath, operator, 0, 1, "no");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropByTextPath(final String pathType, final int preAscend, final String treePath, final String operator, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        try {
            this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
            this.getEventThreadQueuer().invokeAndWait("gdDropByTextPath", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    TreeImplClass.this.shakeMouse();
                    TreeImplClass.this.gdSelect(pathType, preAscend, treePath, operator, 0, 1, "no");
                    return null;
                }
            });
            TreeImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            robot.mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        robot.mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String indexPath) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectByIndices(pathType, preAscend, indexPath, 0, 1, "no");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropByIndexPath(final String pathType, final int preAscend, final String indexPath, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        try {
            this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
            this.getEventThreadQueuer().invokeAndWait("gdDropByTextPath", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    TreeImplClass.this.shakeMouse();
                    TreeImplClass.this.gdSelectByIndices(pathType, preAscend, indexPath, 0, 1, "no");
                    return null;
                }
            });
            TreeImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            robot.mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        robot.mouseRelease(null, null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    protected TreeItem getItemAtMousePosition() throws StepExecutionException {
        return (TreeItem)this.getEventThreadQueuer().invokeAndWait("getItemAtMousePosition", new IRunnable(){

            public Object run() throws StepExecutionException {
                Point mousePos = SwtUtils.convertToSwtPoint(TreeImplClass.this.getRobot().getCurrentMousePosition());
                ItemAtPointTreeNodeOperation op = new ItemAtPointTreeNodeOperation(mousePos, SwtUtils.getWidgetBounds((Widget)TreeImplClass.this.m_tree));
                TreeItem topItem = TreeImplClass.this.m_tree.getTopItem();
                if (topItem != null) {
                    StandardDepthFirstTraverser traverser = new StandardDepthFirstTraverser((AbstractTreeOperationContext)new TreeOperationContext(TreeImplClass.this.getEventThreadQueuer(), TreeImplClass.this.getRobot(), TreeImplClass.this.m_tree));
                    traverser.traversePath((TreeNodeOperation)op, (Object)topItem);
                    if (op.getItemAtPoint() != null) {
                        return op.getItemAtPoint();
                    }
                }
                throw new StepExecutionException("No tree node found at mouse position.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
    }

    public String gdStoreSelectedNodeValue(String variable) {
        TreeOperationContext context = new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), this.m_tree);
        TreeItem selectedNode = this.getSelectedNode(context);
        if (selectedNode == null) {
            throw new StepExecutionException("No tree item selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        return context.getRenderedText(selectedNode);
    }

    private static final class ItemAtPointTreeNodeOperation
    extends AbstractTreeNodeOperation {
        private TreeItem m_itemAtPoint;
        private Point m_absPoint;
        private Rectangle m_absTreeBounds;

        public ItemAtPointTreeNodeOperation(Point absPoint, Rectangle absTreeBounds) {
            this.m_absPoint = absPoint;
            this.m_absTreeBounds = absTreeBounds;
        }

        public boolean operate(Object node) throws StepExecutionException {
            if (this.getContext().isVisible(node) && node instanceof TreeItem) {
                TreeItem currentItem = (TreeItem)node;
                Rectangle absItemBounds = SwtUtils.getBounds(currentItem);
                absItemBounds.x = this.m_absTreeBounds.x;
                absItemBounds.width = this.m_absTreeBounds.width;
                if (SwtUtils.containsInclusive(absItemBounds, this.m_absPoint)) {
                    this.m_itemAtPoint = currentItem;
                    return false;
                }
            }
            return true;
        }

        public TreeItem getItemAtPoint() {
            return this.m_itemAtPoint;
        }
    }
}

