/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class FontRecord
extends Record {
    public static final short sid = 49;
    public static final short SS_NONE = 0;
    public static final short SS_SUPER = 1;
    public static final short SS_SUB = 2;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    private short field_1_font_height;
    private short field_2_attributes;
    private static final BitField italic = BitFieldFactory.getInstance(2);
    private static final BitField strikeout = BitFieldFactory.getInstance(8);
    private static final BitField macoutline = BitFieldFactory.getInstance(16);
    private static final BitField macshadow = BitFieldFactory.getInstance(32);
    private short field_3_color_palette_index;
    private short field_4_bold_weight;
    private short field_5_super_sub_script;
    private byte field_6_underline;
    private byte field_7_family;
    private byte field_8_charset;
    private byte field_9_zero = 0;
    private byte field_10_font_name_len;
    private String field_11_font_name;

    public FontRecord() {
    }

    public FontRecord(RecordInputStream in) {
        this.field_1_font_height = in.readShort();
        this.field_2_attributes = in.readShort();
        this.field_3_color_palette_index = in.readShort();
        this.field_4_bold_weight = in.readShort();
        this.field_5_super_sub_script = in.readShort();
        this.field_6_underline = in.readByte();
        this.field_7_family = in.readByte();
        this.field_8_charset = in.readByte();
        this.field_9_zero = in.readByte();
        this.field_10_font_name_len = in.readByte();
        if (this.field_10_font_name_len > 0) {
            this.field_11_font_name = in.readByte() == 0 ? in.readCompressedUnicode(LittleEndian.ubyteToInt(this.field_10_font_name_len)) : in.readUnicodeLEString(this.field_10_font_name_len);
        }
    }

    public void setFontHeight(short height) {
        this.field_1_font_height = height;
    }

    public void setAttributes(short attributes) {
        this.field_2_attributes = attributes;
    }

    public void setItalic(boolean italics) {
        this.field_2_attributes = italic.setShortBoolean(this.field_2_attributes, italics);
    }

    public void setStrikeout(boolean strike) {
        this.field_2_attributes = strikeout.setShortBoolean(this.field_2_attributes, strike);
    }

    public void setMacoutline(boolean mac) {
        this.field_2_attributes = macoutline.setShortBoolean(this.field_2_attributes, mac);
    }

    public void setMacshadow(boolean mac) {
        this.field_2_attributes = macshadow.setShortBoolean(this.field_2_attributes, mac);
    }

    public void setColorPaletteIndex(short cpi) {
        this.field_3_color_palette_index = cpi;
    }

    public void setBoldWeight(short bw) {
        this.field_4_bold_weight = bw;
    }

    public void setSuperSubScript(short sss) {
        this.field_5_super_sub_script = sss;
    }

    public void setUnderline(byte u) {
        this.field_6_underline = u;
    }

    public void setFamily(byte f) {
        this.field_7_family = f;
    }

    public void setCharset(byte charset) {
        this.field_8_charset = charset;
    }

    public void setFontNameLength(byte len) {
        this.field_10_font_name_len = len;
    }

    public void setFontName(String fn) {
        this.field_11_font_name = fn;
    }

    public short getFontHeight() {
        return this.field_1_font_height;
    }

    public short getAttributes() {
        return this.field_2_attributes;
    }

    public boolean isItalic() {
        return italic.isSet(this.field_2_attributes);
    }

    public boolean isStruckout() {
        return strikeout.isSet(this.field_2_attributes);
    }

    public boolean isMacoutlined() {
        return macoutline.isSet(this.field_2_attributes);
    }

    public boolean isMacshadowed() {
        return macshadow.isSet(this.field_2_attributes);
    }

    public short getColorPaletteIndex() {
        return this.field_3_color_palette_index;
    }

    public short getBoldWeight() {
        return this.field_4_bold_weight;
    }

    public short getSuperSubScript() {
        return this.field_5_super_sub_script;
    }

    public byte getUnderline() {
        return this.field_6_underline;
    }

    public byte getFamily() {
        return this.field_7_family;
    }

    public byte getCharset() {
        return this.field_8_charset;
    }

    public byte getFontNameLength() {
        return this.field_10_font_name_len;
    }

    public String getFontName() {
        return this.field_11_font_name;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FONT]\n");
        buffer.append("    .fontheight      = ").append(Integer.toHexString(this.getFontHeight())).append("\n");
        buffer.append("    .attributes      = ").append(Integer.toHexString(this.getAttributes())).append("\n");
        buffer.append("         .italic     = ").append(this.isItalic()).append("\n");
        buffer.append("         .strikout   = ").append(this.isStruckout()).append("\n");
        buffer.append("         .macoutlined= ").append(this.isMacoutlined()).append("\n");
        buffer.append("         .macshadowed= ").append(this.isMacshadowed()).append("\n");
        buffer.append("    .colorpalette    = ").append(Integer.toHexString(this.getColorPaletteIndex())).append("\n");
        buffer.append("    .boldweight      = ").append(Integer.toHexString(this.getBoldWeight())).append("\n");
        buffer.append("    .supersubscript  = ").append(Integer.toHexString(this.getSuperSubScript())).append("\n");
        buffer.append("    .underline       = ").append(Integer.toHexString(this.getUnderline())).append("\n");
        buffer.append("    .family          = ").append(Integer.toHexString(this.getFamily())).append("\n");
        buffer.append("    .charset         = ").append(Integer.toHexString(this.getCharset())).append("\n");
        buffer.append("    .namelength      = ").append(Integer.toHexString(this.getFontNameLength())).append("\n");
        buffer.append("    .fontname        = ").append(this.getFontName()).append("\n");
        buffer.append("[/FONT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int realflen = this.getFontNameLength() * 2;
        LittleEndian.putShort(data, 0 + offset, (short)49);
        LittleEndian.putShort(data, 2 + offset, (short)(15 + realflen + 1));
        LittleEndian.putShort(data, 4 + offset, this.getFontHeight());
        LittleEndian.putShort(data, 6 + offset, this.getAttributes());
        LittleEndian.putShort(data, 8 + offset, this.getColorPaletteIndex());
        LittleEndian.putShort(data, 10 + offset, this.getBoldWeight());
        LittleEndian.putShort(data, 12 + offset, this.getSuperSubScript());
        data[14 + offset] = this.getUnderline();
        data[15 + offset] = this.getFamily();
        data[16 + offset] = this.getCharset();
        data[17 + offset] = this.field_9_zero;
        data[18 + offset] = this.getFontNameLength();
        data[19 + offset] = 1;
        if (this.getFontName() != null) {
            StringUtil.putUnicodeLE(this.getFontName(), data, 20 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return this.getFontNameLength() * 2 + 20;
    }

    public short getSid() {
        return 49;
    }

    public void cloneStyleFrom(FontRecord source) {
        this.field_1_font_height = source.field_1_font_height;
        this.field_2_attributes = source.field_2_attributes;
        this.field_3_color_palette_index = source.field_3_color_palette_index;
        this.field_4_bold_weight = source.field_4_bold_weight;
        this.field_5_super_sub_script = source.field_5_super_sub_script;
        this.field_6_underline = source.field_6_underline;
        this.field_7_family = source.field_7_family;
        this.field_8_charset = source.field_8_charset;
        this.field_9_zero = source.field_9_zero;
        this.field_10_font_name_len = source.field_10_font_name_len;
        this.field_11_font_name = source.field_11_font_name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.field_11_font_name == null ? 0 : this.field_11_font_name.hashCode());
        result = 31 * result + this.field_1_font_height;
        result = 31 * result + this.field_2_attributes;
        result = 31 * result + this.field_3_color_palette_index;
        result = 31 * result + this.field_4_bold_weight;
        result = 31 * result + this.field_5_super_sub_script;
        result = 31 * result + this.field_6_underline;
        result = 31 * result + this.field_7_family;
        result = 31 * result + this.field_8_charset;
        result = 31 * result + this.field_9_zero;
        result = 31 * result + this.field_10_font_name_len;
        return result;
    }

    public boolean sameProperties(FontRecord other) {
        return this.field_1_font_height == other.field_1_font_height && this.field_2_attributes == other.field_2_attributes && this.field_3_color_palette_index == other.field_3_color_palette_index && this.field_4_bold_weight == other.field_4_bold_weight && this.field_5_super_sub_script == other.field_5_super_sub_script && this.field_6_underline == other.field_6_underline && this.field_7_family == other.field_7_family && this.field_8_charset == other.field_8_charset && this.field_9_zero == other.field_9_zero && this.field_10_font_name_len == other.field_10_font_name_len && this.field_11_font_name.equals(other.field_11_font_name);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

