/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.cmd.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.app.cmd.i18n.Messages;
import org.eclipse.jubula.client.cmd.AbstractCmdlineClient;
import org.eclipse.jubula.client.cmd.JobConfiguration;
import org.eclipse.jubula.client.cmd.controller.IClcServer;
import org.eclipse.jubula.client.cmd.controller.intern.RmiBase;
import org.eclipse.jubula.client.core.AUTEvent;
import org.eclipse.jubula.client.core.AUTServerEvent;
import org.eclipse.jubula.client.core.AutStarterEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.IAUTEventListener;
import org.eclipse.jubula.client.core.IAUTServerEventListener;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.IServerEventListener;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.agent.AutRegistrationEvent;
import org.eclipse.jubula.client.core.agent.IAutRegistrationListener;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.communication.ServerConnection;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.utils.FileUtils;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionController
implements IAUTServerEventListener,
IServerEventListener,
IAUTEventListener,
ITestExecutionEventListener,
IAutRegistrationListener {
    private static final String AUT_STARTUP_DELAY_VAR = "GD_AUT_STARTUP_DELAY";
    private static final int AUT_STARTUP_DELAY_DEFAULT = 5000;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionController.class);
    private static ExecutionController instance;
    private JobConfiguration m_job;
    private boolean m_idle = false;
    private boolean m_isFirstAutStart = true;
    private boolean m_noErrorWhileExecution = true;
    private boolean m_shutdown = false;
    private boolean m_stopProcessing = false;
    private TestExecutionWatcher m_progress = new TestExecutionWatcher();
    private AutIdentifier m_startedAutId = null;
    private RmiBase m_rmiBase;
    private final ClcService m_clcServiceImpl = new ClcService();
    private boolean m_clientActive = false;

    private ExecutionController() {
        IClientTest clientTest = ClientTestFactory.getClientTest();
        clientTest.addAUTServerEventListener((IAUTServerEventListener)this);
        clientTest.addAutStarterEventListener((IServerEventListener)this);
        clientTest.addTestEventListener((IAUTEventListener)this);
        clientTest.addTestExecutionEventListener((ITestExecutionEventListener)this);
        AutAgentRegistration.getInstance().addListener((IAutRegistrationListener)this);
    }

    public static ExecutionController getInstance() {
        if (instance == null) {
            instance = new ExecutionController();
        }
        return instance;
    }

    public JobConfiguration initJob(File configFile) throws IOException {
        if (configFile != null) {
            BufferedReader in = null;
            StringWriter writer = new StringWriter();
            try {
                in = new BufferedReader(new FileReader(configFile));
                String line = null;
                while ((line = in.readLine()) != null) {
                    writer.write(line);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            String xml = writer.toString();
            this.m_job = JobConfiguration.readFromXML((String)xml);
        } else {
            this.m_job = new JobConfiguration();
        }
        return this.m_job;
    }

    public void simulateJob() {
        this.prepareExecution();
    }

    public boolean executeJob() throws CommunicationException {
        WatchdogTimer timer = null;
        if (this.m_job.getTimeout() > 0) {
            timer = new WatchdogTimer(this.m_job.getTimeout());
            timer.start();
        }
        IClientTest clientTest = ClientTestFactory.getClientTest();
        clientTest.connectToServer(this.m_job.getServer(), this.m_job.getPort());
        if (!ServerConnection.getInstance().isConnected()) {
            throw new CommunicationException(Messages.ConnectionToAUT_Agent, MessageIDs.E_COMMUNICATOR_CONNECTION);
        }
        clientTest.setRelevantFlag(this.m_job.isRelevant());
        this.prepareExecution();
        this.m_idle = true;
        if (this.m_shutdown) {
            AbstractCmdlineClient.printConsoleLn((String)Messages.ReceivedShutdownCommand, (boolean)true);
            this.endTestExecution();
        }
        try {
            if (this.m_rmiBase != null) {
                this.doClcService();
            } else if (this.m_job.getTestJob() != null) {
                this.ensureAutIsStarted(this.m_job.getActualTestSuite(), this.m_job.getAutConfig());
                this.doTestJob();
            } else {
                this.ensureAutIsStarted(this.m_job.getActualTestSuite(), this.m_job.getAutConfig());
                this.doTestSuite();
            }
        }
        catch (ToolkitPluginException toolkitPluginException) {
            AbstractCmdlineClient.printlnConsoleError((String)(String.valueOf(Messages.ExecutionControllerAUT) + Messages.ErrorMessageAUT_TOOLKIT_NOT_AVAILABLE));
        }
        if (timer != null) {
            timer.abort();
        }
        return this.isNoErrorWhileExecution();
    }

    /*
     * Unable to fully structure code
     */
    private void doTestSuite() {
        ** GOTO lbl12
        {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException v0) {}
            do {
                if (this.m_idle && !this.m_stopProcessing) continue block2;
                if (this.m_job.getActualTestSuite() == null || this.m_stopProcessing || this.m_idle || this.m_isFirstAutStart) continue;
                this.m_idle = true;
                AbstractCmdlineClient.printConsoleLn((String)("\t" + NLS.bind((String)Messages.ExecutionControllerTestSuiteBegin, (Object)this.m_job.getActualTestSuite().getName())), (boolean)true);
                ClientTestFactory.getClientTest().startTestSuite(this.m_job.getActualTestSuite(), this.m_job.getLanguage(), this.m_startedAutId != null ? this.m_startedAutId : this.m_job.getAutId(), this.m_job.isAutoScreenshot());
lbl12:
                // 3 sources

            } while (this.m_job.getActualTestSuite() != null && !this.m_stopProcessing);
        }
    }

    private void doTestJob() {
        AbstractCmdlineClient.printConsoleLn((String)("\t" + NLS.bind((String)Messages.ExecutionControllerTestJobBegin, (Object)this.m_job.getTestJob().getName())), (boolean)true);
        ClientTestFactory.getClientTest().startTestJob(this.m_job.getTestJob(), this.m_job.getLanguage(), this.m_job.isAutoScreenshot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClcService() throws ToolkitPluginException {
        IProjectPO project = this.m_job.getProject();
        String autConfigName = this.m_job.getAutConfigName();
        ITestSuitePO workUnit = null;
        IAUTConfigPO autConfig = null;
        block7: for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites((IProjectPO)project)) {
            for (IAUTConfigPO cfg : ts.getAut().getAutConfigSet()) {
                if (!autConfigName.equals(cfg.getName())) continue;
                workUnit = ts;
                autConfig = cfg;
                continue block7;
            }
        }
        if (workUnit != null && autConfig != null) {
            this.ensureAutIsStarted(workUnit, autConfig);
        }
        this.m_clientActive = true;
        do {
            ITestSuitePO ts;
            ts = this.m_rmiBase;
            synchronized (ts) {
                try {
                    this.m_rmiBase.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        } while (this.m_clientActive);
        if (autConfig != null) {
            try {
                AutIdentifier startedAutId = new AutIdentifier((String)autConfig.getConfigMap().get("AUT_ID"));
                if (ServerConnection.getInstance().isConnected()) {
                    ClientTestFactory.getClientTest().stopAut(startedAutId);
                }
            }
            catch (ConnectionException e) {
                LOG.info(Messages.ErrorWhileStoppingAUT, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopProcessing() {
        this.m_stopProcessing = true;
        if (this.m_rmiBase != null) {
            RmiBase rmiBase = this.m_rmiBase;
            synchronized (rmiBase) {
                this.m_rmiBase.notifyAll();
            }
        }
    }

    private void prepareExecution() {
        this.setLogDir();
        ExternalTestDataBP.setDataDir((File)new File(this.m_job.getDataDir()));
        Persistor.setDbConnectionName((DatabaseConnectionInfo)this.m_job.getDbscheme());
        Persistor.setUser((String)this.m_job.getDbuser());
        Persistor.setPw((String)this.m_job.getDbpw());
        Persistor.setUrl((String)this.m_job.getDb());
        if (!Persistor.init()) {
            throw new IllegalArgumentException(Messages.ExecutionControllerInvalidDBDataError, null);
        }
        this.loadProject();
    }

    private void setLogDir() {
        if (StringUtils.isNotEmpty((String)this.m_job.getResultDir())) {
            Validate.isTrue((boolean)FileUtils.isValidPath((String)this.m_job.getResultDir()), (String)Messages.ExecutionControllerLogPathError);
            ClientTestFactory.getClientTest().setLogPath(this.m_job.getResultDir());
        }
    }

    private void ensureAutIsStarted(ITestSuitePO ts, IAUTConfigPO autConf) throws ToolkitPluginException {
        if (ts != null && autConf != null) {
            IAUTMainPO aut = ts.getAut();
            AbstractCmdlineClient.printConsoleLn((String)(String.valueOf(Messages.ExecutionControllerAUT) + NLS.bind((String)Messages.ExecutionControllerAUTStart, (Object)aut.getName())), (boolean)true);
            AutIdentifier autToStart = new AutIdentifier((String)autConf.getConfigMap().get("AUT_ID"));
            AUTStartListener asl = new AUTStartListener(autToStart);
            ClientTestFactory.getClientTest().addTestEventListener((IAUTEventListener)asl);
            ClientTestFactory.getClientTest().addAUTServerEventListener((IAUTServerEventListener)asl);
            AutAgentRegistration.getInstance().addListener((IAutRegistrationListener)asl);
            ClientTestFactory.getClientTest().startAut(aut, autConf, this.m_job.getLanguage());
            this.m_startedAutId = autToStart;
            while (!asl.autStarted() && !asl.hasAutStartFailed()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.waitExternalTime();
        } else {
            this.m_idle = false;
            this.m_isFirstAutStart = false;
        }
    }

    private void waitExternalTime() {
        int timeToWait = 5000;
        try {
            String value = EnvironmentUtils.getProcessEnvironment().getProperty(AUT_STARTUP_DELAY_VAR);
            if (value == null) {
                value = System.getProperty(AUT_STARTUP_DELAY_VAR);
            }
            timeToWait = Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            Thread.sleep(timeToWait);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void loadProject() {
        AbstractCmdlineClient.printConsoleLn((String)(String.valueOf(Messages.ExecutionControllerDatabase) + NLS.bind((String)Messages.ExecutionControllerLoadingProject, (Object)this.m_job.getProjectName())), (boolean)true);
        try {
            IProjectPO actualProject = ProjectPM.loadProjectByNameAndVersion((String)this.m_job.getProjectName(), (int)this.m_job.getProjectMajor(), (int)this.m_job.getProjectMinor());
            if (actualProject != null) {
                ProjectPM.loadProjectInROSession((IProjectPO)actualProject);
                IProjectPO currentProject = GeneralStorage.getInstance().getProject();
                this.m_job.setProject(currentProject);
                AbstractCmdlineClient.printConsoleLn((String)(String.valueOf(Messages.ExecutionControllerDatabase) + NLS.bind((String)Messages.ExecutionControllerProjectLoaded, (Object)this.m_job.getProjectName())), (boolean)true);
            }
        }
        catch (JBException jBException) {}
        this.m_job.initAndValidate();
        AbstractCmdlineClient.printConsoleLn((String)Messages.ExecutionControllerProjectCompleteness, (boolean)true);
        CompletenessGuard.checkAll((Locale)this.m_job.getLanguage(), (INodePO)this.m_job.getProject());
        LinkedList<String> suitesWithIncompleteOM = new LinkedList<String>();
        LinkedList<String> suitesWithIncompleteTD = new LinkedList<String>();
        LinkedList<String> suitesWithMissingSpecTc = new LinkedList<String>();
        for (ITestSuitePO ts : this.m_job.getTestSuites()) {
            String tsName = ts.getName();
            if (!ts.getSumSpecTcFlag()) {
                suitesWithMissingSpecTc.add(NLS.bind((String)Messages.ExecutionControllerCheckSpecTc, (Object)tsName));
                AbstractCmdlineClient.printConsoleLn((String)NLS.bind((String)Messages.ExecutionControllerCheckSpecTc, (Object)tsName), (boolean)true);
            }
            if (!ts.getSumOMFlag(ts.getAut())) {
                suitesWithIncompleteOM.add(NLS.bind((String)Messages.ExecutionControllerCheckOM, (Object)tsName));
                AbstractCmdlineClient.printConsoleLn((String)NLS.bind((String)Messages.ExecutionControllerCheckOM, (Object)tsName), (boolean)true);
            }
            if (ts.getSumTdFlag(this.m_job.getLanguage())) continue;
            suitesWithIncompleteTD.add(NLS.bind((String)Messages.ExecutionControllerCheckTD, (Object)tsName));
            AbstractCmdlineClient.printConsoleLn((String)NLS.bind((String)Messages.ExecutionControllerCheckTD, (Object)tsName), (boolean)true);
        }
        StringBuilder sb = new StringBuilder(Messages.ExecutionControllerCheckError);
        sb.append(":");
        for (String suiteName : suitesWithIncompleteOM) {
            sb.append("\n\t");
            sb.append(suiteName);
            sb.append(". ");
        }
        for (String suiteName : suitesWithIncompleteTD) {
            sb.append("\n\t");
            sb.append(suiteName);
            sb.append(". ");
        }
        Validate.isTrue((suitesWithIncompleteOM.isEmpty() && suitesWithIncompleteTD.isEmpty() ? 1 : 0) != 0, (String)sb.toString());
    }

    public void stateChanged(AUTServerEvent event) {
        switch (event.getState()) {
            case 6: {
                AbstractCmdlineClient.printlnConsoleError((String)Messages.ExecutionControllerInvalidJarError);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 7: {
                AbstractCmdlineClient.printlnConsoleError((String)Messages.ExecutionControllerInvalidJREError);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 11: {
                AbstractCmdlineClient.printlnConsoleError((String)Messages.ExecutionControllerServerNotInstantiated);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 5: {
                AbstractCmdlineClient.printlnConsoleError((String)Messages.ExecutionControllerInvalidMainError);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 3: {
                AbstractCmdlineClient.printlnConsoleError((String)Messages.ExecutionControllerAUTStartError);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 2: {
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
            case 12: {
                AbstractCmdlineClient.printlnConsoleError((String)Messages.ExecutionControllerDotNetInstallProblem);
                this.stopProcessing();
                this.m_idle = false;
                break;
            }
        }
    }

    public void stateChanged(AutStarterEvent event) {
        AbstractCmdlineClient.printConsoleLn((String)NLS.bind((String)Messages.ExecutionControllerServer, (Object)event), (boolean)true);
        switch (event.getState()) {
            case 2: {
                break;
            }
        }
    }

    public void stateChanged(AUTEvent event) {
        switch (event.getState()) {
            case 1: {
                AbstractCmdlineClient.printConsoleLn((String)(String.valueOf(Messages.ExecutionControllerAUT) + Messages.ExecutionControllerAUTStarted), (boolean)true);
                AbstractCmdlineClient.printConsoleLn((String)Messages.ExecutionControllerTestExecution, (boolean)true);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                AbstractCmdlineClient.printlnConsoleError((String)Messages.ExecutionControllerAUTStartError);
                this.stopProcessing();
                break;
            }
            case 2: {
                AbstractCmdlineClient.printConsoleLn((String)(String.valueOf(Messages.ExecutionControllerAUT) + Messages.ExecutionControllerAUTStopped), (boolean)true);
                this.stopProcessing();
                break;
            }
            case 8: {
                return;
            }
        }
        if (this.m_isFirstAutStart) {
            this.m_idle = false;
            this.m_isFirstAutStart = false;
        }
    }

    public void stateChanged(TestExecutionEvent event) {
        if (event.getException() != null && event.getException() instanceof JBException) {
            String errorMsg = I18n.getString((String)event.getException().getMessage(), (boolean)true);
            AbstractCmdlineClient.printlnConsoleError((String)errorMsg);
        }
        switch (event.getState()) {
            case 6: {
                TestExecution.getInstance().getTrav().addExecStackModificationListener((IExecStackModificationListener)this.m_progress);
                break;
            }
            case 1: 
            case 14: {
                break;
            }
            case 7: {
                AbstractCmdlineClient.printConsoleLn((String)Messages.ExecutionControllerTestSuiteEnd, (boolean)true);
                this.m_job.getNextTestSuite();
                this.m_clcServiceImpl.tsDone(this.isNoErrorWhileExecution() ? 0 : 1);
                break;
            }
            case 9: {
                TestExecution.getInstance().pauseExecution(TestExecution.PauseMode.UNPAUSE);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.m_job.getNextTestSuite();
                break;
            }
        }
    }

    public void endTestExecution() {
        this.m_idle = false;
    }

    public void setJob(JobConfiguration job) {
        this.m_job = job;
        if (this.m_job.getServerPort() != null) {
            Integer port = Integer.parseInt(this.m_job.getServerPort());
            this.m_rmiBase = new RmiBase(port.intValue(), (IClcServer)this.m_clcServiceImpl);
        }
    }

    public void handleAutRegistration(AutRegistrationEvent event) {
        if ((event.getAutId().equals((Object)this.m_startedAutId) || event.getAutId().equals((Object)this.m_job.getAutId())) && event.getStatus() == AutRegistrationEvent.RegistrationStatus.Register) {
            AbstractCmdlineClient.printConsoleLn((String)(String.valueOf(Messages.ExecutionControllerAUT) + Messages.ExecutionControllerAUTStarted), (boolean)true);
            AbstractCmdlineClient.printConsoleLn((String)Messages.ExecutionControllerTestExecution, (boolean)true);
            if (this.m_isFirstAutStart) {
                this.m_idle = false;
                this.m_isFirstAutStart = false;
            }
        }
    }

    protected void setNoErrorWhileExecution(boolean noErrorWhileExecution) {
        this.m_noErrorWhileExecution = noErrorWhileExecution;
    }

    protected boolean isNoErrorWhileExecution() {
        return this.m_noErrorWhileExecution;
    }

    public class AUTStartListener
    implements IAUTEventListener,
    IAUTServerEventListener,
    IAutRegistrationListener {
        private boolean m_autStarted = false;
        private boolean m_autStartFailed = false;
        private Timer m_startFailedTimer = new Timer();
        private long m_autStartTimeout = 300000L;
        private AutIdentifier m_autToStart;

        public AUTStartListener(AutIdentifier autToStart) {
            this.m_autToStart = autToStart;
            this.m_startFailedTimer.schedule(new TimerTask(){

                public void run() {
                    AUTStartListener.this.setAutStartFailed(true);
                    AUTStartListener.this.removeListener();
                }
            }, this.m_autStartTimeout);
        }

        public synchronized boolean autStarted() {
            return this.m_autStarted;
        }

        public synchronized void stateChanged(AUTEvent event) {
            switch (event.getState()) {
                case 1: {
                    this.m_autStarted = true;
                    this.dispose();
                    break;
                }
            }
        }

        public synchronized boolean hasAutStartFailed() {
            return this.m_autStartFailed;
        }

        public void stateChanged(AUTServerEvent event) {
            switch (event.getState()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: 
                case 13: {
                    this.setAutStartFailed(true);
                    this.dispose();
                    break;
                }
            }
        }

        protected synchronized void setAutStartFailed(boolean autStartFailed) {
            this.m_autStartFailed = autStartFailed;
        }

        private void dispose() {
            this.m_startFailedTimer.cancel();
            this.removeListener();
        }

        protected void removeListener() {
            ClientTestFactory.getClientTest().removeTestEventListener((IAUTEventListener)this);
            ClientTestFactory.getClientTest().removeAUTServerEventListener((IAUTServerEventListener)this);
            AutAgentRegistration.getInstance().removeListener((IAutRegistrationListener)this);
        }

        public void handleAutRegistration(AutRegistrationEvent event) {
            if (event.getAutId().equals((Object)this.m_autToStart) && event.getStatus() == AutRegistrationEvent.RegistrationStatus.Register) {
                this.m_autStarted = true;
                this.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClcService
    implements IClcServer {
        private boolean m_tsRunning;
        private int m_result;

        private ClcService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int runTestSuite(String tsName, int timeout, Map<String, String> variables) {
            this.m_tsRunning = false;
            ExecutionController.this.m_stopProcessing = false;
            ExecutionController.this.setNoErrorWhileExecution(true);
            WatchdogTimer timer = null;
            if (timeout > 0) {
                timer = new WatchdogTimer(timeout);
            }
            this.m_result = 0;
            IProjectPO project = ExecutionController.this.m_job.getProject();
            ITestSuitePO workUnit = null;
            for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites((IProjectPO)project)) {
                if (!ts.getName().equals(tsName)) continue;
                workUnit = ts;
                break;
            }
            if (workUnit == null) {
                this.m_result = -1;
            } else {
                ClientTestFactory.getClientTest().startTestSuite(workUnit, ExecutionController.this.m_job.getLanguage(), ExecutionController.this.m_startedAutId, ExecutionController.this.m_job.isAutoScreenshot(), variables);
                this.m_tsRunning = true;
                timer.start();
            }
            while (!ExecutionController.this.m_stopProcessing && this.m_tsRunning) {
                RmiBase rmiBase = ExecutionController.this.m_rmiBase;
                synchronized (rmiBase) {
                    try {
                        ExecutionController.this.m_rmiBase.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (timer != null) {
                timer.abort();
            }
            return this.m_result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tsDone(int result) {
            this.m_result = result;
            this.m_tsRunning = false;
            if (ExecutionController.this.m_rmiBase != null) {
                RmiBase rmiBase = ExecutionController.this.m_rmiBase;
                synchronized (rmiBase) {
                    ExecutionController.this.m_rmiBase.notifyAll();
                }
            }
        }

        public void shutdown() {
            ExecutionController.this.m_clientActive = false;
            ExecutionController.this.stopProcessing();
        }
    }

    protected class TestExecutionWatcher
    implements IExecStackModificationListener {
        protected TestExecutionWatcher() {
        }

        public void stackIncremented(INodePO node) {
            String nodeType = "";
            if (node instanceof IEventExecTestCasePO) {
                IEventExecTestCasePO evPo = (IEventExecTestCasePO)node;
                if (evPo.getReentryProp() != ReentryProperty.RETRY) {
                    ExecutionController.this.setNoErrorWhileExecution(false);
                }
                nodeType = Messages.EventHandler;
            } else if (node instanceof ITestSuitePO) {
                nodeType = Messages.TestSuite;
            } else if (node instanceof IExecTestCasePO) {
                nodeType = Messages.TestCase;
            }
            AbstractCmdlineClient.printConsoleLn((String)(String.valueOf(nodeType) + Messages.UtilsSeparator + String.valueOf(node.getName())), (boolean)true);
        }

        public void stackDecremented() {
        }

        public void nextDataSetIteration() {
        }

        public void nextCap(ICapPO cap) {
            AbstractCmdlineClient.printConsoleLn((String)("\t" + Messages.Step + Messages.UtilsSeparator + String.valueOf(cap.getName())), (boolean)true);
        }

        public void retryCap(ICapPO cap) {
            AbstractCmdlineClient.printConsoleLn((String)("\t" + Messages.RetryStep + Messages.UtilsSeparator + String.valueOf(cap.getName())), (boolean)true);
        }
    }

    private final class WatchdogTimer
    extends Thread {
        private long m_stoptime;
        private boolean m_abort;

        public WatchdogTimer(int timeout) {
            super(Messages.WatchdogTimer);
            this.m_abort = false;
            this.setDaemon(true);
            this.m_stoptime = new Date().getTime();
            this.m_stoptime += (long)(timeout * 1000);
        }

        public void run() {
            do {
                TimeUtil.delay((long)1000L);
                if (!this.m_abort) continue;
                return;
            } while (new Date().getTime() < this.m_stoptime);
            AbstractCmdlineClient.printlnConsoleError((String)Messages.ExecutionControllerAbort);
            ClientTestFactory.getClientTest().stopTestExecution();
            ExecutionController.this.stopProcessing();
            TimeUtil.delay((long)30000L);
            if (!this.m_abort) {
                System.exit(1);
            }
        }

        public void abort() {
            this.m_abort = true;
            this.interrupt();
        }
    }
}

