/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.autagent.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.client.ui.rcp.actions.StartServerAction;
import org.eclipse.jubula.client.ui.rcp.utils.ServerManager;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConnectToEmbeddedAutAgentHandler
extends AbstractHandler
implements IHandler {
    public static final String CONNECT_TO_EMBEDDED_AGENT_CMD_ID = "org.eclipse.jubula.client.autagent.commands.ConnectToEmbeddedAutAgent";
    private static final String EMBEDDED_AGENT_HOSTNAME = "localhost";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (AutStarter.getInstance().getCommunicator() == null) {
            int port = Platform.getPreferencesService().getInt("org.eclipse.jubula.client.autagent", "org.eclipse.jubula.autagent.preference.port", 60000, null);
            try {
                AutStarter.getInstance().start(port, false, AutStarter.Verbosity.QUIET, false);
            }
            catch (Exception e) {
                ExecutionException execException = new ExecutionException("An error occurred while starting the embedded AUT Agent", (Throwable)e);
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.jubula.client.autagent", I18n.getString((String)"AUTAgent.StartCommErrorText", (Object[])new String[]{String.valueOf(port)}), (Throwable)e), 2);
                throw execException;
            }
        }
        StartServerAction connectToServerAction = new StartServerAction(new ServerManager.Server(EMBEDDED_AGENT_HOSTNAME, Integer.valueOf(AutStarter.getInstance().getCommunicator().getLocalPort())), 2);
        connectToServerAction.run();
        return null;
    }
}

