/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Locale;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.TestDataBP;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IModifiableParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ComboParamValidator;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.IntegerParamValueValidator;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.VariableParamValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParamInterfaceBP<T> {
    public void addDataSet(IParameterInterfacePO obj, int row) {
        obj.getDataManager().insertDataSet(row);
    }

    public void removeDataSet(IParameterInterfacePO paramNode, int row, IParamNameMapper mapper, Locale locale) {
        int colCount = paramNode.getDataManager().getColumnCount();
        int i = 0;
        while (i < colCount) {
            String uniqueId = paramNode.getDataManager().getUniqueIds().get(i);
            IParamDescriptionPO desc = paramNode.getParameterForUniqueId(uniqueId);
            if (desc != null) {
                GuiParamValueConverter conv = new GuiParamValueConverter(null, paramNode, locale, desc, AbstractParamInterfaceBP.createParamValueValidator(desc.getType(), false, new String[0]));
                this.startParameterUpdate(conv, locale, row, mapper);
            }
            ++i;
        }
        paramNode.getDataManager().removeDataSet(row);
    }

    public void startParameterUpdate(GuiParamValueConverter conv, Locale locale, int row, IParamNameMapper mapper) {
        IParameterInterfacePO paramNode = conv.getCurrentNode();
        IParamDescriptionPO paramDescription = conv.getDesc();
        String paramGuid = paramDescription.getUniqueId();
        if (paramNode.getParameterList().contains(conv.getDesc()) && !paramNode.getDataManager().getUniqueIds().contains(paramGuid)) {
            paramNode.getDataManager().addUniqueId(paramGuid);
        }
        try {
            ITestDataPO data = paramNode.getDataManager().getCell(row, paramDescription);
            String value = data.getValue(locale);
            String modelString = conv.getModelString();
            if (modelString != null && modelString.equals(value)) {
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        this.updateParam(conv, locale, mapper, row);
    }

    public static String getGuiStringForParamValue(IParameterInterfacePO node, IParamDescriptionPO desc, int rowCount, Locale locale) {
        String result = "";
        IParameterInterfacePO srcNode = node;
        IParamDescriptionPO srcDesc = desc;
        while (srcNode.getReferencedDataCube() != null) {
            srcDesc = (srcNode = srcNode.getReferencedDataCube()).getParameterForName(srcDesc.getName());
            if (srcDesc != null && desc.getType().equals(srcDesc.getType())) continue;
            return result;
        }
        if (srcDesc == null) {
            return result;
        }
        int col = srcNode.getDataManager().findColumnForParam(srcDesc.getUniqueId());
        if (col > -1 && srcNode.getDataManager().getDataSetCount() > rowCount) {
            IDataSetPO row = srcNode.getDataManager().getDataSet(rowCount);
            try {
                ITestDataPO td = row.getColumn(col);
                ModelParamValueConverter conv = new ModelParamValueConverter(td.getValue(locale), srcNode, locale, srcDesc);
                result = ((ParamValueConverter)conv).getGuiString();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return result;
    }

    protected abstract void updateParam(GuiParamValueConverter var1, Locale var2, IParamNameMapper var3, int var4);

    protected void writeTestDataEntry(ParamValueConverter conv, Locale locale, int dataSetRow) {
        ITestDataPO oldTd = null;
        IParamDescriptionPO desc = conv.getDesc();
        try {
            oldTd = conv.getCurrentNode().getDataManager().getCell(dataSetRow, desc);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        ITestDataPO td = this.createOrUpdateTestDataPO(oldTd, conv, locale);
        conv.getCurrentNode().getDataManager().updateCell(td, dataSetRow, desc.getUniqueId());
    }

    private ITestDataPO createOrUpdateTestDataPO(ITestDataPO testData, ParamValueConverter conv, Locale locale) {
        ITestDataPO td = null;
        td = testData != null ? testData : TestDataBP.instance().createEmptyTestData();
        td.setValue(locale, conv.getModelString(), GeneralStorage.getInstance().getProject());
        return td;
    }

    public void addParameter(String name, String type, IModifiableParameterInterfacePO obj, IParamNameMapper mapper) {
        obj.addParameter(type, name, mapper);
    }

    public abstract void removeParameter(IParamDescriptionPO var1, T var2, Locale var3);

    public void renameParameters(IParamDescriptionPO desc, String newName, ParamNameBPDecorator mapper) {
        mapper.addNameToUpdate(desc.getUniqueId(), newName);
    }

    public static IParamValueValidator createParamValueValidator(String type, boolean valuesAreCombinable, String ... values) {
        if ("java.lang.Integer".equals(type)) {
            return new IntegerParamValueValidator(Integer.MIN_VALUE, Integer.MAX_VALUE, values);
        }
        if ("guidancer.datatype.Variable".equals(type)) {
            return new VariableParamValueValidator();
        }
        if ("java.lang.String".equals(type)) {
            return new NullValidator();
        }
        if ("Combo".equals(type) || "java.lang.Boolean".equals(type)) {
            return new ComboParamValidator(values, valuesAreCombinable);
        }
        return new NullValidator();
    }
}

