/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.db;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBP {
    private static final Logger LOG = LoggerFactory.getLogger(NodeBP.class);

    protected NodeBP() {
    }

    protected static void lockPO(EditSupport editSupport, INodePO node) throws PMObjectDeletedException, PMDirtyVersionException, PMAlreadyLockedException {
        EntityManager lockSession = editSupport.getSession();
        try {
            try {
                lockSession.detach((Object)node);
                lockSession.find(node.getClass(), (Object)node.getId());
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForEditor(node, e, editSupport);
            }
        }
        catch (PMDirtyVersionException pMDirtyVersionException) {
        }
        catch (PMObjectDeletedException e) {
            throw e;
        }
        catch (PMException e) {
            LOG.error(String.valueOf(Messages.StrayPersistenceException) + "." + ".", (Throwable)((Object)e));
        }
        if (!LockManager.instance().lockPO(lockSession, node, false)) {
            throw new PMAlreadyLockedException(node, String.valueOf(Messages.OrginalTestcaseLocked) + ".", MessageIDs.E_OBJECT_IN_USE);
        }
    }

    public static List<? extends INodePO> getAllNodesForGivenTypeInCurrentProject(Class type) {
        if (INodePO.class.isAssignableFrom(type)) {
            GeneralStorage gs = GeneralStorage.getInstance();
            return NodePM.computeListOfNodes(type, gs.getProject().getId(), gs.getMasterSession());
        }
        return ListUtils.EMPTY_LIST;
    }

    public static boolean isEditable(IPersistentObject po) {
        Validate.notNull((Object)po);
        IProjectPO activeProject = GeneralStorage.getInstance().getProject();
        if (activeProject == po) {
            return true;
        }
        return activeProject != null && activeProject.getId().equals(po.getParentProjectId());
    }
}

