/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.problems;

import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.Problem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemType;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProblemFactory {
    private ProblemFactory() {
    }

    public static IProblem createIncompleteTestDataProblem(Locale loc) {
        return new Problem(Messages.ProblemIncompleteTestDataMarkerText, (IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.ProblemIncompleteTestDataMarkerTooltip), loc, ProblemType.REASON_TD_INCOMPLETE);
    }

    public static IProblem createIncompleteObjectMappingProblem(IAUTMainPO aut) {
        return new Problem(Messages.ProblemIncompleteObjectMappingMarkerText, (IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.ProblemIncompleteObjectMappingMarkerTooltip), aut, ProblemType.REASON_OM_INCOMPLETE);
    }

    public static IProblem createMissingReferencedSpecTestCasesProblem() {
        return new Problem(Messages.ProblemMissingReferencedTestCaseMarkerText, (IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.ProblemMissingReferencedTestCaseMarkerTooltip), null, ProblemType.REASON_MISSING_SPEC_TC);
    }

    public static IProblem createProblem(IStatus status) {
        return new Problem(null, status, null, ProblemType.EXTERNAL);
    }

    public static IProblem createProblemWithMarker(IStatus status, String markerMessage) {
        return new Problem(markerMessage, status, null, ProblemType.EXTERNAL);
    }

    public static IProblem getWorstProblem(Set<IProblem> problems) {
        IProblem worstProblem = null;
        for (IProblem problem : problems) {
            if (worstProblem != null && worstProblem.getSeverity() >= problem.getSeverity()) continue;
            worstProblem = problem;
        }
        return worstProblem;
    }
}

