/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.MonitoringValuePO;
import org.eclipse.jubula.tools.objects.IMonitoringValue;
import org.eclipse.jubula.tools.objects.MonitoringValue;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="TESTRESULT_SUMMARY")
class TestResultSummaryPO
implements ITestResultSummaryPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject {
    private transient Long m_id;
    private transient Integer m_version;
    private String m_testJobName;
    private String m_monitoringId;
    private Map<String, MonitoringValuePO> m_monitoringValues;
    private String m_monitoringValue;
    private String m_testJobGuid;
    private Date m_testJobStartTime;
    private Date m_testsuiteDate;
    private Date m_testsuiteStartTime;
    private Date m_testsuiteEndTime;
    private String m_testsuiteDuration;
    private Long m_projectID;
    private String m_projectGuid;
    private String m_projectName;
    private int m_projectMajorVersion;
    private int m_projectMinorVersion;
    private int m_testsuiteExpectedTeststeps;
    private int m_testsuiteExecutedTeststeps;
    private int m_testsuiteEventHandlerTeststeps;
    private String m_testsuiteLanguage;
    private String m_testsuiteName;
    private String m_testsuiteGuid;
    private int m_testsuiteStatus;
    private String m_autName;
    private String m_autId;
    private String m_autGuid;
    private String m_autConfigName;
    private String m_autConfigGuid;
    private String m_autAgentName;
    private String m_autHostname;
    private String m_autOS;
    private String m_autCmdParameter;
    private String m_autToolkit;
    private boolean m_testsuiteRelevant;
    private int m_testsuiteFailedTeststeps;
    private String m_guid;
    private String m_commentTitle;
    private String m_commentDetail;
    private byte[] m_monitoringReport;
    private boolean m_blobWritten;
    private String m_monitoringValueType;
    static final long serialVersionUID = 3991659751091886887L;
    protected transient Object _persistence_primaryKey;

    private TestResultSummaryPO() {
        this.m_id = null;
        this.m_version = null;
        this.m_autToolkit = null;
        this.m_testsuiteRelevant = true;
        this.m_testsuiteFailedTeststeps = -1;
        this.m_blobWritten = false;
    }

    TestResultSummaryPO(String guid) {
        this.m_id = null;
        this.m_version = null;
        this.m_autToolkit = null;
        this.m_testsuiteRelevant = true;
        this.m_testsuiteFailedTeststeps = -1;
        this.m_blobWritten = false;
        this.setInternalGuid(guid);
    }

    @Override
    @Id
    @GeneratedValue
    @Column(name="ID")
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Version
    @Column(name="INTERNAL_VERSION")
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Basic
    @Column(name="TEST_JOB_NAME", length=4000)
    public String getTestJobName() {
        return this.m_testJobName;
    }

    @Override
    public void setTestJobName(String testJobName) {
        this.m_testJobName = testJobName;
    }

    @Override
    @Basic
    @Column(name="INTERNAL_TEST_JOB_GUID", length=32)
    public String getInternalTestJobGuid() {
        return this.m_testJobGuid;
    }

    @Override
    public void setInternalTestJobGuid(String testJobGuid) {
        this.m_testJobGuid = testJobGuid;
    }

    @Override
    @Basic
    @Column(name="TEST_JOB_START_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTestJobStartTime() {
        return this.m_testJobStartTime;
    }

    @Override
    public void setTestJobStartTime(Date testJobStartTime) {
        this.m_testJobStartTime = testJobStartTime;
    }

    @Override
    public void setInternalProjectID(Long projectID) {
        this.m_projectID = projectID;
    }

    @Override
    @Basic
    @Column(name="INTERNAL_PROJECT_ID")
    public Long getInternalProjectID() {
        return this.m_projectID;
    }

    @Override
    public void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    @Override
    @Basic
    @Column(name="PROJECT_NAME", length=4000)
    public String getProjectName() {
        return this.m_projectName;
    }

    @Override
    @Basic
    @Column(name="PROJECT_MAJOR_VERSION", nullable=false)
    public int getProjectMajorVersion() {
        return this.m_projectMajorVersion;
    }

    @Override
    public void setProjectMajorVersion(int projectMajorVersion) {
        this.m_projectMajorVersion = projectMajorVersion;
    }

    @Override
    @Basic
    @Column(name="PROJECT_MINOR_VERSION", nullable=false)
    public int getProjectMinorVersion() {
        return this.m_projectMinorVersion;
    }

    @Override
    public void setProjectMinorVersion(int projectMinorVersion) {
        this.m_projectMinorVersion = projectMinorVersion;
    }

    @Override
    public void setInternalProjectGuid(String projectGuid) {
        this.m_projectGuid = projectGuid;
    }

    @Override
    @Basic
    @Column(name="INTERNAL_PROJECT_GUID", length=32)
    public String getInternalProjectGuid() {
        return this.m_projectGuid;
    }

    @Override
    public void setTestsuiteName(String tsName) {
        this.m_testsuiteName = tsName;
    }

    @Override
    @Basic
    @Column(name="TS_NAME", length=4000)
    public String getTestsuiteName() {
        return this.m_testsuiteName;
    }

    @Override
    public void setInternalTestsuiteGuid(String tsGuid) {
        this.m_testsuiteGuid = tsGuid;
    }

    @Override
    @Basic
    @Column(name="INTERNAL_TESTSUITE_GUID", length=32)
    public String getInternalTestsuiteGuid() {
        return this.m_testsuiteGuid;
    }

    @Override
    public void setTestsuiteStatus(int tsStatus) {
        this.m_testsuiteStatus = tsStatus;
    }

    @Override
    @Basic
    @Column(name="TS_STATUS", nullable=false)
    public int getTestsuiteStatus() {
        return this.m_testsuiteStatus;
    }

    @Override
    @Basic
    @Column(name="AUT_NAME", length=4000)
    public String getAutName() {
        return this.m_autName;
    }

    @Override
    public void setAutName(String autName) {
        this.m_autName = autName;
    }

    @Override
    @Basic
    @Column(name="AUT_ID", length=4000)
    public String getAutId() {
        return this.m_autId;
    }

    @Override
    public void setAutId(String autId) {
        this.m_autId = autId;
    }

    @Override
    @Basic
    @Column(name="INTERNAL_AUT_GUID", length=32)
    public String getInternalAutGuid() {
        return this.m_autGuid;
    }

    @Override
    public void setInternalAutGuid(String autGuid) {
        this.m_autGuid = autGuid;
    }

    @Override
    public void setAutConfigName(String autConf) {
        this.m_autConfigName = autConf;
    }

    @Override
    @Basic
    @Column(name="AUT_CONFIG_NAME", length=4000)
    public String getAutConfigName() {
        return this.m_autConfigName;
    }

    @Override
    public void setInternalAutConfigGuid(String autConfGuid) {
        this.m_autConfigGuid = autConfGuid;
    }

    @Override
    @Basic
    @Column(name="INTERNAL_AUT_CONFIG_GUID", length=32)
    public String getInternalAutConfigGuid() {
        return this.m_autConfigGuid;
    }

    @Override
    @Basic
    @Column(name="INTERNAL_GUID", length=32, unique=true)
    public String getInternalGuid() {
        return this.m_guid;
    }

    private void setInternalGuid(String guid) {
        this.m_guid = guid;
    }

    @Override
    public void setAutAgentName(String autServer) {
        this.m_autAgentName = autServer;
    }

    @Override
    @Basic
    @Column(name="AUT_AGENT_NAME", length=4000)
    public String getAutAgentName() {
        return this.m_autAgentName;
    }

    @Override
    @Basic
    @Column(name="AUT_HOSTNAME", length=4000)
    public String getAutHostname() {
        return this.m_autHostname;
    }

    @Override
    public void setAutHostname(String autHostname) {
        this.m_autHostname = autHostname;
    }

    @Override
    @Basic
    @Column(name="AUT_OS", length=4000)
    public String getAutOS() {
        return this.m_autOS;
    }

    @Override
    public void setAutOS(String autOS) {
        this.m_autOS = autOS;
    }

    @Override
    public void setTestsuiteLanguage(String language) {
        this.m_testsuiteLanguage = language;
    }

    @Override
    @Basic
    @Column(name="TS_LANGUAGE")
    public String getTestsuiteLanguage() {
        return this.m_testsuiteLanguage;
    }

    @Basic
    @Column(name="AUT_TOOLKIT")
    private String getHbmToolkit() {
        return this.m_autToolkit;
    }

    @Override
    @Transient
    public String getAutToolkit() {
        return this.getHbmToolkit();
    }

    @Override
    public void setAutToolkit(String toolkit) {
        this.setHbmToolkit(toolkit);
    }

    private void setHbmToolkit(String toolkit) {
        this.m_autToolkit = toolkit;
    }

    @Override
    public void setTestsuiteDate(Date testrunDate) {
        this.m_testsuiteDate = testrunDate;
    }

    @Override
    @Basic
    @Column(name="TS_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTestsuiteDate() {
        return this.m_testsuiteDate;
    }

    @Override
    public void setTestsuiteStartTime(Date startTime) {
        this.m_testsuiteStartTime = startTime;
    }

    @Override
    @Basic
    @Column(name="TS_START_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTestsuiteStartTime() {
        return this.m_testsuiteStartTime;
    }

    @Override
    public void setTestsuiteEndTime(Date endTime) {
        this.m_testsuiteEndTime = endTime;
    }

    @Override
    @Basic
    @Column(name="TS_END_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTestsuiteEndTime() {
        return this.m_testsuiteEndTime;
    }

    @Override
    public void setTestsuiteDuration(String duration) {
        this.m_testsuiteDuration = duration;
    }

    @Override
    @Basic
    @Column(name="TS_DURATION", length=4000)
    public String getTestsuiteDuration() {
        return this.m_testsuiteDuration;
    }

    @Override
    public void setTestsuiteExpectedTeststeps(int expecCaps) {
        this.m_testsuiteExpectedTeststeps = expecCaps;
    }

    @Override
    @Basic
    @Column(name="TS_EXPECTED_TESTSTEPS", nullable=false)
    public int getTestsuiteExpectedTeststeps() {
        return this.m_testsuiteExpectedTeststeps;
    }

    @Override
    public void setTestsuiteExecutedTeststeps(int execCaps) {
        this.m_testsuiteExecutedTeststeps = execCaps;
    }

    @Override
    @Basic
    @Column(name="TS_EXECUTED_TESTSTEPS", nullable=false)
    public int getTestsuiteExecutedTeststeps() {
        return this.m_testsuiteExecutedTeststeps;
    }

    @Override
    public void setTestsuiteEventHandlerTeststeps(int handlerCaps) {
        this.m_testsuiteEventHandlerTeststeps = handlerCaps;
    }

    @Override
    @Basic
    @Column(name="TS_EVENTHANDLER_TESTSTEPS", nullable=false)
    public int getTestsuiteEventHandlerTeststeps() {
        return this.m_testsuiteEventHandlerTeststeps;
    }

    @Override
    public void setAutCmdParameter(String cmdParam) {
        this.m_autCmdParameter = cmdParam;
    }

    @Override
    @Basic
    @Column(name="AUT_CMD_PARAMETER", length=400)
    public String getAutCmdParameter() {
        return this.m_autCmdParameter;
    }

    @Override
    @Basic
    @Column(name="TS_RELEVANT", nullable=false)
    public boolean isTestsuiteRelevant() {
        return this.m_testsuiteRelevant;
    }

    @Override
    public void setTestsuiteRelevant(boolean relevant) {
        this.m_testsuiteRelevant = relevant;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + "(" + this.m_id.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestResultSummaryPO) && !(obj instanceof ITestResultSummaryPO)) {
            return false;
        }
        ITestResultSummaryPO o = (ITestResultSummaryPO)obj;
        return this.getInternalGuid().equals(o.getInternalGuid());
    }

    public int hashCode() {
        return this.getInternalGuid().hashCode();
    }

    @Override
    @Transient
    public String getTestRunState() {
        switch (this.getTestsuiteStatus()) {
            case 0: {
                break;
            }
            case 3: {
                return "OK";
            }
            case 6: {
                return "STOPPED";
            }
            case 1: {
                return "OK";
            }
            case 2: {
                return "FAILED";
            }
            case 5: {
                return "FAILED";
            }
            case 4: {
                return "FAILED";
            }
            case 7: {
                return "STOPPED";
            }
            case 8: {
                return "OK";
            }
            case 9: {
                return "FAILED";
            }
            default: {
                return null;
            }
        }
        return null;
    }

    @Override
    @Transient
    public String getStatusString() {
        switch (this.getTestsuiteStatus()) {
            case 2: {
                return Messages.TestResultNodeStepfailed;
            }
            case 5: {
                return Messages.TestResultNodeErrorInChildren;
            }
            case 0: {
                return Messages.TestResultNodeNotYetTested;
            }
            case 1: {
                return Messages.TestResultNodeSuccessfullyTested;
            }
            case 6: {
                return Messages.TestResultNodeTesting;
            }
            case 7: {
                return Messages.TestResultNodeRetrying;
            }
            case 8: {
                return Messages.TestResultNodeSuccessRetry;
            }
            case 9: {
                return Messages.TestResultNodeAbort;
            }
        }
        return Messages.TestResultNodeUnknown;
    }

    @Override
    @Basic
    @Column(name="TS_FAILED_TESTSTEPS", nullable=false)
    public int getTestsuiteFailedTeststeps() {
        return this.m_testsuiteFailedTeststeps;
    }

    @Override
    public void setTestsuiteFailedTeststeps(int failedCaps) {
        this.m_testsuiteFailedTeststeps = failedCaps;
    }

    @Override
    @Basic
    @Column(name="COMMENT_TITLE", length=4000)
    public String getCommentTitle() {
        return this.m_commentTitle;
    }

    @Override
    public void setCommentTitle(String commentTitle) {
        this.m_commentTitle = commentTitle;
    }

    @Override
    @Basic
    @Column(name="COMMENT_DETAIL", length=4000)
    public String getCommentDetail() {
        return this.m_commentDetail;
    }

    @Override
    public void setCommentDetail(String commentDetail) {
        this.m_commentDetail = commentDetail;
    }

    @Override
    public void setInternalMonitoringId(String monitoringId) {
        this.m_monitoringId = monitoringId;
    }

    @Override
    @Basic
    @Column(name="INTERNAL_MONITORING_ID", length=50)
    public String getInternalMonitoringId() {
        return this.m_monitoringId;
    }

    private void setHbmMonitoringValues(Map<String, MonitoringValuePO> monitoringValue) {
        this.m_monitoringValues = monitoringValue;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="MONITORING_VALUE")
    @MapKeyColumn(name="MON_KEY")
    private Map<String, MonitoringValuePO> getHbmMonitoringValues() {
        return this.m_monitoringValues;
    }

    @Override
    @Transient
    public Map<String, IMonitoringValue> getMonitoringValues() {
        Map<String, MonitoringValuePO> tmpMapPO = this.getHbmMonitoringValues();
        HashMap<String, IMonitoringValue> tmpMap = new HashMap<String, IMonitoringValue>();
        for (Map.Entry<String, MonitoringValuePO> pairs : tmpMapPO.entrySet()) {
            MonitoringValuePO tmp = pairs.getValue();
            tmpMap.put(pairs.getKey(), (IMonitoringValue)new MonitoringValue(tmp.getValue(), tmp.getType(), tmp.getCategory(), tmp.isSignificant()));
        }
        return tmpMap;
    }

    @Override
    @Transient
    public void setMonitoringValues(Map<String, IMonitoringValue> map) {
        HashMap<String, MonitoringValuePO> tmpMap = new HashMap<String, MonitoringValuePO>();
        for (Map.Entry<String, IMonitoringValue> pairs : map.entrySet()) {
            MonitoringValue tmp = (MonitoringValue)pairs.getValue();
            tmpMap.put(pairs.getKey(), new MonitoringValuePO(tmp.getValue(), tmp.getType(), tmp.getCategory(), tmp.isSignificant()));
        }
        this.setHbmMonitoringValues(tmpMap);
    }

    @Override
    @Basic
    @Lob
    @Column(name="MONITORING_REPORT")
    public byte[] getReport() {
        return this.m_monitoringReport;
    }

    @Override
    public void setReport(byte[] report) {
        this.m_monitoringReport = report;
    }

    @Override
    @Basic
    @Column(name="M_REPORT_WRITTEN", nullable=false)
    public boolean isReportWritten() {
        return this.m_blobWritten;
    }

    @Override
    public void setReportWritten(boolean isWritten) {
        this.m_blobWritten = isWritten;
    }

    @Override
    @Basic
    @Column(name="M_VALUE_TYPE", length=30)
    public String getMonitoringValueType() {
        return this.m_monitoringValueType;
    }

    @Override
    public void setMonitoringValueType(String type) {
        this.m_monitoringValueType = type;
    }

    @Override
    @Basic
    @Column(name="MONITORING_VALUE")
    public String getMonitoringValue() {
        return this.m_monitoringValue;
    }

    @Override
    public void setMonitoringValue(String monitoringValue) {
        this.m_monitoringValue = monitoringValue;
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestResultSummaryPO(persistenceObject);
    }

    public TestResultSummaryPO(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "internalProjectGuid") {
            return this.internalProjectGuid;
        }
        if (string == "hbmMonitoringValues") {
            return this.hbmMonitoringValues;
        }
        if (string == "testsuiteDate") {
            return this.testsuiteDate;
        }
        if (string == "internalTestsuiteGuid") {
            return this.internalTestsuiteGuid;
        }
        if (string == "autHostname") {
            return this.autHostname;
        }
        if (string == "internalTestJobGuid") {
            return this.internalTestJobGuid;
        }
        if (string == "testsuiteFailedTeststeps") {
            return this.testsuiteFailedTeststeps;
        }
        if (string == "projectMajorVersion") {
            return this.projectMajorVersion;
        }
        if (string == "testJobName") {
            return this.testJobName;
        }
        if (string == "internalAutConfigGuid") {
            return this.internalAutConfigGuid;
        }
        if (string == "testsuiteDuration") {
            return this.testsuiteDuration;
        }
        if (string == "autName") {
            return this.autName;
        }
        if (string == "autAgentName") {
            return this.autAgentName;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "commentTitle") {
            return this.commentTitle;
        }
        if (string == "internalAutGuid") {
            return this.internalAutGuid;
        }
        if (string == "report") {
            return this.report;
        }
        if (string == "testsuiteStatus") {
            return this.testsuiteStatus;
        }
        if (string == "testJobStartTime") {
            return this.testJobStartTime;
        }
        if (string == "testsuiteRelevant") {
            return this.testsuiteRelevant;
        }
        if (string == "autId") {
            return this.autId;
        }
        if (string == "commentDetail") {
            return this.commentDetail;
        }
        if (string == "testsuiteLanguage") {
            return this.testsuiteLanguage;
        }
        if (string == "reportWritten") {
            return this.reportWritten;
        }
        if (string == "internalMonitoringId") {
            return this.internalMonitoringId;
        }
        if (string == "testsuiteEventHandlerTeststeps") {
            return this.testsuiteEventHandlerTeststeps;
        }
        if (string == "monitoringValue") {
            return this.monitoringValue;
        }
        if (string == "monitoringValueType") {
            return this.monitoringValueType;
        }
        if (string == "testsuiteName") {
            return this.testsuiteName;
        }
        if (string == "autConfigName") {
            return this.autConfigName;
        }
        if (string == "internalProjectID") {
            return this.internalProjectID;
        }
        if (string == "testsuiteExecutedTeststeps") {
            return this.testsuiteExecutedTeststeps;
        }
        if (string == "hbmToolkit") {
            return this.hbmToolkit;
        }
        if (string == "testsuiteExpectedTeststeps") {
            return this.testsuiteExpectedTeststeps;
        }
        if (string == "internalGuid") {
            return this.internalGuid;
        }
        if (string == "autCmdParameter") {
            return this.autCmdParameter;
        }
        if (string == "testsuiteStartTime") {
            return this.testsuiteStartTime;
        }
        if (string == "autOS") {
            return this.autOS;
        }
        if (string == "testsuiteEndTime") {
            return this.testsuiteEndTime;
        }
        if (string == "projectName") {
            return this.projectName;
        }
        if (string == "projectMinorVersion") {
            return this.projectMinorVersion;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "internalProjectGuid") {
            this.internalProjectGuid = (String)object;
            return;
        }
        if (string == "hbmMonitoringValues") {
            this.hbmMonitoringValues = (Map)object;
            return;
        }
        if (string == "testsuiteDate") {
            this.testsuiteDate = (Date)object;
            return;
        }
        if (string == "internalTestsuiteGuid") {
            this.internalTestsuiteGuid = (String)object;
            return;
        }
        if (string == "autHostname") {
            this.autHostname = (String)object;
            return;
        }
        if (string == "internalTestJobGuid") {
            this.internalTestJobGuid = (String)object;
            return;
        }
        if (string == "testsuiteFailedTeststeps") {
            this.testsuiteFailedTeststeps = (Integer)object;
            return;
        }
        if (string == "projectMajorVersion") {
            this.projectMajorVersion = (Integer)object;
            return;
        }
        if (string == "testJobName") {
            this.testJobName = (String)object;
            return;
        }
        if (string == "internalAutConfigGuid") {
            this.internalAutConfigGuid = (String)object;
            return;
        }
        if (string == "testsuiteDuration") {
            this.testsuiteDuration = (String)object;
            return;
        }
        if (string == "autName") {
            this.autName = (String)object;
            return;
        }
        if (string == "autAgentName") {
            this.autAgentName = (String)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "commentTitle") {
            this.commentTitle = (String)object;
            return;
        }
        if (string == "internalAutGuid") {
            this.internalAutGuid = (String)object;
            return;
        }
        if (string == "report") {
            this.report = (byte[])object;
            return;
        }
        if (string == "testsuiteStatus") {
            this.testsuiteStatus = (Integer)object;
            return;
        }
        if (string == "testJobStartTime") {
            this.testJobStartTime = (Date)object;
            return;
        }
        if (string == "testsuiteRelevant") {
            this.testsuiteRelevant = (Boolean)object;
            return;
        }
        if (string == "autId") {
            this.autId = (String)object;
            return;
        }
        if (string == "commentDetail") {
            this.commentDetail = (String)object;
            return;
        }
        if (string == "testsuiteLanguage") {
            this.testsuiteLanguage = (String)object;
            return;
        }
        if (string == "reportWritten") {
            this.reportWritten = (Boolean)object;
            return;
        }
        if (string == "internalMonitoringId") {
            this.internalMonitoringId = (String)object;
            return;
        }
        if (string == "testsuiteEventHandlerTeststeps") {
            this.testsuiteEventHandlerTeststeps = (Integer)object;
            return;
        }
        if (string == "monitoringValue") {
            this.monitoringValue = (String)object;
            return;
        }
        if (string == "monitoringValueType") {
            this.monitoringValueType = (String)object;
            return;
        }
        if (string == "testsuiteName") {
            this.testsuiteName = (String)object;
            return;
        }
        if (string == "autConfigName") {
            this.autConfigName = (String)object;
            return;
        }
        if (string == "internalProjectID") {
            this.internalProjectID = (Long)object;
            return;
        }
        if (string == "testsuiteExecutedTeststeps") {
            this.testsuiteExecutedTeststeps = (Integer)object;
            return;
        }
        if (string == "hbmToolkit") {
            this.hbmToolkit = (String)object;
            return;
        }
        if (string == "testsuiteExpectedTeststeps") {
            this.testsuiteExpectedTeststeps = (Integer)object;
            return;
        }
        if (string == "internalGuid") {
            this.internalGuid = (String)object;
            return;
        }
        if (string == "autCmdParameter") {
            this.autCmdParameter = (String)object;
            return;
        }
        if (string == "testsuiteStartTime") {
            this.testsuiteStartTime = (Date)object;
            return;
        }
        if (string == "autOS") {
            this.autOS = (String)object;
            return;
        }
        if (string == "testsuiteEndTime") {
            this.testsuiteEndTime = (Date)object;
            return;
        }
        if (string == "projectName") {
            this.projectName = (String)object;
            return;
        }
        if (string == "projectMinorVersion") {
            this.projectMinorVersion = (Integer)object;
            return;
        }
    }
}

