/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.AbstractActionBP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingLanguageBP
extends AbstractActionBP
implements DataEventDispatcher.IProjectLoadedListener {
    private static WorkingLanguageBP instance = null;
    private Locale m_currentLanguage = null;
    private DataEventDispatcher.IProjectPropertiesModifyListener m_projectPropertiesModifyListener = new DataEventDispatcher.IProjectPropertiesModifyListener(){

        public void handleProjectPropsChanged() {
            List langs = GeneralStorage.getInstance().getProject().getLangHelper().getLanguageList();
            if (WorkingLanguageBP.this.m_currentLanguage != null && !langs.contains(WorkingLanguageBP.this.m_currentLanguage)) {
                WorkingLanguageBP.this.m_currentLanguage = null;
                WorkingLanguageBP.this.setCurrentLanguage(WorkingLanguageBP.this.getWorkingLanguage());
            }
        }
    };
    private DataEventDispatcher.IDataChangedListener m_dataChangedListener = new DataEventDispatcher.IDataChangedListener(){

        public void handleDataChanged(DataChangedEvent ... events) {
            Plugin.showLangInfo();
            WorkingLanguageBP.this.setEnabledStatus();
        }
    };

    private WorkingLanguageBP() {
        DataEventDispatcher dispatcher = DataEventDispatcher.getInstance();
        dispatcher.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        dispatcher.addProjectPropertiesModifyListener(this.m_projectPropertiesModifyListener, true);
        dispatcher.addDataChangedListener(this.m_dataChangedListener, true);
    }

    public static WorkingLanguageBP getInstance() {
        if (instance == null) {
            instance = new WorkingLanguageBP();
        }
        return instance;
    }

    public boolean isTestSuiteLanguage(Locale locale, ITestSuitePO testSuite) {
        if (testSuite.getAut() == null) {
            return false;
        }
        return testSuite.getAut().getLangHelper().getLanguageList().contains(locale);
    }

    public Locale getWorkingLanguage() {
        Locale workingLang = null;
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            workingLang = this.m_currentLanguage != null ? this.m_currentLanguage : project.getDefaultLanguage();
        }
        return workingLang;
    }

    public List<Locale> getLanguages(IAUTMainPO aut) {
        return aut != null ? aut.getLangHelper().getLanguageList() : new ArrayList(0);
    }

    public void handleProjectLoaded() {
        this.resetWorkingLanguageBP();
        Plugin.showLangInfo();
    }

    private void resetWorkingLanguageBP() {
        this.m_currentLanguage = null;
        this.setEnabledStatus();
    }

    public void setCurrentLanguage(Locale currentLanguage) {
        this.m_currentLanguage = currentLanguage;
        Plugin.showLangInfo();
    }

    @Override
    public boolean isEnabled() {
        return !this.isWorkingLanguageNull();
    }

    private boolean isWorkingLanguageNull() {
        return this.getWorkingLanguage() == null;
    }

    public List<Locale> getDisplayableLanguages() {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null) {
            return currentProject.getLangHelper().getLanguageList();
        }
        List<Locale> emptyList = Collections.emptyList();
        return emptyList;
    }
}

