/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedIntText;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.JBText;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VersionDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private Integer m_majorVersionNumber = null;
    private Integer m_minorVersionNumber = null;
    private JBText m_majorVersionField;
    private JBText m_minorVersionField;
    private String m_message = "";
    private String m_wrongVersionError = "";
    private String m_doubleVersionError = "";
    private String m_majorLabel = "";
    private String m_minorLabel = "";
    private String m_image = "";
    private String m_shell = "";
    private String m_title = "";
    private Integer m_greatestMajor = null;
    private Integer m_greatestMinor = null;
    private int m_length = 255;

    public VersionDialog(Shell parentShell, String title, Integer greatestMajor, Integer greatestMinor, String message, String majorLabel, String minorLabel, String wrongVersionError, String doubleVersionError, String image, String shell) {
        this(parentShell, title, greatestMajor, greatestMinor, message, majorLabel, minorLabel, wrongVersionError, doubleVersionError, image, shell, 255);
    }

    private VersionDialog(Shell parentShell, String title, Integer greatestMajor, Integer greatestMinor, String message, String majorLabel, String minorLabel, String wrongNameError, String doubleNameError, String image, String shell, int maxLength) {
        super(parentShell);
        this.m_greatestMajor = greatestMajor;
        this.m_greatestMinor = greatestMinor + 1;
        this.m_message = message;
        this.m_majorLabel = majorLabel;
        this.m_minorLabel = minorLabel;
        this.m_wrongVersionError = wrongNameError;
        this.m_doubleVersionError = doubleNameError;
        this.m_image = image;
        this.m_shell = shell;
        this.m_title = title;
        this.m_length = maxLength;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.m_message);
        this.setTitle(this.m_title);
        this.setTitleImage(Plugin.getImage(this.m_image));
        this.getShell().setText(this.m_shell);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createVersionFields(area);
        this.createAdditionalComponents(area);
        LayoutUtil.createSeparator((Composite)parent);
        return area;
    }

    public void setStyle(int style) {
        this.setShellStyle(style);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.modifyVersionFieldAction();
        this.setMessage(this.m_message);
    }

    private void createVersionFields(Composite area) {
        new Label(area, 0).setText(this.m_majorLabel);
        this.m_majorVersionField = new CheckedIntText(area, 2052, false, 0, Integer.MAX_VALUE);
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_majorVersionField);
        this.m_majorVersionField.setLayoutData((Object)gridData);
        this.m_majorVersionField.setText(String.valueOf(this.m_greatestMajor));
        LayoutUtil.setMaxChar((Text)this.m_majorVersionField, (int)this.m_length);
        this.m_majorVersionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (VersionDialog.this.getButton(0) != null) {
                    VersionDialog.this.modifyVersionFieldAction();
                }
            }
        });
        new Label(area, 0).setText(this.m_minorLabel);
        this.m_minorVersionField = new CheckedIntText(area, 2052, false, 0, Integer.MAX_VALUE);
        gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_minorVersionField);
        this.m_minorVersionField.setLayoutData((Object)gridData);
        this.m_minorVersionField.setText(String.valueOf(this.m_greatestMinor));
        LayoutUtil.setMaxChar((Text)this.m_minorVersionField, (int)this.m_length);
        this.m_minorVersionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (VersionDialog.this.getButton(0) != null) {
                    VersionDialog.this.modifyVersionFieldAction();
                }
            }
        });
    }

    void handleButtonEvent() {
        FileDialog dialog = new FileDialog(Plugin.getShell(), 65536);
        dialog.setFilterPath(Utils.getLastDirPath());
        dialog.setText(Messages.InputDialogSelectJRE);
        String path = dialog.open();
        if (path != null) {
            Utils.storeLastDirPath(dialog.getFilterPath());
            this.m_majorVersionField.setText(path);
        }
    }

    boolean modifyVersionFieldAction() {
        boolean isCorrect = false;
        try {
            int maj = Integer.parseInt(this.m_majorVersionField.getText());
            int min = Integer.parseInt(this.m_minorVersionField.getText());
            isCorrect = maj > 0 && min >= 0 || maj >= 0 && min > 0;
        }
        catch (NumberFormatException numberFormatException) {}
        if (isCorrect) {
            this.enableOKButton();
            if (!this.isInputAllowed()) {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(this.m_doubleVersionError);
                isCorrect = false;
            }
        } else if (this.m_majorVersionField.getText().trim().length() == 0 || this.m_minorVersionField.getText().trim().length() == 0) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(NLS.bind((String)Messages.VersionDialogEmptyField, (Object)true));
            isCorrect = false;
        } else {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(this.m_wrongVersionError);
        }
        return isCorrect;
    }

    protected boolean isInputAllowed() {
        return true;
    }

    private void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        this.setErrorMessage(null);
    }

    protected void okPressed() {
        if (!this.modifyVersionFieldAction()) {
            return;
        }
        try {
            this.m_majorVersionNumber = Integer.parseInt(this.m_majorVersionField.getText());
            this.m_minorVersionNumber = Integer.parseInt(this.m_minorVersionField.getText());
            this.setReturnCode(0);
        }
        catch (NumberFormatException numberFormatException) {
            this.setReturnCode(1);
        }
        this.close();
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        return gridData;
    }

    public Integer getMajorVersionNumber() {
        return this.m_majorVersionNumber;
    }

    public Integer getMinorVersionNumber() {
        return this.m_minorVersionNumber;
    }

    public Integer getMajorFieldValue() {
        Integer value = null;
        try {
            value = Integer.parseInt(this.m_majorVersionField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public Integer getMinorFieldValue() {
        Integer value = null;
        try {
            value = Integer.parseInt(this.m_minorVersionField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    protected void setInputFieldText(String text) {
        this.m_majorVersionField.setText(text);
    }

    protected void createAdditionalComponents(Composite parent) {
        parent.setEnabled(true);
    }
}

