/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractRefactorHandler
extends AbstractHandler {
    protected String getNewTestCaseName(ExecutionEvent event) {
        String newTcName = null;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractTestCaseEditor) {
            AbstractTestCaseEditor editor = (AbstractTestCaseEditor)activePart;
            if (editor.isDirty()) {
                Dialog editorDirtyDlg = ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.Q_SAVE_AND_EXTRACT);
                if (editorDirtyDlg.getReturnCode() != 0) {
                    return null;
                }
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            String extractedTCName = this.getNewName(editor);
            InputDialog dialog = new InputDialog(Plugin.getShell(), Messages.NewTestCaseActionTCTitle, extractedTCName, Messages.NewTestCaseActionTCMessage, Messages.RenameActionTCLabel, Messages.RenameActionTCError, Messages.NewTestCaseActionDoubleTCName, "newTestCaseDialog.gif", Messages.NewTestCaseActionTCShell, false);
            dialog.setHelpAvailable(true);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogTestcaseExtractContextId");
            dialog.open();
            int retCode = dialog.getReturnCode();
            dialog.close();
            if (retCode == 0) {
                newTcName = dialog.getName();
            }
        }
        return newTcName;
    }

    private String getNewName(AbstractTestCaseEditor editor) {
        String execName;
        Object e;
        String newName = "New Test Case";
        IStructuredSelection cs = (IStructuredSelection)editor.getTreeViewer().getSelection();
        if (cs.size() == 1 && (e = cs.getFirstElement()) instanceof IExecTestCasePO && !StringUtils.isBlank((String)(execName = ((IExecTestCasePO)e).getName()))) {
            newName = execName;
        }
        return newName;
    }

    public static void registerParamNamesToSave(ISpecTestCasePO newSpecTc, ParamNameBPDecorator mapper) {
        for (IParamDescriptionPO desc : newSpecTc.getParameterList()) {
            mapper.registerParamDescriptions((ITcParamDescriptionPO)desc);
        }
    }
}

