/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionGUIController;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.eclipse.ui.handlers.HandlerUtil;

public class StopAutHandler
extends AbstractHandler {
    private IJobManager m_jobManager = Job.getJobManager();
    private String m_jobFamily = Messages.ClientCollectingInformation;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection) {
            MessageDialog dialog;
            IStructuredSelection structSel = (IStructuredSelection)sel;
            HashSet<AutIdentifier> autsToStop = new HashSet<AutIdentifier>();
            Object[] objectArray = structSel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObj = objectArray[n2];
                if (selectedObj instanceof AutIdentifier) {
                    autsToStop.add((AutIdentifier)selectedObj);
                }
                ++n2;
            }
            if (!autsToStop.isEmpty() && Plugin.getDefault().getPreferenceStore().getBoolean("ASKSTOPAUT_PREF_KEY") && (dialog = this.getConfirmDialog()).getReturnCode() != 0) {
                if (this.isJobRunning()) {
                    this.m_jobManager.cancel((Object)this.m_jobFamily);
                }
                return null;
            }
            for (AutIdentifier autId : autsToStop) {
                TestExecutionGUIController.stopAUT(autId);
            }
        }
        return null;
    }

    private MessageDialog getConfirmDialog() {
        String questionText = this.isJobRunning() ? Messages.StopAUTActionQuestionTextIfcollecting : Messages.StopAUTActionQuestionText;
        MessageDialog dialog = new MessageDialog(Plugin.getShell(), Messages.StopAUTActionShellTitle, null, questionText, 3, new String[]{Messages.DialogMessageButton_YES, Messages.DialogMessageButton_NO}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog;
    }

    private boolean isJobRunning() {
        Job[] jobs = this.m_jobManager.find((Object)this.m_jobFamily);
        return jobs.length > 0;
    }
}

