/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestDataNodePO;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTestDataManagerHandler
extends AbstractDeleteTreeItemHandler {
    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (activePart instanceof CentralTestDataEditor && currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            CentralTestDataEditor editor = (CentralTestDataEditor)activePart;
            if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                return null;
            }
            if (this.confirmDelete(structuredSelection)) {
                this.deleteSelection(editor, structuredSelection);
            }
        }
        return null;
    }

    @Override
    protected String getName(Object obj) {
        if (obj instanceof ITestDataNodePO) {
            return ((ITestDataNodePO)obj).getName();
        }
        return super.getName(obj);
    }

    private void deleteSelection(CentralTestDataEditor editor, IStructuredSelection structuredSelection) {
        ArrayList<String> reusedCubeList = new ArrayList<String>(0);
        HashSet<ITestDataCubePO> toCheck = new HashSet<ITestDataCubePO>();
        this.computeCubesToCheck(structuredSelection.toArray(), toCheck);
        for (ITestDataCubePO td : toCheck) {
            if (!TestDataCubeBP.isCubeReused((IParameterInterfacePO)td)) continue;
            reusedCubeList.add(td.getName());
        }
        if (reusedCubeList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            for (String s : reusedCubeList) {
                sb.append(" ");
                sb.append("-");
                sb.append(" ");
                sb.append(s);
                sb.append("\n");
            }
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_REUSED_TDC, (Object[])new Object[]{sb.toString()}, null);
        } else {
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object toDelete = objectArray[n2];
                if (toDelete instanceof ITestDataNodePO) {
                    ITestDataNodePO node = (ITestDataNodePO)toDelete;
                    editor.getEditorHelper().getEditSupport().getSession().remove((Object)node);
                    editor.getEditorHelper().setDirty(true);
                    ITestDataCategoryPO parent = node.getParent();
                    if (parent != null) {
                        parent.removeNode(node);
                    }
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
                }
                ++n2;
            }
        }
    }

    private void computeCubesToCheck(Object[] selectedObjects, Set<ITestDataCubePO> toCheck) {
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            if (selected instanceof ITestDataCubePO) {
                toCheck.add((ITestDataCubePO)selected);
            } else if (selected instanceof ITestDataCategoryPO) {
                ITestDataCategoryPO category = (ITestDataCategoryPO)selected;
                this.computeCubesToCheck(category.getCategoryChildren().toArray(), toCheck);
                toCheck.addAll(category.getTestDataChildren());
            }
            ++n2;
        }
    }
}

