/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.rename;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesDecorator;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ProjectComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.rename.AbstractRenameComponentNameHandler;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;

public class RenameComponentNameInViewHandler
extends AbstractRenameComponentNameHandler {
    public Object execute(ExecutionEvent event) {
        IComponentNamePO compName = this.getSelectedComponentName(event);
        if (compName != null) {
            EntityManager renameSession = Persistor.instance().openSession();
            try {
                try {
                    ProjectComponentNameMapper compNameMapper = new ProjectComponentNameMapper((IWritableComponentNameCache)new ComponentNamesDecorator(renameSession), GeneralStorage.getInstance().getProject());
                    String newName = this.getNewName(event, (IComponentNameMapper)compNameMapper, compName);
                    if (newName != null) {
                        EntityTransaction tx = Persistor.instance().getTransaction(renameSession);
                        this.rename((IWritableComponentNameMapper)compNameMapper, compName.getGuid(), newName);
                        Persistor.instance().commitTransaction(renameSession, tx);
                        compNameMapper.getCompNameCache().updateStandardMapperAndCleanup(GeneralStorage.getInstance().getProject().getId());
                        IComponentNamePO eventCompName = ComponentNamesBP.getInstance().getCompNamePo(compName.getGuid());
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)eventCompName, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.all);
                    }
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                    Persistor.instance().dropSession(renameSession);
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleGDProjectDeletedException();
                    Persistor.instance().dropSession(renameSession);
                }
            }
            finally {
                Persistor.instance().dropSession(renameSession);
            }
        }
        return null;
    }
}

