/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.propertytester;

import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ComponentNameReuseBP;
import org.eclipse.jubula.client.ui.rcp.propertytester.AbstractBooleanPropertyTester;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentNamePropertyTester
extends AbstractBooleanPropertyTester {
    public static final String IS_BEING_USED_PROP = "isBeingUsed";
    public static final String IS_DEFAULT_MAPPING_PROP = "isDefaultMapping";
    private static final String[] PROPERTIES = new String[]{"isBeingUsed", "isDefaultMapping"};

    @Override
    public boolean testImpl(Object receiver, String property, Object[] args) {
        IComponentNamePO compName = (IComponentNamePO)receiver;
        if (property.equals(IS_BEING_USED_PROP)) {
            return this.testIsBeingUsed(compName);
        }
        if (property.equals(IS_DEFAULT_MAPPING_PROP)) {
            return this.testIsDefaultMapping(compName);
        }
        return false;
    }

    private boolean testIsBeingUsed(IComponentNamePO compName) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        if (currentProject != null) {
            return ComponentNameReuseBP.getInstance().isCompNameReused(compName.getGuid());
        }
        return true;
    }

    private boolean testIsDefaultMapping(IComponentNamePO compName) {
        String name = compName.getName();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        return compSystem.getDefaultMappingNames().containsKey(name);
    }

    @Override
    public Class<? extends Object> getType() {
        return IComponentNamePO.class;
    }

    @Override
    public String[] getProperties() {
        return PROPERTIES;
    }
}

