/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.labelprovider.decorators;

import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.provider.labelprovider.decorators.AbstractLightweightLabelDecorator;
import org.eclipse.jubula.client.ui.rcp.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.TestSuiteBrowserLabelProvider;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.graphics.Image;

public class CompletenessDecorator
extends AbstractLightweightLabelDecorator {
    private static final int NO_DECORATION = -1;

    public void decorate(Object element, IDecoration decoration) {
        decoration.setForegroundColor(LayoutUtil.DEFAULT_OS_COLOR);
        INodePO node = (INodePO)element;
        if (this.shouldNotDecorate(node, decoration)) {
            return;
        }
        boolean flag = false;
        if (TestSuiteBrowserLabelProvider.isNodeActive(node)) {
            ITestSuitePO owningTestsuite = UINodeBP.getOwningTestSuite(node);
            if (owningTestsuite != null) {
                WorkingLanguageBP workLangBP = WorkingLanguageBP.getInstance();
                Locale locale = workLangBP.getWorkingLanguage();
                IAUTMainPO aut = owningTestsuite.getAut();
                if (element instanceof ITestSuitePO) {
                    ITestSuitePO execTs = (ITestSuitePO)element;
                    if (aut != null && !workLangBP.isTestSuiteLanguage(locale, owningTestsuite)) {
                        decoration.setForegroundColor(LayoutUtil.GRAY_COLOR);
                    } else {
                        decoration.setForegroundColor(LayoutUtil.DEFAULT_OS_COLOR);
                        boolean bl = flag = node.getSumTdFlag(locale) && node.getSumOMFlag(aut) && node.getSumSpecTcFlag();
                    }
                    if (execTs.getNodeListSize() == 0) {
                        flag = true;
                    }
                    if (aut == null) {
                        flag = false;
                    }
                } else if (node instanceof IExecTestCasePO) {
                    flag = node.getSumTdFlag(locale) && node.getSumOMFlag(aut) && node.getSumSpecTcFlag();
                } else if (node instanceof ICapPO) {
                    flag = this.decorateTestStep((ICapPO)node, locale, aut);
                }
            } else {
                flag = element instanceof ITestJobPO ? TestSuiteBrowserLabelProvider.isTestJobGuiValid((ITestJobPO)element) : (element instanceof IRefTestSuitePO ? TestSuiteBrowserLabelProvider.isRefTestSuiteGuiValid((IRefTestSuitePO)element) : true);
            }
        } else {
            flag = true;
        }
        CompletenessDecorator.setIcon(decoration, CompletenessDecorator.getStatus(node, flag));
    }

    private boolean decorateTestStep(ICapPO testStep, Locale locale, IAUTMainPO aut) {
        INodePO grandParent = testStep.getParentNode().getParentNode();
        boolean overWrittenName = false;
        boolean flag = false;
        if (grandParent instanceof IExecTestCasePO) {
            IExecTestCasePO execTC = (IExecTestCasePO)grandParent;
            for (ICompNamesPairPO pair : execTC.getCompNamesPairs()) {
                if (!pair.getFirstName().equals(testStep.getComponentName()) || pair.getSecondName() == null || pair.getSecondName().equals(testStep.getComponentName())) continue;
                overWrittenName = true;
                break;
            }
            flag = testStep.getCompleteTdFlag(locale);
            if (!overWrittenName) {
                flag = flag && testStep.getCompleteOMFlag(aut);
            }
        } else {
            flag = true;
        }
        return flag;
    }

    private boolean shouldNotDecorate(INodePO node, IDecoration decoration) {
        return node == null || node.getParentNode() == null || decoration.getDecorationContext() instanceof AbstractLightweightLabelDecorator.NonDecorationContext || node instanceof IProjectPO;
    }

    private static int getStatus(INodePO element, boolean flag) {
        if (!flag) {
            return 4;
        }
        int status = -1;
        for (IProblem problem : element.getProblems()) {
            if (problem.getSeverity() <= status) continue;
            status = problem.getSeverity();
        }
        return status;
    }

    private static void setIcon(IDecoration decoration, int status) {
        if (status == 4) {
            decoration.addOverlay(IconConstants.ERROR_IMAGE_DESCRIPTOR);
        } else if (status == 2) {
            Image warning = IconConstants.WARNING_SMALL_IMAGE;
            decoration.addOverlay(ImageDescriptor.createFromImage((Image)warning));
        }
    }
}

