/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.search.data.AbstractSearchData;
import org.eclipse.jubula.client.ui.rcp.search.data.TestDataSearchData;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractSearchQuery;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;

public class TestDataSearchQuery
extends AbstractSearchQuery {
    public TestDataSearchQuery(TestDataSearchData searchData) {
        this.setSearchData(searchData);
    }

    public IStatus run(IProgressMonitor monitor) {
        int operation = 1;
        if (this.getSearchData().isUseRegex()) {
            operation = 3;
        } else if (this.getSearchData().isCaseSensitive()) {
            operation = 2;
        }
        List<AbstractSearchData.SearchableType> listOfTypesToSearchIn = this.getSearchData().getTypesToSearchIn();
        HashSet setOfNodes = new HashSet();
        monitor.beginTask("Collecting all Elements...", listOfTypesToSearchIn.size());
        HashSet<ITestDataCubePO> centralTestData = new HashSet<ITestDataCubePO>();
        for (AbstractSearchData.SearchableType type : listOfTypesToSearchIn) {
            Class<? extends IPersistentObject> searchType = type.getType();
            if (INodePO.class.isAssignableFrom(searchType)) {
                setOfNodes.addAll(NodeBP.getAllNodesForGivenTypeInCurrentProject(searchType));
            } else if (ITestDataCubePO.class.isAssignableFrom(searchType)) {
                IProjectPO iProjectPO = GeneralStorage.getInstance().getProject();
                centralTestData.addAll(Arrays.asList(TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)iProjectPO)));
            }
            monitor.worked(1);
        }
        monitor.beginTask("Searching...", setOfNodes.size() + centralTestData.size());
        String searchString = this.getSearchData().getSearchString();
        HashSet<INodePO> nodeResultList = new HashSet<INodePO>();
        CollectionUtils.filter(setOfNodes, (Predicate)InstanceofPredicate.getInstance(IParamNodePO.class));
        for (INodePO node : setOfNodes) {
            IParamNodePO paramNode = (IParamNodePO)node;
            if (this.containsTestDataValue((IParameterInterfacePO)paramNode, searchString, operation)) {
                nodeResultList.add(node);
            }
            monitor.worked(1);
        }
        List<BasicSearchResult.SearchResultElement> results = this.getSearchResultList(nodeResultList, "org.eclipse.jubula.client.ui.rcp.views.DataSetView");
        for (IParameterInterfacePO iParameterInterfacePO : centralTestData) {
            if (this.containsTestDataValue(iParameterInterfacePO, searchString, operation)) {
                results.add(new BasicSearchResult.SearchResultElement<Long>(iParameterInterfacePO.getName(), iParameterInterfacePO.getId(), this.getImageForNode((IPersistentObject)iParameterInterfacePO), new BasicSearchResult.TestDataCubeSearchResultElementAction(), null, "org.eclipse.jubula.client.ui.rcp.views.DataSetView"));
            }
            monitor.worked(1);
        }
        this.setSearchResult(results);
        return Status.OK_STATUS;
    }

    private boolean containsTestDataValue(IParameterInterfacePO paramObj, String searchString, int operation) {
        Locale workingLanguage = WorkingLanguageBP.getInstance().getWorkingLanguage();
        List usedParameters = paramObj.getParameterList();
        IParameterInterfacePO refDataCube = paramObj.getReferencedDataCube();
        ITDManager testDataManager = paramObj.getDataManager();
        for (IDataSetPO dataSet : testDataManager.getDataSets()) {
            for (IParamDescriptionPO paramDesc : usedParameters) {
                ModelParamValueConverter converter;
                String value;
                ITestDataPO testData;
                IParamDescriptionPO dataCubeParam;
                int column = testDataManager.findColumnForParam(paramDesc.getUniqueId());
                if (refDataCube != null && (dataCubeParam = refDataCube.getParameterForName(paramDesc.getName())) != null) {
                    column = testDataManager.findColumnForParam(dataCubeParam.getUniqueId());
                }
                if (column == -1 || column >= dataSet.getColumnCount() || (testData = dataSet.getColumn(column)) == null || (value = (converter = new ModelParamValueConverter(testData, paramObj, workingLanguage, null)).getGuiString()) == null || !TestDataSearchQuery.compare(value, searchString, operation)) continue;
                return true;
            }
        }
        return false;
    }

    private void setSearchData(TestDataSearchData searchData) {
        super.setSearchData(searchData);
    }

    public TestDataSearchData getSearchData() {
        return (TestDataSearchData)super.getSearchData();
    }
}

