/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.utils;

import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.JBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServerManager.class);
    private static ServerManager instance = null;
    private SortedSet<Server> m_servers = new TreeSet<Server>();
    private Server m_lastUsedServer = null;

    private ServerManager() {
        this.readFromPrefStore();
    }

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    private void readFromPrefStore() {
        IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        String serversValue = prefStore.getString("SERVER_SETTINGS_KEY");
        String lastUsedServerValue = prefStore.getString("LAST_USED_SERVER_KEY");
        try {
            this.decodeServerPrefs(serversValue);
        }
        catch (JBException jbe) {
            LOG.error("Error occurred while loading AUT Agent preferences. Resetting to default values.", (Throwable)jbe);
            prefStore.setToDefault("SERVER_SETTINGS_KEY");
            try {
                this.decodeServerPrefs(serversValue);
            }
            catch (JBException jBException) {
                LOG.error("Error occurred while reading AUT Agent preferences default values.", (Throwable)jbe);
            }
        }
        this.m_lastUsedServer = !StringUtils.isEmpty((String)lastUsedServerValue) ? new Server(lastUsedServerValue.substring(0, lastUsedServerValue.indexOf(":")), new Integer(lastUsedServerValue.substring(lastUsedServerValue.indexOf(":") + 1))) : null;
    }

    private void decodeServerPrefs(String store) throws JBException {
        this.m_servers.clear();
        String[] serverStrings = StringUtils.split((String)store, (char)';');
        if (serverStrings.length % 2 == 0) {
            int i = 0;
            while (i < serverStrings.length) {
                String[] encodedPorts;
                String hostname = this.decodeString(serverStrings[i]);
                String[] stringArray = encodedPorts = StringUtils.split((String)serverStrings[i + 1], (char)',');
                int n = encodedPorts.length;
                int n2 = 0;
                while (n2 < n) {
                    String encodedPort = stringArray[n2];
                    String port = this.decodeString(encodedPort);
                    this.m_servers.add(new Server(hostname, Integer.valueOf(port)));
                    ++n2;
                }
                i += 2;
            }
        } else {
            throw new JBException("Number of entries in server list must be even.", Integer.valueOf(0));
        }
    }

    String decodeString(String encodedString) throws JBException {
        if (!Base64.isArrayByteBase64((byte[])encodedString.getBytes())) {
            throw new JBException("", new Integer(0));
        }
        return new String(Base64.decodeBase64((byte[])encodedString.getBytes()));
    }

    public void addServer(Server server) {
        Validate.notNull((Object)server, (String)(String.valueOf(Messages.ServerObjectMustNotBeNull) + "."));
        if (!server.getName().equals("") && !this.m_servers.contains(server)) {
            this.m_servers.add(server);
        }
    }

    public void removeServer(Server server) {
        if (this.m_lastUsedServer != null && this.m_lastUsedServer.equals(server)) {
            this.m_lastUsedServer = null;
        }
        this.m_servers.remove(server);
    }

    public void storeServerList() {
        StringBuilder storage = new StringBuilder();
        for (Server server : this.m_servers) {
            byte[] serverArray = server.getName().getBytes();
            String serverEncoded = new String(Base64.encodeBase64((byte[])serverArray));
            storage.append(serverEncoded).append(";");
            storage.append(new String(Base64.encodeBase64((byte[])server.getPort().toString().getBytes())));
            storage.append(";");
        }
        Plugin.getDefault().getPreferenceStore().setValue("SERVER_SETTINGS_KEY", storage.toString());
        if (this.m_lastUsedServer != null) {
            if (this.m_servers.contains(this.m_lastUsedServer)) {
                Plugin.getDefault().getPreferenceStore().setValue("LAST_USED_SERVER_KEY", this.buildLastUsedServerPortString(this.m_lastUsedServer));
            } else {
                this.m_lastUsedServer = null;
            }
        }
        DataEventDispatcher.getInstance().fireServerPreferencesChanged();
    }

    private String buildLastUsedServerPortString(Server lastUsedServer) {
        if (lastUsedServer != null) {
            return String.valueOf(lastUsedServer.getName()) + ":" + lastUsedServer.getPort();
        }
        Integer port = new Integer(-1);
        return ":" + port;
    }

    public Server getServer(String serverName, Integer port) {
        Server serv = null;
        for (Server server : this.m_servers) {
            if (!serverName.equals(server.getName()) || !server.getPort().equals(port)) continue;
            serv = server;
        }
        return serv;
    }

    public boolean containsServer(String serverName) {
        Validate.notNull((Object)serverName);
        for (Server server : this.m_servers) {
            if (!serverName.equals(server.getName())) continue;
            return true;
        }
        return false;
    }

    public SortedSet<String> getServerNames() {
        TreeSet<String> serverNames = new TreeSet<String>();
        for (Server server : this.m_servers) {
            if ("".equals(server.getName())) continue;
            serverNames.add(server.getName());
        }
        return serverNames;
    }

    public Server getLastUsedServer() {
        return this.m_lastUsedServer;
    }

    public SortedSet<Server> getServers() {
        return this.m_servers;
    }

    public void setServers(SortedSet<Server> servers) {
        this.m_servers = servers;
    }

    public void setLastUsedServer(Server server) {
        this.m_lastUsedServer = server;
    }

    public static class Server
    implements Comparable {
        private String m_name;
        private Integer m_port = new Integer(-1);

        public Server(String name, Integer port) {
            this.m_name = name;
            this.m_port = port;
        }

        public String getName() {
            return this.m_name;
        }

        public Integer getPort() {
            return this.m_port;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setPort(Integer port) {
            this.m_port = port;
        }

        public int compareTo(Object o) {
            Server server = (Server)o;
            if (this.getName().compareTo(server.getName()) == 0) {
                return this.getPort().compareTo(server.getPort());
            }
            return this.getName().compareTo(server.getName());
        }
    }
}

