/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.driver;

import java.awt.AWTError;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IMouseMotionTracker;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.IRobotEventInterceptor;
import org.eclipse.jubula.rc.common.driver.IRobotFactory;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.driver.KeyTyper;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.PointUtil;
import org.eclipse.jubula.rc.swing.components.SwingHierarchyContainer;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.swing.driver.ClickAwtEventMatcher;
import org.eclipse.jubula.rc.swing.swing.driver.DefaultAwtEventMatcher;
import org.eclipse.jubula.rc.swing.swing.driver.KeyAwtEventMatcher;
import org.eclipse.jubula.rc.swing.swing.driver.KeyReleasedEventMatcher;
import org.eclipse.jubula.rc.swing.swing.driver.MouseMovedAwtEventMatcher;
import org.eclipse.jubula.rc.swing.swing.driver.WindowActivationMethod;
import org.eclipse.jubula.rc.swing.utils.SwingUtils;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class RobotAwtImpl
implements IRobot {
    private static AutServerLogger log;
    private static final int MAX_RETRIES = 1;
    private static final String METAL_LAF_ID = "Metal";
    private Robot m_robot;
    private IRobotEventInterceptor m_interceptor;
    private IMouseMotionTracker m_mouseMotionTracker;
    private IEventThreadQueuer m_queuer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.driver.RobotAwtImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public RobotAwtImpl(IRobotFactory factory) throws RobotException {
        try {
            this.m_robot = new Robot();
            this.m_robot.setAutoWaitForIdle(false);
            this.m_robot.setAutoDelay(0);
        }
        catch (AWTException awte) {
            log.error((Object)awte);
            this.m_robot = null;
            throw new RobotException((Throwable)awte);
        }
        catch (SecurityException se) {
            log.error((Object)se);
            this.m_robot = null;
            throw new RobotException((Throwable)se);
        }
        this.m_interceptor = factory.getRobotEventInterceptor();
        this.m_mouseMotionTracker = factory.getMouseMotionTracker();
        this.m_queuer = factory.getEventThreadQueuer();
    }

    /*
     * Unable to fully structure code
     */
    private Point getLocation(Component component, final Point offset) throws IllegalArgumentException {
        Validate.notNull((Object)component, (String)"component must not be null");
        comp = component;
        runnable = new IRunnable(){

            public Object run() {
                Point pos = comp.getLocationOnScreen();
                if (offset == null) {
                    pos.x += comp.getBounds().width / 2;
                    pos.y += comp.getBounds().height / 2;
                } else {
                    pos.x += offset.x;
                    pos.y += offset.y;
                }
                return pos;
            }
        };
        point = null;
        exc = null;
        retries = 0;
        do {
            try {
                point = (Point)this.m_queuer.invokeAndWait("getLocation", runnable);
                continue;
            }
            catch (StepExecutionException e) {
                allElements = new ArrayList<V>(ComponentHandler.getAutHierarchy().getHierarchyMap().values());
                allCheckBoxes = new ArrayList<E>();
                i = 0;
                ** while (i < allElements.size())
            }
lbl-1000:
            // 1 sources

            {
                if (((SwingHierarchyContainer)allElements.get(i)).getComponentID().getRealComponent() instanceof JCheckBox) {
                    allCheckBoxes.add(allElements.get(i));
                }
                ++i;
                continue;
            }
lbl21:
            // 1 sources

            exc = e;
            RobotAwtImpl.log.error((Object)("getLocation failed - " + ++retries));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        } while (point == null && retries < true);
        if (point == null) {
            throw exc;
        }
        return point;
    }

    private void clickImpl(Object graphicsComponent, Object constraints, ClickOptions clickOptions, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute) throws RobotException {
        this.moveImpl(graphicsComponent, (Rectangle)constraints, xPos, xAbsolute, yPos, yAbsolute, clickOptions);
        this.clickImpl(graphicsComponent, clickOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clickImpl(Object graphicsComponent, ClickOptions clickOptions) {
        int buttonMask = this.getButtonMask(clickOptions.getMouseButton());
        int clickCount = clickOptions.getClickCount();
        int[] modifierMask = this.getModifierMask(clickOptions.getClickModifier());
        if (clickCount <= 0) return;
        InterceptorOptions options = new InterceptorOptions(new long[]{16L});
        IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
        try {
            this.pressModifier(modifierMask);
            RobotTiming.sleepPreClickDelay();
            int i = 0;
            while (true) {
                block5: {
                    if (i < clickCount) break block5;
                    if (clickOptions.isConfirmClick()) {
                        confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)new ClickAwtEventMatcher(clickOptions));
                    }
                    break;
                }
                this.m_robot.mousePress(buttonMask);
                RobotTiming.sleepPostMouseDownDelay();
                this.m_robot.mouseRelease(buttonMask);
                RobotTiming.sleepPostMouseUpDelay();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.releaseModifier(modifierMask);
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.releaseModifier(modifierMask);
            return;
        }
    }

    private void pressModifier(int[] modifierMask) {
        int i = 0;
        while (i < modifierMask.length) {
            this.keyPress(null, modifierMask[i]);
            ++i;
        }
    }

    private void releaseModifier(int[] modifierMask) {
        int i = 0;
        while (i < modifierMask.length) {
            this.keyRelease(null, modifierMask[i]);
            ++i;
        }
    }

    private int[] getModifierMask(ClickOptions.ClickModifier clickModifier) {
        int[] modifier = new int[]{};
        if (clickModifier.hasModifiers(1)) {
            modifier = ArrayUtils.add((int[])modifier, (int)SwingUtils.getSystemDefaultModifier());
        }
        if (clickModifier.hasModifiers(2)) {
            modifier = ArrayUtils.add((int[])modifier, (int)SwingUtils.getSystemModifier2());
        }
        if (clickModifier.hasModifiers(4)) {
            modifier = ArrayUtils.add((int[])modifier, (int)SwingUtils.getSystemModifier3());
        }
        if (clickModifier.hasModifiers(8)) {
            modifier = ArrayUtils.add((int[])modifier, (int)SwingUtils.getSystemModifier4());
        }
        return modifier;
    }

    private void preMove(Component component) throws RobotException {
        if (this.m_mouseMotionTracker.getLastMouseMotionEvent() == null) {
            Component root = SwingUtilities.getRoot(component);
            Component c = root != null ? root : component;
            Point p = this.getLocation(c, null);
            this.m_robot.mouseMove(p.x, p.y);
        }
    }

    private boolean isMouseMoveRequired(Point p) {
        boolean result = true;
        Point point = this.m_mouseMotionTracker.getLastMousePointOnScreen();
        if (point != null) {
            boolean bl = result = !point.equals(p);
            if (log.isDebugEnabled()) {
                MouseEvent event = (MouseEvent)this.m_mouseMotionTracker.getLastMouseMotionEvent();
                if (event != null) {
                    log.debug((Object)("Last mouse motion event point: " + event.getPoint()));
                }
                log.debug((Object)("Last converted screen point  : " + point));
                log.debug((Object)("Required screen point        : " + p));
                log.debug((Object)("Mouse move required?         : " + result));
            }
        }
        return result;
    }

    private void moveImpl(Object graphicsComponent, Rectangle constraints, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute, ClickOptions clickOptions) throws StepExecutionException {
        Point p;
        if (clickOptions.isScrollToVisible()) {
            this.ensureComponentVisible((Component)graphicsComponent, constraints);
        }
        Component component = (Component)graphicsComponent;
        this.preMove(component);
        Rectangle bounds = null;
        bounds = new Rectangle(this.getLocation(component, new Point(0, 0)));
        bounds.width = component.getWidth();
        bounds.height = component.getHeight();
        if (constraints != null) {
            bounds.x += constraints.x;
            bounds.y += constraints.y;
            bounds.height = constraints.height;
            bounds.width = constraints.width;
        }
        if (this.isMouseMoveRequired(p = PointUtil.calculateAwtPointToGo((int)xPos, (boolean)xAbsolute, (int)yPos, (boolean)yAbsolute, (Rectangle)bounds))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Moving mouse to: " + p));
            }
            InterceptorOptions options = new InterceptorOptions(new long[]{32L});
            IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
            Point ap = this.getAdjacentPoint(component, p);
            this.m_robot.mouseMove(ap.x, ap.y);
            RobotTiming.sleepPostMouseUpDelay();
            this.m_robot.mouseMove(p.x, p.y);
            if (clickOptions.isConfirmClick()) {
                confirmer.waitToConfirm((Object)component, (IEventMatcher)new MouseMovedAwtEventMatcher());
            }
        }
    }

    private Point getAdjacentPoint(Component comp, Point p) {
        Point result = new Point(p);
        result.x = p.x > comp.getX() ? --result.x : ++result.x;
        result.y = p.y > comp.getY() ? --result.y : ++result.y;
        return result;
    }

    public void click(Object graphicsComponent, Object constraints) throws RobotException {
        this.click(graphicsComponent, constraints, ClickOptions.create());
    }

    public void click(Object graphicsComponent, Object constraints, ClickOptions clickOptions) throws RobotException {
        this.clickImpl(graphicsComponent, constraints, clickOptions, 50, false, 50, false);
    }

    private int getButtonMask(int button) {
        switch (button) {
            case 1: {
                return 16;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 4;
            }
        }
        throw new RobotException("unsupported mouse button", null);
    }

    public void clickAtCurrentPosition(Object graphicsComponent, int clickCount, int button) {
        ClickOptions clickOptions = new ClickOptions();
        clickOptions.setClickCount(clickCount);
        clickOptions.setMouseButton(button);
        this.clickImpl(graphicsComponent, clickOptions);
    }

    public void doubleClick(Object graphicsComponent, Object constraints) throws RobotException {
        this.click(graphicsComponent, constraints, ClickOptions.create().setClickCount(2));
    }

    public void move(Object graphicsComponent, Object constraints) throws RobotException {
        this.moveImpl(graphicsComponent, (Rectangle)constraints, 50, false, 50, false, ClickOptions.create());
    }

    public void type(Object graphicsComponent, char character) throws RobotException {
        Validate.notNull((Object)graphicsComponent, (String)"The graphic component must not be null");
        try {
            int modifier = 0;
            Component component = (Component)graphicsComponent;
            KeyEvent ke = new KeyEvent(component, 401, System.currentTimeMillis(), modifier, 0, character);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ke);
            ke = new KeyEvent(component, 400, System.currentTimeMillis(), modifier, 0, character);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ke);
            IRobotEventConfirmer confirmer = this.m_interceptor.intercept(new InterceptorOptions(new long[]{8L}));
            ke = new KeyEvent(component, 402, System.currentTimeMillis(), modifier, 0, character);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ke);
            confirmer.waitToConfirm((Object)component, (IEventMatcher)new DefaultAwtEventMatcher(402));
        }
        catch (AWTError awte) {
            log.error((Object)awte);
            throw new RobotException((Throwable)awte);
        }
        catch (SecurityException se) {
            log.error((Object)se);
            throw new RobotException((Throwable)se);
        }
    }

    public void type(Object graphicsComponent, String text) throws RobotException {
        if (text != null) {
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                this.type(graphicsComponent, ch);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyType(Object graphicsComponent, int keycode) throws RobotException {
        try {
            InterceptorOptions options = new InterceptorOptions(new long[]{8L});
            IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
            try {
                this.m_robot.keyPress(keycode);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.m_robot.keyRelease(keycode);
                throw throwable;
            }
            {
                Object var5_8 = null;
                this.m_robot.keyRelease(keycode);
            }
            confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)new KeyAwtEventMatcher(402));
            return;
        }
        catch (IllegalArgumentException e) {
            throw new RobotException((Throwable)e);
        }
    }

    public String getSystemModifierSpec() {
        String keyStrokeSpec = "control";
        if (!UIManager.getLookAndFeel().getID().equals(METAL_LAF_ID)) {
            if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4) {
                keyStrokeSpec = "meta";
            } else if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 8) {
                keyStrokeSpec = "alt";
            }
        }
        return keyStrokeSpec;
    }

    private void keyPressReleaseImpl(Object graphicsComponent, int keyCode, boolean press) {
        InterceptorOptions options = new InterceptorOptions(new long[]{8L});
        IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
        if (press) {
            this.m_robot.keyPress(keyCode);
        } else {
            this.m_robot.keyRelease(keyCode);
        }
        confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)new KeyAwtEventMatcher(press ? 401 : 402));
    }

    public void keyPress(Object graphicsComponent, int keycode) throws RobotException {
        this.keyPressReleaseImpl(graphicsComponent, keycode, true);
    }

    public void keyRelease(Object graphicsComponent, int keycode) throws RobotException {
        this.keyPressReleaseImpl(graphicsComponent, keycode, false);
    }

    public void keyToggle(Object obj, int key, boolean activated) {
        Validate.notNull((Object)obj, (String)"The graphic component must not be null");
        if (activated && !((Component)obj).getToolkit().getLockingKeyState(key) || !activated && ((Component)obj).getToolkit().getLockingKeyState(key)) {
            this.keyPressReleaseImpl(null, key, true);
            this.keyPressReleaseImpl(null, key, false);
        }
    }

    public void keyStroke(String keyStrokeSpec) throws RobotException {
        try {
            KeyTyper.getInstance().type(keyStrokeSpec, this.m_interceptor, (IEventMatcher)new DefaultAwtEventMatcher(401), (IEventMatcher)new KeyReleasedEventMatcher());
        }
        catch (AWTException e) {
            throw new RobotException((Throwable)e);
        }
    }

    private void ensureComponentVisible(final Component component, final Rectangle bounds) throws RobotException {
        this.m_queuer.invokeAndWait("ensureVisible", new IRunnable(){

            public Object run() {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = bounds != null ? new Rectangle(bounds) : SwingUtilities.getLocalBounds(component);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scrolling rectangle to visible: " + rectangle));
                }
                Scroller scroller = new Scroller(component);
                scroller.scrollRectToVisible(rectangle);
                return null;
            }
        });
    }

    public void scrollToVisible(Object graphicsComponent, Object constraints) throws RobotException {
        this.ensureComponentVisible((Component)graphicsComponent, (Rectangle)constraints);
    }

    public void activateApplication(String method) throws RobotException {
        try {
            Window window = this.getActiveWindow();
            if (window == null) {
                return;
            }
            WindowActivationMethod wam = WindowActivationMethod.createWindowActivationMethod(method, this.m_robot, this.m_queuer);
            wam.activate(window);
            Window activeWindow = (Window)this.m_queuer.invokeAndWait("getActiveWindow", new IRunnable(){

                public Object run() throws StepExecutionException {
                    if (Frame.getFrames().length == 0) {
                        return null;
                    }
                    int i = 0;
                    while (i < Frame.getFrames().length) {
                        Window curWindow = Frame.getFrames()[i];
                        while (curWindow.getOwner() != null) {
                            curWindow = curWindow.getOwner();
                        }
                        if (curWindow.isFocused()) {
                            return curWindow;
                        }
                        ++i;
                    }
                    return null;
                }
            });
            if (activeWindow != window) {
                throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.WindowActivationFailed", (boolean)true), EventFactory.createActionError((String)"TestErrorEvent.WindowActivationFailed"));
            }
        }
        catch (Exception exc) {
            throw new RobotException((Throwable)exc);
        }
    }

    public Point getCurrentMousePosition() {
        return this.m_mouseMotionTracker.getLastMousePointOnScreen();
    }

    private Window getActiveWindow() {
        return (Window)this.m_queuer.invokeAndWait("getActiveWindow", new IRunnable(){

            public Object run() throws StepExecutionException {
                if (Frame.getFrames().length == 0) {
                    return null;
                }
                int i = 0;
                while (i < Frame.getFrames().length) {
                    Window window = Frame.getFrames()[i];
                    while (window.getOwner() != null) {
                        window = window.getOwner();
                    }
                    if (window.isVisible()) {
                        return window;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    public boolean isMouseInComponent(Object graphicsComponent) {
        boolean y2;
        Component comp = (Component)graphicsComponent;
        Point currMousePos = this.getCurrentMousePosition();
        if (currMousePos == null) {
            return false;
        }
        Point treeLocUpperLeft = comp.getLocationOnScreen();
        Rectangle bounds = comp.getBounds();
        Point treeLocLowerRight = new Point(bounds.width + treeLocUpperLeft.x, bounds.height + treeLocUpperLeft.y);
        boolean x1 = currMousePos.x >= treeLocUpperLeft.x;
        boolean x2 = currMousePos.x < treeLocLowerRight.x;
        boolean y1 = currMousePos.y >= treeLocUpperLeft.y;
        boolean bl = y2 = currMousePos.y < treeLocLowerRight.y;
        return x1 && x2 && y1 && y2;
    }

    public void mousePress(Object graphicsComponent, Object constraints, int button) {
        DragAndDropHelper.getInstance().setDragMode(true);
        if (graphicsComponent != null) {
            this.move(graphicsComponent, constraints);
        }
        RobotTiming.sleepPreClickDelay();
        this.m_robot.mousePress(this.getButtonMask(button));
    }

    public void mouseRelease(Object graphicsComponent, Object constraints, int button) throws RobotException {
        if (graphicsComponent != null) {
            this.move(graphicsComponent, constraints);
        }
        RobotTiming.sleepPreClickDelay();
        this.m_robot.mouseRelease(this.getButtonMask(button));
        DragAndDropHelper.getInstance().setDragMode(false);
    }

    public void click(Object graphicsComponent, Object constraints, ClickOptions clickOptions, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute) throws RobotException {
        this.clickImpl(graphicsComponent, constraints, clickOptions, xPos, xAbsolute, yPos, yAbsolute);
    }

    public String getPropertyValue(Object graphicsComponent, String propertyName) throws RobotException {
        String propertyValue = "";
        Validate.notNull((Object)graphicsComponent, (String)"Tested component must not be null");
        try {
            Object prop = PropertyUtils.getProperty((Object)graphicsComponent, (String)propertyName);
            propertyValue = String.valueOf(prop);
        }
        catch (IllegalAccessException e) {
            throw new RobotException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RobotException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RobotException((Throwable)e);
        }
        return propertyValue;
    }

    private class Scroller {
        private Component m_component;

        public Scroller(Component component) {
            this.m_component = component;
        }

        private void scrollRectToVisible(Component component, Rectangle aRect) {
            int dx = component.getX();
            int dy = component.getY();
            Container parent = component.getParent();
            while (parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane)) {
                Rectangle bounds = parent.getBounds();
                dx += bounds.x;
                dy += bounds.y;
                parent = parent.getParent();
            }
            if (parent != null && !(parent instanceof CellRendererPane)) {
                aRect.x += dx;
                aRect.y += dy;
                if (parent instanceof JComponent) {
                    ((JComponent)parent).scrollRectToVisible(aRect);
                    Point p1 = RobotAwtImpl.this.getLocation(this.m_component, null);
                    Point p2 = parent.getLocationOnScreen();
                    aRect.x = p1.x - p2.x;
                    aRect.y = p1.y - p2.y;
                }
            }
            if (parent != null) {
                this.scrollRectToVisible(parent, aRect);
            }
        }

        public void scrollRectToVisible(Rectangle aRect) {
            this.scrollRectToVisible(this.m_component, aRect);
        }
    }
}

