/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.implclasses.AbstractComboBoxHelper;
import org.eclipse.jubula.rc.swt.implclasses.CComboImplClass;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CComboBoxHelper
extends AbstractComboBoxHelper {
    private static AutServerLogger log;
    private IRobot m_robot;
    private IEventThreadQueuer m_eventThreadQueuer;
    private CComboImplClass m_implClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.CComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public CComboBoxHelper(CComboImplClass implClass) {
        Validate.notNull((Object)implClass, (String)"The CComboBox implementation class must not be null");
        this.m_robot = implClass.getRobot();
        this.m_eventThreadQueuer = implClass.getEventThreadQueuer();
        this.m_implClass = implClass;
    }

    protected List getDropdownList() throws StepExecutionException {
        return (List)this.m_eventThreadQueuer.invokeAndWait("getDropdownList", new IRunnable(){

            public Object run() throws StepExecutionException {
                Shell mainShell = SwtUtils.getShell((Widget)CComboBoxHelper.this.m_implClass.getComponent());
                Display d = Display.getCurrent();
                Shell[] shells = d.getShells();
                int i = 0;
                while (i < shells.length) {
                    List possibleDropdown;
                    Shell curShell = shells[i];
                    if (mainShell == curShell.getParent() && curShell.getChildren().length == 1 && curShell.getChildren()[0] instanceof List && !(possibleDropdown = (List)curShell.getChildren()[0]).isDisposed() && possibleDropdown.isVisible() && CComboBoxHelper.this.isDropdownList(possibleDropdown)) {
                        return possibleDropdown;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    private boolean isDropdownList(List list) {
        Rectangle comboBounds = SwtUtils.getWidgetBounds((Widget)this.m_implClass.getComponent());
        Rectangle listBounds = SwtUtils.getWidgetBounds((Widget)list);
        int posFuzz = 5;
        int dimFuzz = posFuzz * 2;
        comboBounds.x -= posFuzz;
        comboBounds.width += dimFuzz;
        comboBounds.y -= posFuzz;
        comboBounds.height += dimFuzz;
        return comboBounds.intersects(listBounds);
    }

    protected boolean isDropdownVisible() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.CComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Boolean visible = (Boolean)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "isDropdownVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                List dropdownList = CComboBoxHelper.this.getDropdownList();
                return dropdownList != null ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return visible;
    }

    protected void openDropdownList() {
        if (!this.isDropdownVisible()) {
            this.toggleDropdownList();
        }
        long timeout = 10000L;
        long done = System.currentTimeMillis() + timeout;
        while (!this.isDropdownVisible() && timeout >= 0L) {
            RobotTiming.sleepPreShowPopupDelay();
            long now = System.currentTimeMillis();
            timeout = done - now;
        }
        if (!this.isDropdownVisible()) {
            log.debug((Object)"Dropdown list still not visible, must be an error");
            throw new StepExecutionException("dropdown list not visible", EventFactory.createActionError((String)"TestErrorEvent.DropdownListNotFound"));
        }
    }

    protected void toggleDropdownList() {
        CCombo comboBox = (CCombo)this.m_implClass.getComponent();
        Rectangle r = this.findArrowIconArea();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Toggling dropdown by clicking on rectangle: " + r + "within component: " + comboBox));
        }
        this.m_robot.click((Object)comboBox, (Object)r, ClickOptions.create().setScrollToVisible(false).setConfirmClick(false));
    }

    private boolean isComboEditable() {
        Integer comboStyle;
        final CCombo combo = (CCombo)this.m_implClass.getComponent();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ((comboStyle = (Integer)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "isComboEditable", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(combo.getStyle());
            }
        })) & 8) == 0;
    }

    public void selectAll() {
        this.selectNone();
        this.m_eventThreadQueuer.invokeAndWait("selectAll", new IRunnable(){

            public Object run() throws StepExecutionException {
                CCombo combo = (CCombo)CComboBoxHelper.this.m_implClass.getComponent();
                combo.setSelection(new Point(0, combo.getText().length()));
                return null;
            }
        });
    }

    public void selectNone() {
        this.click(new Integer(3));
    }

    public void click(Integer count) {
        Control editor = this.m_implClass.getComponent();
        if (editor == null) {
            throw new StepExecutionException("no editor found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        this.m_robot.click((Object)editor, null, ClickOptions.create().setClickCount(count.intValue()));
    }

    public boolean isEditable() {
        return this.isComboEditable();
    }

    public String getSelectedValue() {
        Object o = this.m_eventThreadQueuer.invokeAndWait("getSelectedItem", new IRunnable(){

            public Object run() {
                CCombo comboBox = (CCombo)CComboBoxHelper.this.m_implClass.getComponent();
                return comboBox.getText();
            }
        });
        return o != null ? o.toString() : null;
    }

    protected void selectImpl(final int index) {
        this.scrollIndexToVisible(index);
        Rectangle clickConstraints = (Rectangle)this.m_eventThreadQueuer.invokeAndWait("setClickConstraints", new IRunnable(){

            public Object run() throws StepExecutionException {
                Rectangle constraints = SwtUtils.getRelativeWidgetBounds((Widget)CComboBoxHelper.this.getDropdownList(), (Control)CComboBoxHelper.this.getDropdownList());
                int displayedItemCount = CComboBoxHelper.this.getDisplayedItemCount();
                int numberBelowTop = 0;
                numberBelowTop = displayedItemCount >= CComboBoxHelper.this.getItemCount() ? index : Math.max(0, index - CComboBoxHelper.this.getItemCount() + displayedItemCount);
                constraints.height = CComboBoxHelper.this.getDropdownList().getItemHeight();
                constraints.y += numberBelowTop * constraints.height;
                return constraints;
            }
        });
        this.m_robot.click((Object)this.getDropdownList(), (Object)clickConstraints, new ClickOptions().setScrollToVisible(false));
    }

    private void scrollIndexToVisible(final int index) {
        this.m_eventThreadQueuer.invokeAndWait("scrollIndexToVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                CComboBoxHelper.this.getDropdownList().setTopIndex(index);
                return null;
            }
        });
    }

    private int getDisplayedItemCount() {
        return (Integer)this.m_eventThreadQueuer.invokeAndWait("getDisplayedItemCount", new IRunnable(){

            public Object run() throws StepExecutionException {
                List dropdown = CComboBoxHelper.this.getDropdownList();
                if (dropdown == null) {
                    return new Integer(0);
                }
                int listHeight = SwtUtils.getWidgetBounds((Widget)dropdown).height;
                int itemHeight = dropdown.getItemHeight();
                return new Integer(listHeight / itemHeight);
            }
        });
    }

    public int getSelectedIndex() {
        final CCombo combo = (CCombo)this.m_implClass.getComponent();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        int selectedIndex = (Integer)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "getSelectedIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(combo.getSelectionIndex());
            }
        });
        return selectedIndex;
    }

    public void input(String text, boolean replace) throws StepExecutionException, IllegalArgumentException {
        Validate.notNull((Object)text, (String)"text must not be null");
        Control editor = this.m_implClass.getComponent();
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        if (replace) {
            this.selectAll();
        } else {
            this.selectNone();
        }
        this.m_robot.type((Object)editor, text);
        this.m_robot.keyType(null, 0x1000050);
    }

    protected boolean isComboEnabled() {
        final CCombo combo = (CCombo)this.m_implClass.getComponent();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean isEnabled = (Boolean)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "isComboEnabled", new IRunnable(){

            public Object run() throws StepExecutionException {
                return combo.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEnabled;
    }

    protected Rectangle findArrowIconArea() {
        final Control comboBox = this.m_implClass.getComponent();
        Rectangle r = null;
        if (comboBox == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.ComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        r = (Rectangle)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "findArrowIconArea", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.getRelativeWidgetBounds((Widget)comboBox, comboBox);
            }
        });
        r.x += r.width - r.height;
        r.width = r.height;
        return r;
    }

    protected int getItemCount() {
        final CCombo combo = (CCombo)this.m_implClass.getComponent();
        return (Integer)this.m_implClass.getEventThreadQueuer().invokeAndWait("getItemCount", new IRunnable(){

            public Object run() {
                return new Integer(combo.getItemCount());
            }
        });
    }

    protected String getItem(final int index) {
        final CCombo combo = (CCombo)this.m_implClass.getComponent();
        return (String)this.m_implClass.getEventThreadQueuer().invokeAndWait("getItem", new IRunnable(){

            public Object run() {
                return combo.getItem(index);
            }
        });
    }
}

