/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.persistence.PersistenceException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jubula.app.core.JubulaWorkbenchWindowAdvisor;
import org.eclipse.jubula.app.i18n.Messages;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBFatalException;
import org.eclipse.jubula.tools.exception.JBRuntimeException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.console.ConsoleView;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JubulaWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static Logger log = LoggerFactory.getLogger(JubulaWorkbenchAdvisor.class);

    public String getInitialWindowPerspectiveId() {
        return "org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJ_PROJECT", "icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJ_PROJECT_CLOSED", "icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "icons/full/etool16/problem_category.gif", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJS_ERROR_PATH", "icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJS_WARNING_PATH", "icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJS_INFO_PATH", "icons/full/obj16/info_tsk.gif", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_ELCL_QUICK_FIX_ENABLED", "icons/full/elcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_DLCL_QUICK_FIX_DISABLED", "icons/full/dlcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_DLGBAN_QUICKFIX_DLG", "icons/full/wizban/quick_fix.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "icons/full/wizban/saveas_wiz.gif", true);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new JubulaWorkbenchWindowAdvisor(configurer);
    }

    public void preStartup() {
        IDE.registerAdapters();
    }

    private void declareWorkbenchImage(IWorkbenchConfigurer configurerP, Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = ideBundle.getEntry(path);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        configurerP.declareImage(symbolicName, desc, shared);
    }

    public IAdaptable getDefaultPageInput() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot();
    }

    public void postStartup() {
        try {
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals("org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective")) {
                return;
            }
            PlatformUI.getWorkbench().showPerspective("org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            Plugin.showStatusLine(null);
        }
        catch (WorkbenchException e) {
            log.error(String.valueOf(Messages.CannotOpenThePerspective) + "org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective" + "(" + (Object)((Object)e) + ")" + ".");
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NO_PERSPECTIVE, (Object[])new Object[]{"org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective"}, null);
        }
        Plugin.getDefault().setClientStatus(Plugin.ClientStatus.RUNNING);
    }

    public void eventLoopException(Throwable exception) {
        if (exception instanceof RuntimeException) {
            if (OperationCanceledUtil.isOperationCanceled((RuntimeException)((RuntimeException)exception))) {
                return;
            }
            log.error(Messages.UnhandledRuntimeException, exception);
            if (exception instanceof JBRuntimeException) {
                ErrorHandlingUtil.createMessageDialog((Integer)((JBRuntimeException)exception).getErrorId());
                return;
            }
            if (exception instanceof PersistenceException) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_UNKNOWN_DB_ERROR);
                return;
            }
            if (exception instanceof IllegalStateException) {
                Location workspace = Platform.getInstanceLocation();
                if (workspace.isSet()) {
                    File workspaceDir = new File(workspace.getURL().getFile());
                    while (workspaceDir != null && !workspaceDir.exists()) {
                        workspaceDir = workspaceDir.getParentFile();
                    }
                    if (workspaceDir == null || !workspaceDir.canWrite()) {
                        String displayDir = this.getWorkspaceLocation();
                        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_INVALID_WORKSPACE, (Object[])new String[]{displayDir}, null);
                        return;
                    }
                }
            } else {
                StackTraceElement[] stackTraceArray = exception.getStackTrace();
                if (!this.checkStackTrace(exception, stackTraceArray)) {
                    return;
                }
            }
            if (!Plugin.isRCPException((Throwable)exception) && !Plugin.isContentAssistException((Throwable)exception)) {
                ErrorHandlingUtil.createMessageDialog((JBRuntimeException)new JBFatalException(exception, MessageIDs.E_UNEXPECTED_EXCEPTION));
            }
        } else {
            super.eventLoopException(exception);
        }
    }

    private boolean checkStackTrace(Throwable exception, StackTraceElement[] stackTraceArray) {
        int i = 0;
        while (i < stackTraceArray.length) {
            String className = stackTraceArray[i].getClassName();
            if (exception instanceof IllegalArgumentException && KeySequence.class.getName().equals(className)) {
                return false;
            }
            if (exception instanceof IllegalArgumentException && stackTraceArray[i].toString().contains("mylyn")) {
                return false;
            }
            if (exception instanceof ClassCastException && stackTraceArray[i].toString().contains("mylyn")) {
                return false;
            }
            if (exception instanceof NullPointerException && KeySequenceText.class.getName().equals(className)) {
                return false;
            }
            if (exception instanceof NullPointerException && className != null && className.startsWith(ConsoleView.class.getName())) {
                return false;
            }
            if (exception instanceof NullPointerException && Plugin.isGEFException((Throwable)exception)) {
                return false;
            }
            if (exception instanceof NumberFormatException && "org.eclipse.ui.views.ProblemView".equals(this.getActivePartId())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getWorkspaceLocation() {
        String displayDir;
        try {
            displayDir = new File(Platform.getInstanceLocation().getURL().getFile()).getCanonicalPath();
        }
        catch (IOException iOException) {
            displayDir = new File(Platform.getInstanceLocation().getURL().getFile()).getPath();
        }
        return displayDir;
    }

    private String getActivePartId() {
        String emptyString = "";
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return emptyString;
        }
        IWorkbenchWindow wbWin = wb.getActiveWorkbenchWindow();
        if (wbWin == null) {
            return emptyString;
        }
        IWorkbenchPage page = wbWin.getActivePage();
        if (page == null) {
            return emptyString;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return emptyString;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return emptyString;
        }
        return site.getId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean preShutdown() {
        try {
            Plugin.getDefault().setClientStatus(Plugin.ClientStatus.STOPPING);
            IWorkbenchWindow[] allWW = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (allWW != null) {
                int i = 0;
                while (i < allWW.length) {
                    IWorkbenchPage[] allWP = allWW[i].getPages();
                    if (allWP != null) {
                        int j = 0;
                        while (j < allWP.length) {
                            boolean areAllClosed = allWP[j].closeAllEditors(true);
                            if (!areAllClosed) {
                                return false;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ResourcesPlugin.getWorkspace().save(true, null);
            return super.preShutdown();
        }
        catch (CoreException e) {
            if (!log.isErrorEnabled()) return super.preShutdown();
            log.error(Messages.UnhandledRuntimeException, (Throwable)e);
        }
        return super.preShutdown();
    }
}

