/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.Validate;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.archive.XmlExporter;
import org.eclipse.jubula.client.archive.XmlImporter;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.archive.output.NullImportOutput;
import org.eclipse.jubula.client.archive.schema.ContentDocument;
import org.eclipse.jubula.client.archive.schema.Project;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlStorage {
    public static final String RECOMMENDED_CHAR_ENCODING = "UTF-16";
    private static final String[] SUPPORTED_CHAR_ENCODINGS = new String[]{"UTF-16", "UTF-8"};
    private static final String XML_HEADER_START = "<?xml";
    private static final String XML_HEADER_END = "?>";
    private static final char QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final String SCHEMA_NAMESPACE = "http://www.eclipse.org/jubula/client/archive/schema";
    private static final String EXEC_TC_XML_ELEMENT_NAME = "usedTestcase";
    private static final String XPATH_FOR_EXEC_TCS = "declare namespace s='http://www.eclipse.org/jubula/client/archive/schema' .//s:usedTestcase";
    private static Logger log = LoggerFactory.getLogger(XmlStorage.class);
    private static final String OLD_SCHEMA_NAMESPACE = "http://www.bredexsw.com/guidancer/client/importer/gdschema";

    private static String save(IProjectPO project, boolean includeTestResultSummaries, IProgressMonitor monitor) throws ProjectDeletedException, PMException {
        XmlOptions genOpts = new XmlOptions();
        genOpts.setCharacterEncoding(RECOMMENDED_CHAR_ENCODING);
        genOpts.setSaveInner();
        genOpts.setSaveAggressiveNamespaces();
        genOpts.setUseDefaultNamespace();
        genOpts.setSavePrettyPrint();
        ContentDocument contentDoc = ContentDocument.Factory.newInstance(genOpts);
        ContentDocument.Content content = contentDoc.addNewContent();
        Project prj = content.addNewProject();
        try {
            new XmlExporter(monitor).fillProject(prj, project, includeTestResultSummaries);
        }
        catch (OperationCanceledException operationCanceledException) {
            log.info(Messages.ExportOperationCanceled);
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        XmlOptions options = new XmlOptions(genOpts);
        ArrayList errors = new ArrayList();
        options.setErrorListener(errors);
        if (!contentDoc.validate(options)) {
            StringBuilder msgs = new StringBuilder("\n");
            for (Object msg : errors) {
                msgs.append(msg);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(Messages.ValidateFailed) + ":");
                log.debug("An error occured: ", (Object)msgs);
                log.debug("An error occured: ", (Object)contentDoc);
            }
            throw new PMSaveException("XML" + Messages.ValidateFailed + msgs.toString(), MessageIDs.E_FILE_IO);
        }
        return contentDoc.xmlText(genOpts);
    }

    public static IProjectPO load(String xmlString, boolean assignNewGuid, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, IProgressMonitor monitor, IProgressConsole io) throws PMReadException, JBVersionException, InterruptedException {
        return XmlStorage.load(xmlString, assignNewGuid, null, null, paramNameMapper, compNameCache, monitor, io);
    }

    public static IProjectPO load(String xmlString, boolean assignNewGuid, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, IProgressMonitor monitor) throws PMReadException, JBVersionException, InterruptedException {
        return XmlStorage.load(xmlString, assignNewGuid, null, null, paramNameMapper, compNameCache, monitor, new NullImportOutput());
    }

    public static IProjectPO load(String xmlString, boolean assignNewGuid, Integer majorVersion, Integer minorVersion, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, IProgressMonitor monitor) throws PMReadException, JBVersionException, InterruptedException {
        return XmlStorage.load(xmlString, assignNewGuid, majorVersion, minorVersion, paramNameMapper, compNameCache, monitor, new NullImportOutput());
    }

    public static IProjectPO load(String xmlString, boolean assignNewGuid, Integer majorVersion, Integer minorVersion, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, IProgressMonitor monitor, IProgressConsole io) throws PMReadException, JBVersionException, InterruptedException {
        try {
            ContentDocument contentDoc = XmlStorage.getContent(xmlString);
            Project projectXml = contentDoc.getContent().getProject();
            int numExecTestCases = projectXml.selectPath(XPATH_FOR_EXEC_TCS).length;
            monitor.beginTask("", numExecTestCases + 1);
            monitor.worked(1);
            if (assignNewGuid) {
                return new XmlImporter(monitor, io).createProject(projectXml, assignNewGuid, paramNameMapper, compNameCache);
            }
            if (majorVersion != null && minorVersion != null) {
                return new XmlImporter(monitor, io).createProject(projectXml, majorVersion, minorVersion, paramNameMapper, compNameCache);
            }
            return new XmlImporter(monitor, io).createProject(projectXml, paramNameMapper, compNameCache);
        }
        catch (XmlException xmlException) {
            throw new PMReadException(Messages.InvalidImportFile, MessageIDs.E_LOAD_PROJECT);
        }
        catch (InvalidDataException e) {
            throw new PMReadException(Messages.InvalidImportFile, e.getErrorId());
        }
    }

    private static ContentDocument getContent(String xmlString) throws XmlException, PMReadException {
        HashMap<String, String> substitutes = new HashMap<String, String>();
        substitutes.put(OLD_SCHEMA_NAMESPACE, SCHEMA_NAMESPACE);
        XmlOptions options = new XmlOptions();
        options.setLoadSubstituteNamespaces(substitutes);
        ContentDocument contentDoc = ContentDocument.Factory.parse(xmlString, options);
        ArrayList errors = new ArrayList();
        options.setErrorListener(errors);
        if (!contentDoc.validate(options)) {
            StringBuilder msgs = new StringBuilder("\n");
            for (Object msg : errors) {
                msgs.append(msg);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(Messages.ValidateFailed) + ":");
                log.debug("An error occured: ", (Object)msgs);
                log.debug("An error occured: ", (Object)contentDoc);
            }
            throw new PMReadException(String.valueOf(Messages.InvalidImportFile) + msgs.toString(), MessageIDs.E_LOAD_PROJECT);
        }
        return contentDoc;
    }

    public static String save(IProjectPO proj, String fileName, boolean includeTestResultSummaries, IProgressMonitor monitor) throws ProjectDeletedException, PMException {
        return XmlStorage.save(proj, fileName, includeTestResultSummaries, monitor, false, null);
    }

    public static String save(IProjectPO proj, String fileName, boolean includeTestResultSummaries, IProgressMonitor monitor, boolean writeToSystemTempDir, List<File> listOfProjectFiles) throws ProjectDeletedException, PMException {
        monitor.beginTask(Messages.XmlStorageSavingProject, XmlStorage.getWorkToSave(proj));
        Validate.notNull((Object)proj);
        FileOutputStream fOut = null;
        try {
            String xml = String.valueOf(XmlStorage.buildXmlHeader()) + XmlStorage.save(proj, includeTestResultSummaries, monitor);
            if (fileName == null) {
                String string = xml;
                return string;
            }
            try {
                if (writeToSystemTempDir) {
                    File fileInTempDir = XmlStorage.createTempFile(fileName);
                    if (listOfProjectFiles != null) {
                        listOfProjectFiles.add(fileInTempDir);
                    }
                    fOut = new FileOutputStream(fileInTempDir);
                } else {
                    fOut = new FileOutputStream(fileName);
                }
                IOCanceller canceller = new IOCanceller(monitor, fOut);
                canceller.startTask();
                fOut.write(xml.getBytes(RECOMMENDED_CHAR_ENCODING));
                canceller.taskFinished();
            }
            catch (FileNotFoundException e) {
                log.debug(String.valueOf(Messages.File) + " " + Messages.NotFound, (Throwable)e);
                throw new PMSaveException(String.valueOf(Messages.File) + " " + fileName + Messages.NotFound + ":" + " " + e.toString(), MessageIDs.E_FILE_IO);
            }
            catch (IOException e) {
                if (!monitor.isCanceled()) {
                    log.debug(Messages.GeneralIoExeption, (Throwable)e);
                    throw new PMSaveException(String.valueOf(Messages.GeneralIoExeption) + e.toString(), MessageIDs.E_FILE_IO);
                }
            }
            catch (PersistenceException e) {
                log.debug(String.valueOf(Messages.CouldNotInitializeProxy) + ".", (Throwable)e);
                throw new PMSaveException(e.getMessage(), MessageIDs.E_DATABASE_GENERAL);
            }
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (IOException e) {
                    log.error(String.valueOf(Messages.CantCloseOOS) + fOut.toString(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private static File createTempFile(String fileName) throws IOException {
        String fileNameSuffix;
        String fileNamePrefix;
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex < 0) {
            fileNamePrefix = fileName;
            fileNameSuffix = "";
        } else {
            fileNamePrefix = String.valueOf(fileName.substring(0, dotIndex)) + "_";
            fileNameSuffix = fileName.substring(dotIndex);
        }
        File fileInTempDir = File.createTempFile(fileNamePrefix, fileNameSuffix);
        return fileInTempDir;
    }

    private static String buildXmlHeader() {
        StringBuilder res = new StringBuilder(XML_HEADER_START);
        res.append(" ");
        res.append("version");
        res.append("=");
        res.append('\"');
        res.append("1");
        res.append(".");
        res.append("0");
        res.append('\"');
        res.append(" ");
        res.append("encoding");
        res.append("=");
        res.append('\"');
        res.append(RECOMMENDED_CHAR_ENCODING);
        res.append('\"');
        res.append(' ');
        res.append(XML_HEADER_END);
        res.append("\n");
        return res.toString();
    }

    public static StringBuilder readFileContent(URL projectURL, String encoding) throws IOException {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        try {
            int transfer;
            in = encoding != null ? new BufferedReader(new InputStreamReader(projectURL.openStream(), encoding)) : new BufferedReader(new InputStreamReader(projectURL.openStream()));
            char[] buff = new char[10240];
            while ((transfer = in.read(buff)) != -1) {
                result.append(buff, 0, transfer);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result;
    }

    private static String readProjectFile(URL fileURL) throws PMReadException {
        try {
            String encoding = XmlStorage.getCharacterEncoding(fileURL);
            StringBuilder result = XmlStorage.readFileContent(fileURL, encoding);
            String content = XmlStorage.checkAndReduceXmlHeader(result);
            return content;
        }
        catch (FileNotFoundException e) {
            log.debug(Messages.ClassSerializedCouldntFound, (Throwable)e);
            throw new PMReadException(e.toString(), MessageIDs.E_FILE_NOT_FOUND);
        }
        catch (IOException e) {
            log.debug(String.valueOf(Messages.FailedReadingFile) + ":" + " " + fileURL.getFile());
            throw new PMReadException(e.toString(), MessageIDs.E_FILE_IO);
        }
        catch (XmlException e) {
            log.debug(Messages.MalformedXMLData);
            throw new PMReadException(e.toString(), MessageIDs.E_LOAD_PROJECT);
        }
    }

    public static String getCharacterEncoding(URL xmlProjectURL) throws IOException {
        String[] stringArray = SUPPORTED_CHAR_ENCODINGS;
        int n = SUPPORTED_CHAR_ENCODINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String encoding = stringArray[n2];
            BufferedReader reader = new BufferedReader(new InputStreamReader(xmlProjectURL.openStream(), encoding));
            String firstLine = reader.readLine();
            if (firstLine != null && firstLine.contains(encoding)) {
                return encoding;
            }
            ++n2;
        }
        throw new IOException(String.valueOf(Messages.NoSupportedFileEncoding) + "!");
    }

    private static String checkAndReduceXmlHeader(StringBuilder xmlData) throws XmlException {
        int startPos = xmlData.indexOf(XML_HEADER_START);
        int endPos = xmlData.indexOf(XML_HEADER_END);
        if (startPos != 0 || endPos == -1) {
            throw new XmlException(Messages.NoHeaderFound);
        }
        return xmlData.substring(endPos += XML_HEADER_END.length());
    }

    public String checkAndReduceXmlHeaderForSaveAs(StringBuilder xmlData) throws PMReadException {
        String result = null;
        try {
            result = XmlStorage.checkAndReduceXmlHeader(xmlData);
        }
        catch (XmlException e) {
            throw new PMReadException(e.toString(), MessageIDs.E_SAVE_AS_PROJECT_FAILED);
        }
        return result;
    }

    public IProjectPO readProject(URL fileURL, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, boolean assignNewGuids, IProgressMonitor monitor, IProgressConsole io) throws PMReadException, JBVersionException, InterruptedException {
        return XmlStorage.load(XmlStorage.readProjectFile(fileURL), assignNewGuids, paramNameMapper, compNameCache, monitor, io);
    }

    public IProjectPO readProject(URL fileURL, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache, boolean assignNewGuids, IProgressMonitor monitor) throws PMReadException, JBVersionException, InterruptedException {
        return XmlStorage.load(XmlStorage.readProjectFile(fileURL), assignNewGuids, paramNameMapper, compNameCache, monitor, new NullImportOutput());
    }

    public static int getWorkToSave(IProjectPO project) {
        return new XmlExporter((IProgressMonitor)new NullProgressMonitor()).getPredictedWork(project);
    }

    public static int getWorkToSave(List<IProjectPO> projectsToSave) {
        int totalWork = 0;
        for (IProjectPO project : projectsToSave) {
            totalWork += XmlStorage.getWorkToSave(project);
        }
        return totalWork;
    }

    private static class IOCanceller
    extends TimerTask {
        private IProgressMonitor m_monitor;
        private OutputStream m_outputStream;
        private Timer m_timer;

        public IOCanceller(IProgressMonitor monitor, OutputStream outputStream) {
            this.m_monitor = monitor;
            this.m_outputStream = outputStream;
            this.m_timer = new Timer();
        }

        public void startTask() {
            this.m_timer.schedule((TimerTask)this, 1000L, 1000L);
        }

        public void taskFinished() {
            this.m_timer.cancel();
        }

        private void checkTask() {
            if (this.m_monitor.isCanceled()) {
                try {
                    this.m_outputStream.close();
                }
                catch (IOException e) {
                    log.error(Messages.ErrorWhileCloseOS, (Throwable)e);
                }
            }
        }

        public void run() {
            this.checkTask();
        }
    }
}

