/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletenessBP
implements DataEventDispatcher.IProjectOpenedListener,
DataEventDispatcher.ILanguageChangedListener {
    private static Logger log = LoggerFactory.getLogger(CompletenessBP.class);
    private static CompletenessBP instance;

    private CompletenessBP() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this, false);
        ded.addProjectOpenedListener((DataEventDispatcher.IProjectOpenedListener)this);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IExecutionListener saveListener = new IExecutionListener(){

            public void preExecute(String commandId, ExecutionEvent event) {
            }

            public void postExecuteSuccess(String commandId, Object returnValue) {
                CompletenessBP.this.completeProjectCheck();
            }

            public void postExecuteFailure(String commandId, ExecutionException exception) {
                CompletenessBP.this.completeProjectCheck();
            }

            public void notHandled(String commandId, NotHandledException exception) {
            }
        };
        commandService.getCommand("org.eclipse.ui.file.save").addExecutionListener(saveListener);
        commandService.getCommand("org.eclipse.ui.file.saveAll").addExecutionListener(saveListener);
    }

    public static CompletenessBP getInstance() {
        if (instance == null) {
            instance = new CompletenessBP();
        }
        return instance;
    }

    public void handleProjectOpened() {
        this.completeProjectCheck();
    }

    public void completeProjectCheck() {
        IProjectPO root = GeneralStorage.getInstance().getProject();
        if (root != null) {
            Plugin.startLongRunning(Messages.CompletenessCheckRunningOperation);
            try {
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new UICompletenessCheckOperation());
                }
                catch (InvocationTargetException e) {
                    log.error("An error occured: ", (Throwable)e);
                    Plugin.stopLongRunning();
                }
                catch (InterruptedException e) {
                    log.error("An error occured: ", (Throwable)e);
                    Plugin.stopLongRunning();
                }
            }
            finally {
                Plugin.stopLongRunning();
            }
        }
    }

    public void handleLanguageChanged(Locale locale) {
        IProjectPO root = GeneralStorage.getInstance().getProject();
        Locale wl = WorkingLanguageBP.getInstance().getWorkingLanguage();
        CompletenessGuard.checkTestData((Locale)wl, (INodePO)root);
        CompletenessBP.fireCompletenessCheckFinished();
    }

    private static void fireCompletenessCheckFinished() {
        DataEventDispatcher.getInstance().fireCompletenessCheckFinished();
    }

    public static class UICompletenessCheckOperation
    implements IRunnableWithProgress {
        public void run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.CompletenessCheckRunningOperation, -1);
            try {
                IProjectPO project = GeneralStorage.getInstance().getProject();
                Locale wl = WorkingLanguageBP.getInstance().getWorkingLanguage();
                CompletenessGuard.checkAll((Locale)wl, (INodePO)project);
                for (ISpecPersistable spec : project.getSpecObjCont().getSpecObjList()) {
                    CompletenessGuard.checkTestData((Locale)wl, (INodePO)spec);
                }
            }
            finally {
                CompletenessBP.fireCompletenessCheckFinished();
                monitor.done();
            }
        }
    }
}

