/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractMergeComponentNameHandler;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeLogicalNameHandler
extends AbstractMergeComponentNameHandler {
    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof IJBEditor) {
            IJBEditor editor = (IJBEditor)activePart;
            if (editor.isDirty()) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_SAVE_EDITOR);
                return null;
            }
            Set<IComponentNamePO> compNames = this.getComponentNames(this.getSelection());
            IComponentNamePO selectedCompNamePo = this.openDialog(compNames);
            if (selectedCompNamePo == null) {
                return null;
            }
            if (editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                return null;
            }
            this.performOperation(editor, compNames, selectedCompNamePo);
        }
        return null;
    }

    private void performOperation(IJBEditor editor, Set<IComponentNamePO> compNames, IComponentNamePO selectedCompNamePo) {
        this.performOperation(compNames, selectedCompNamePo);
        editor.getEditorHelper().setDirty(true);
        NullProgressMonitor saveProgressMonitor = new NullProgressMonitor();
        editor.doSave((IProgressMonitor)saveProgressMonitor);
        if (!saveProgressMonitor.isCanceled()) {
            this.fireChangeEvents(compNames);
        }
    }
}

