/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.properties;

import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AbstractProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private EditSupport m_editSupport = null;
    private IProjectPO m_workProject = null;

    public AbstractProjectPropertyPage(EditSupport es) {
        this.m_editSupport = es;
    }

    public AbstractProjectPropertyPage() {
    }

    public static EditSupport createEditSupport() throws PMException {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        EditSupport editSupport = new EditSupport((IPersistentObject)project.getProjectProperties(), null);
        editSupport.lockWorkVersion();
        ProjectNameBP.getInstance().clearCache();
        return editSupport;
    }

    public IProjectPO getProject() {
        if (this.m_workProject == null) {
            try {
                this.m_workProject = this.getEditSupport().getWorkProject();
            }
            catch (PMException e) {
                throw new JBFatalAbortException(Messages.CantLoadProjectInEditSession, (Throwable)e, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        return this.m_workProject;
    }

    protected EditSupport getEditSupport() {
        return this.m_editSupport;
    }

    public void setEditSupport(EditSupport es) {
        this.m_editSupport = es;
    }

    public boolean performCancel() {
        Plugin.stopLongRunning();
        return super.performCancel();
    }
}

