/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.properties.AbstractProjectPropertyPage;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.ListElementChooserComposite;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProjectLanguagePropertyPage
extends AbstractProjectPropertyPage {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private org.eclipse.swt.widgets.List m_availableLangList;
    private org.eclipse.swt.widgets.List m_projectLangList;
    private Button m_downButton;
    private Button m_upButton;
    private DirectCombo<Locale> m_defaultLangComboBox;
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private ListElementChooserComposite m_chooseLists;
    private Button m_allDownButton;
    private Button m_allUpButton;
    private String[] m_initialLanguages;

    public ProjectLanguagePropertyPage(EditSupport es) {
        super(es);
    }

    protected Control createContents(Composite parent) {
        ControlDecorator.decorateInfo((Control)this.createLabel(parent, Messages.ProjectSettingWizardPageSelectLanguagesOfTD), "GDControlDecorator.NewProjectProjectLanguage", false);
        Composite composite = this.createComposite(parent, 1, 4, 4, true, true);
        this.noDefaultAndApplyButton();
        Composite innerComposite = new Composite(composite, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        innerComposite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalSpan = 2;
        compositeData.horizontalAlignment = 4;
        compositeData.grabExcessHorizontalSpace = true;
        innerComposite.setLayoutData((Object)compositeData);
        this.createLanguageLists(innerComposite);
        this.getObjects();
        this.m_initialLanguages = this.m_projectLangList.getItems();
        this.separator(composite, 1);
        this.createLanguageCombo(this.createComposite(composite, 2, 4, 4, false, false));
        this.resizeLists();
        this.initFields();
        this.addListener();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.projectSettingsPageContextId");
        return composite;
    }

    private void createLanguageLists(Composite innerComposite) {
        Languages langUtil = Languages.getInstance();
        List<String> leftList = Utils.getAvailableLanguages();
        ArrayList<String> rightList = new ArrayList<String>();
        Iterator iter = this.getProject().getLangHelper().getLangListIterator();
        while (iter.hasNext()) {
            Locale l = (Locale)iter.next();
            if (langUtil.getDisplayString(l) == null) continue;
            rightList.add(langUtil.getDisplayString(l));
        }
        this.m_chooseLists = new ProjectLanguageChooserComposite(innerComposite, leftList, rightList);
    }

    private void resizeLists() {
        ((GridData)this.m_projectLangList.getLayoutData()).widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_projectLangList), (int)15);
        ((GridData)this.m_availableLangList.getLayoutData()).widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_projectLangList), (int)15);
    }

    private Composite createComposite(Composite parent, int numColumns, int horizontalAlignment, int verticalAlignment, boolean grabHorizontalSpace, boolean grabVerticalSpace) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, grabHorizontalSpace, grabVerticalSpace));
        return composite;
    }

    private void getObjects() {
        this.m_availableLangList = this.m_chooseLists.getListOne();
        this.m_projectLangList = this.m_chooseLists.getListTwo();
        this.m_upButton = this.m_chooseLists.getSelectionTwoToOneButton();
        this.m_downButton = this.m_chooseLists.getSelectionOneToTwoButton();
        this.m_allUpButton = this.m_chooseLists.getAllTwoToOneButton();
        this.m_allDownButton = this.m_chooseLists.getAllOneToTwoButton();
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    private void separator(Composite composite, int horSpan) {
        this.createLabel(composite, "");
        Label sep = new Label(composite, 258);
        GridData sepData = new GridData();
        sepData.horizontalAlignment = 4;
        sepData.horizontalSpan = horSpan;
        sep.setLayoutData((Object)sepData);
        this.createLabel(composite, "");
    }

    private void initFields() {
        if (this.getProject().getDefaultLanguage() != null && !"".equals(this.getProject().getDefaultLanguage())) {
            this.m_defaultLangComboBox.setSelectedObject((Object)this.getProject().getDefaultLanguage());
        }
    }

    private void createLanguageCombo(Composite parent) {
        Composite leftComposite = this.createComposite(parent, 1, 1, 0, false, false);
        Composite rightComposite = this.createComposite(parent, 1, 4, 4, true, true);
        this.createLabel(leftComposite, Messages.ProjectPropertyPageLanguageLabel);
        this.m_defaultLangComboBox = new DirectCombo(rightComposite, 8, new ArrayList(), new ArrayList(), false, true);
        GridData comboGridData = new GridData();
        comboGridData.grabExcessHorizontalSpace = true;
        comboGridData.horizontalAlignment = 4;
        LayoutUtil.addToolTipAndMaxWidth((GridData)comboGridData, this.m_defaultLangComboBox);
        this.m_defaultLangComboBox.setLayoutData((Object)comboGridData);
        this.fillDefaultLanguageComboBox();
    }

    private void fillDefaultLanguageComboBox() {
        Locale selected = (Locale)this.m_defaultLangComboBox.getSelectedObject();
        ArrayList<Locale> localeObjects = new ArrayList<Locale>();
        ArrayList<String> localeStrings = new ArrayList<String>();
        String[] stringArray = this.m_projectLangList.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            localeStrings.add(language);
            localeObjects.add(Languages.getInstance().getLocale(language));
            ++n2;
        }
        this.m_defaultLangComboBox.setItems(localeObjects, localeStrings);
        this.m_defaultLangComboBox.setSelectedObject((Object)selected);
    }

    void handleDownButtonEvent() {
        this.fillDefaultLanguageComboBox();
        this.enableLangCombo();
    }

    void handleAllDownButtonEvent() {
        this.fillDefaultLanguageComboBox();
        this.enableLangCombo();
    }

    boolean isLangUsedInAUT(String lang) {
        Set autSet = this.getProject().getAutMainList();
        for (IAUTMainPO aut : autSet) {
            List locList = aut.getLangHelper().getLanguageList();
            for (Locale loc : locList) {
                String displName = Languages.getInstance().getDisplayString(loc);
                if (!lang.equals(displName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isLangUsedInProject(String lang) {
        int j = 0;
        while (j < this.m_initialLanguages.length) {
            if (lang.equals(this.m_initialLanguages[j])) {
                return true;
            }
            ++j;
        }
        return false;
    }

    void enableLangCombo() {
        if (this.m_projectLangList.getItemCount() == 0 || this.m_defaultLangComboBox.getItemCount() == 0) {
            this.m_defaultLangComboBox.setEnabled(false);
            this.setErrorMessage(Messages.ProjectPropertyPageNoProjectLanguage);
            this.setValid(false);
        } else {
            if ("".equals(this.m_defaultLangComboBox.getText())) {
                this.setErrorMessage(Messages.ProjectPropertyPageNoProjectLanguage);
                this.setValid(false);
                this.m_defaultLangComboBox.setEnabled(true);
                return;
            }
            this.m_defaultLangComboBox.setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(Messages.PropertiesActionPage1, 0);
            this.setValid(true);
            this.getProject().setDefaultLanguage((Locale)this.m_defaultLangComboBox.getSelectedObject());
        }
    }

    public boolean performOk() {
        return true;
    }

    void updateLanguages() {
        this.getProject().setDefaultLanguage((Locale)this.m_defaultLangComboBox.getSelectedObject());
        this.getProject().getLangHelper().clearLangList();
        int i = 0;
        while (i < this.m_projectLangList.getItemCount()) {
            this.getProject().getLangHelper().addLanguageToList(Languages.getInstance().getLocale(this.m_projectLangList.getItem(i)));
            ++i;
        }
    }

    private void addListener() {
        this.m_projectLangList.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_availableLangList.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_upButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_downButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allUpButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allDownButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_defaultLangComboBox.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProjectLanguageChooserComposite
    extends ListElementChooserComposite {
        private ProjectLanguageChooserComposite(Composite innerComposite, List leftList, List<String> rightList) {
            super(innerComposite, Messages.ProjectPropertyPageUpperLabel, leftList, Messages.ProjectSettingWizardPageBottomLabel, rightList, 15, new Image[]{IconConstants.RIGHT_ARROW_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_IMAGE, IconConstants.LEFT_ARROW_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_IMAGE}, new Image[]{IconConstants.RIGHT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_DIS_IMAGE, IconConstants.LEFT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_DIS_IMAGE}, new String[]{Messages.ProjectPropertyPageDownToolTip, Messages.ProjectSettingWizardPageAllDownToolTip, Messages.ProjectPropertyPageUpToolTip, Messages.ProjectSettingWizardPageAllUpToolTip}, 1);
        }

        @Override
        protected void handleAllTwoToOneButtonEvent() {
            String[] selection = ProjectLanguagePropertyPage.this.m_chooseLists.getListTwo().getItems();
            int i = 0;
            while (i < selection.length) {
                if (ProjectLanguagePropertyPage.this.isLangUsedInAUT(selection[i])) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DELETE_PROJECT_LANG);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < selection.length) {
                if (ProjectLanguagePropertyPage.this.isLangUsedInProject(selection[i])) {
                    Dialog dialog = ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.Q_REMOVE_PROJECT_LANGUAGES);
                    if (dialog.getReturnCode() == 0) break;
                    return;
                }
                ++i;
            }
            ProjectLanguagePropertyPage.this.enableLangCombo();
            super.handleAllTwoToOneButtonEvent();
            ProjectLanguagePropertyPage.this.fillDefaultLanguageComboBox();
        }

        @Override
        protected void handleSelectionTwoToOneButtonEvent() {
            String[] selection = ProjectLanguagePropertyPage.this.m_chooseLists.getListTwo().getSelection();
            int i = 0;
            while (i < selection.length) {
                if (ProjectLanguagePropertyPage.this.isLangUsedInAUT(selection[i])) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DELETE_PROJECT_LANG);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < selection.length) {
                if (ProjectLanguagePropertyPage.this.isLangUsedInProject(selection[i])) {
                    Dialog dialog = ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.Q_REMOVE_PROJECT_LANGUAGES);
                    if (dialog.getReturnCode() == 0) break;
                    return;
                }
                ++i;
            }
            ProjectLanguagePropertyPage.this.enableLangCombo();
            super.handleSelectionTwoToOneButtonEvent();
            ProjectLanguagePropertyPage.this.fillDefaultLanguageComboBox();
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectLanguagePropertyPage.this.m_downButton)) {
                ProjectLanguagePropertyPage.this.handleDownButtonEvent();
                ProjectLanguagePropertyPage.this.updateLanguages();
                return;
            }
            if (o.equals(ProjectLanguagePropertyPage.this.m_upButton) || o.equals(ProjectLanguagePropertyPage.this.m_allUpButton)) {
                ProjectLanguagePropertyPage.this.updateLanguages();
                ProjectLanguagePropertyPage.this.enableLangCombo();
                return;
            }
            if (o.equals(ProjectLanguagePropertyPage.this.m_allDownButton)) {
                ProjectLanguagePropertyPage.this.handleAllDownButtonEvent();
                ProjectLanguagePropertyPage.this.updateLanguages();
                return;
            }
            if (o.equals(ProjectLanguagePropertyPage.this.m_defaultLangComboBox)) {
                ProjectLanguagePropertyPage.this.enableLangCombo();
                return;
            }
            if (o.equals(ProjectLanguagePropertyPage.this.m_availableLangList)) {
                ProjectLanguagePropertyPage.this.enableLangCombo();
                return;
            }
            if (o.equals(ProjectLanguagePropertyPage.this.m_projectLangList)) {
                ProjectLanguagePropertyPage.this.enableLangCombo();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(ProjectLanguagePropertyPage.this.m_availableLangList)) {
                ProjectLanguagePropertyPage.this.handleDownButtonEvent();
                ProjectLanguagePropertyPage.this.updateLanguages();
                return;
            }
            if (o.equals(ProjectLanguagePropertyPage.this.m_projectLangList)) {
                ProjectLanguagePropertyPage.this.updateLanguages();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "."));
        }
    }
}

