/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.communication.ServerConnection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ConnectServerBP;
import org.eclipse.jubula.client.ui.rcp.dialogs.RemoteFileBrowserDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.utils.RemoteFileStore;
import org.eclipse.jubula.client.ui.rcp.utils.ServerManager;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutConfigComponent
extends ScrolledComposite {
    public static final GridData BUTTON_LAYOUT = new GridData();
    public static final int NUM_COLUMNS = 3;
    private Mode m_mode;
    private Map<Button, Mode> m_buttonToModeMap = new HashMap<Button, Mode>();
    private String m_autName;
    private boolean m_nameModified;
    private Map<String, String> m_autConfig;
    private ServerManager m_listOfServers = ServerManager.getInstance();
    private List<DialogStatusParameter> m_paramList = new ArrayList<DialogStatusParameter>();
    private WidgetSelectionListener m_selectionListener;
    private WidgetModifyListener m_modifyListener;
    private Composite m_basicAreaComposite;
    private Composite m_advancedAreaComposite;
    private Composite m_expertAreaComposite;
    private Composite m_monitoringAreaComposite;
    private Composite m_contentComposite;
    private Text m_autConfigNameTextField;
    private Combo m_serverCombo;
    private Button m_addServerButton;
    private Text m_autWorkingDirectoryTextField;
    private Button m_autWorkingDirectoryButton;
    private Text m_autIdTextField;
    private IValidator m_autIdValidator;
    private Button m_basicModeButton;
    private Button m_advancedModeButton;
    private Button m_expertModeButton;
    private boolean m_isMultiMode;
    private boolean m_isinitialized = false;

    static {
        AutConfigComponent.BUTTON_LAYOUT.horizontalAlignment = 4;
        AutConfigComponent.BUTTON_LAYOUT.grabExcessHorizontalSpace = true;
    }

    public AutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName, boolean isMultiMode) {
        super(parent, style);
        this.m_autConfig = autConfig;
        this.m_autName = autName;
        this.m_nameModified = !this.isDataNew(autConfig) && autConfig.get("CONFIG_NAME").equals(NLS.bind((String)Messages.AUTConfigComponentDefaultAUTConfigName, (Object[])new String[]{autName, autConfig.get("SERVER")}));
        this.m_isMultiMode = isMultiMode;
        if (this.m_isMultiMode) {
            IPreferenceStore prefStore = PlatformUI.getPreferenceStore();
            String prefMode = prefStore.getString("AUT_CONFIG_DIALOG_MODE");
            this.m_mode = prefMode != null && prefMode.length() != 0 ? Mode.valueOf(prefMode) : Mode.BASIC;
        }
        this.createGUI();
        this.populateGUI(autConfig);
        this.init();
        if (this.m_isMultiMode) {
            this.setCurrentMode(this.m_mode);
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!AutConfigComponent.this.isDisposed()) {
                        AutConfigComponent.this.resize();
                        AutConfigComponent.this.getShell().pack(true);
                    }
                }
            });
        } else {
            this.setCompositeVisible(this.m_basicAreaComposite, true);
            this.resize();
        }
        this.m_isinitialized = true;
    }

    protected boolean isJavaAut() {
        return false;
    }

    protected Text getAutWorkingDirField() {
        return this.m_autWorkingDirectoryTextField;
    }

    public Composite getMonitoringAreaComposite() {
        return this.m_monitoringAreaComposite;
    }

    private void populateGUI(Map<String, String> data) {
        this.populateBasicArea(data);
        this.populateAdvancedArea(data);
        this.populateExpertArea(data);
        this.populateMonitoringArea(data);
    }

    public void setVisible(boolean visible) {
        if ("".equals(this.m_autConfigNameTextField.getText())) {
            this.m_autConfigNameTextField.setFocus();
            this.m_autConfigNameTextField.setText(NLS.bind((String)Messages.AUTConfigComponentDefaultAUTConfigName, (Object[])new String[]{this.m_autName, this.m_serverCombo.getText()}));
            this.m_autConfigNameTextField.setSelection(0, this.m_autConfigNameTextField.getText().length());
        }
    }

    private Map<String, String> getAutConfig() {
        return this.m_autConfig;
    }

    private void createGUI() {
        this.m_contentComposite = new Composite((Composite)this, 0);
        this.initGuiLayout(this.m_contentComposite);
        this.createHeader(this.m_contentComposite);
        if (this.m_isMultiMode) {
            this.createModeButtons(this.m_contentComposite);
        }
        this.m_basicAreaComposite = new Composite(this.m_contentComposite, 0);
        this.m_advancedAreaComposite = new Composite(this.m_contentComposite, 0);
        this.m_expertAreaComposite = new Composite(this.m_contentComposite, 0);
        this.m_monitoringAreaComposite = new Composite(this.m_contentComposite, 0);
        this.createLayout(this.m_basicAreaComposite);
        this.createLayout(this.m_advancedAreaComposite);
        this.createLayout(this.m_expertAreaComposite);
        this.createLayout(this.m_monitoringAreaComposite);
        this.createBasicArea(this.m_basicAreaComposite);
        this.createAdvancedArea(this.m_advancedAreaComposite);
        this.createExpertArea(this.m_expertAreaComposite);
        this.createMonitoringArea(this.m_monitoringAreaComposite);
        this.setContent((Control)this.m_contentComposite);
    }

    private void createLayout(Composite areaComposite) {
        areaComposite.setLayout((Layout)AutConfigComponent.createDefaultGridLayout(3));
        GridData gridData = new GridData(1);
        gridData.horizontalSpan = 3;
        areaComposite.setLayoutData((Object)gridData);
    }

    public static GridLayout createDefaultGridLayout(int numColumns) {
        GridLayout result = new GridLayout();
        result.numColumns = numColumns;
        result.horizontalSpacing = 5;
        result.verticalSpacing = 5;
        result.marginWidth = 0;
        result.marginHeight = 0;
        return result;
    }

    protected abstract void createHeader(Composite var1);

    protected abstract void populateExpertArea(Map<String, String> var1);

    protected void populateMonitoringArea(Map<String, String> data) {
    }

    protected abstract void populateAdvancedArea(Map<String, String> var1);

    protected void populateBasicArea(Map<String, String> data) {
        this.fillServerCombo();
        if (!this.isDataNew(data)) {
            this.m_serverCombo.select(this.m_serverCombo.indexOf(StringUtils.defaultString((String)data.get("SERVER"))));
            this.m_autConfigNameTextField.setText(StringUtils.defaultString((String)data.get("CONFIG_NAME"), (String)NLS.bind((String)Messages.AUTConfigComponentDefaultAUTConfigName, (Object[])new String[]{this.m_autName, this.m_serverCombo.getText()})));
            this.m_autIdTextField.setText(StringUtils.defaultString((String)data.get("AUT_ID")));
            this.m_autWorkingDirectoryTextField.setText(StringUtils.defaultString((String)data.get("WORKING_DIR")));
        } else {
            this.m_serverCombo.select(this.m_serverCombo.indexOf(StringUtils.defaultString((String)"localhost")));
            this.m_autConfigNameTextField.setText(NLS.bind((String)Messages.AUTConfigComponentDefaultAUTConfigName, (Object[])new String[]{this.m_autName, this.m_serverCombo.getText()}));
        }
    }

    protected boolean isDataNew(Map<String, String> data) {
        return data == null || data.isEmpty();
    }

    protected void createBasicArea(Composite basicAreaComposite) {
        this.initGUIConfigAndServer(basicAreaComposite);
    }

    protected void createAdvancedArea(Composite advancedAreaComposite) {
        this.setCompositeVisible(advancedAreaComposite, false);
    }

    protected void createExpertArea(Composite expertAreaComposite) {
        this.setCompositeVisible(expertAreaComposite, false);
    }

    protected void createMonitoringArea(Composite monitoringComposite) {
        this.setCompositeVisible(monitoringComposite, true);
    }

    private void initGUIConfigAndServer(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.configName");
        this.m_autConfigNameTextField = UIComponentHelper.createTextField((Composite)parent, (int)2);
        this.initGuiServerChooser(parent);
        ControlDecorator.decorateInfo((Control)UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.autId"), "AUTConfigComponent.autId.helpText", false);
        this.m_autIdTextField = UIComponentHelper.createTextField((Composite)parent, (int)2);
        UIComponentHelper.createSeparator((Composite)parent, (int)3);
        if (!this.isJavaAut()) {
            this.createAutDirectoryEditor(parent);
        }
    }

    protected void createAutDirectoryEditor(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.workDir");
        this.m_autWorkingDirectoryTextField = UIComponentHelper.createTextField((Composite)parent, (int)1);
        this.m_autWorkingDirectoryButton = new Button(UIComponentHelper.createLayoutComposite((Composite)parent), 8);
        this.m_autWorkingDirectoryButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_autWorkingDirectoryButton.setLayoutData((Object)BUTTON_LAYOUT);
    }

    private void initGuiServerChooser(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.server");
        this.m_serverCombo = new Combo(parent, 8);
        GridData comboGrid = new GridData(4, 2, true, false, 1, 1);
        LayoutUtil.addToolTipAndMaxWidth((GridData)comboGrid, (Control)this.m_serverCombo);
        this.m_serverCombo.setLayoutData((Object)comboGrid);
        this.m_addServerButton = new Button(UIComponentHelper.createLayoutComposite((Composite)parent), 8);
        this.m_addServerButton.setText(Messages.AUTConfigComponentAddServer);
        this.m_addServerButton.setLayoutData((Object)BUTTON_LAYOUT);
    }

    private void setCurrentMode(Mode mode) {
        this.m_basicModeButton.setSelection(false);
        this.m_advancedModeButton.setSelection(false);
        this.m_expertModeButton.setSelection(false);
        for (Button key : this.m_buttonToModeMap.keySet()) {
            if (this.m_buttonToModeMap.get(key) != mode) continue;
            key.setSelection(true);
            break;
        }
        IPreferenceStore prefStore = PlatformUI.getPreferenceStore();
        if (mode == Mode.BASIC) {
            prefStore.setValue("AUT_CONFIG_DIALOG_MODE", Mode.BASIC.name());
            this.setCompositeVisible(this.m_advancedAreaComposite, false);
            this.setCompositeVisible(this.m_expertAreaComposite, false);
            this.setCompositeVisible(this.m_monitoringAreaComposite, false);
        } else if (mode == Mode.ADVANCED) {
            prefStore.setValue("AUT_CONFIG_DIALOG_MODE", Mode.ADVANCED.name());
            this.setCompositeVisible(this.m_advancedAreaComposite, true);
            this.setCompositeVisible(this.m_expertAreaComposite, false);
            this.setCompositeVisible(this.m_monitoringAreaComposite, false);
        } else if (mode == Mode.EXPERT) {
            prefStore.setValue("AUT_CONFIG_DIALOG_MODE", Mode.EXPERT.name());
            this.setCompositeVisible(this.m_advancedAreaComposite, true);
            this.setCompositeVisible(this.m_expertAreaComposite, true);
            this.setCompositeVisible(this.m_monitoringAreaComposite, true);
        }
        this.resize();
        this.getShell().pack(true);
    }

    protected boolean isBasicMode() {
        IPreferenceStore prefStore = PlatformUI.getPreferenceStore();
        String mode = prefStore.getString("AUT_CONFIG_DIALOG_MODE");
        return mode.equals(Mode.BASIC.name());
    }

    protected void resize() {
        Point newSize = this.m_contentComposite.computeSize(-1, -1);
        this.m_contentComposite.setSize(newSize);
        this.m_contentComposite.layout();
    }

    private void setCompositeVisible(Composite composite, boolean visible) {
        composite.setVisible(visible);
        ((GridData)composite.getLayoutData()).exclude = !visible;
    }

    private void initGuiLayout(Composite comp) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 3;
        compositeLayout.horizontalSpacing = 10;
        compositeLayout.verticalSpacing = 10;
        compositeLayout.marginHeight = 10;
        compositeLayout.marginWidth = 10;
        comp.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(4, 4, true, true);
        compositeData.grabExcessHorizontalSpace = false;
        compositeData.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)compositeData);
    }

    private void fillServerCombo() {
        boolean checkListeners;
        boolean bl = checkListeners = this.m_selectionListener != null;
        if (checkListeners) {
            this.deinstallListeners();
        }
        this.m_serverCombo.removeAll();
        String currentlySelectedServer = this.getConfigValue("SERVER");
        if (currentlySelectedServer != null && currentlySelectedServer.trim().length() != 0 && !this.m_listOfServers.getServerNames().contains(currentlySelectedServer)) {
            int defaultServerPort = 60000;
            this.m_listOfServers.addServer(new ServerManager.Server(currentlySelectedServer, defaultServerPort));
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_SERVER_NAME_ADDED, null, (String[])new String[]{String.valueOf(Messages.ServerName) + ":" + " " + currentlySelectedServer + "\n" + Messages.ServerPortDefault + defaultServerPort});
        }
        for (String serverName : this.m_listOfServers.getServerNames()) {
            this.m_serverCombo.add(serverName);
        }
        if (checkListeners) {
            this.installListeners();
        }
    }

    protected void createModeButtons(Composite parent) {
        Composite modeButtons = UIComponentHelper.createLayoutComposite((Composite)parent, (int)3);
        GridData modeButtonsData = new GridData(1);
        modeButtonsData.horizontalSpan = 3;
        modeButtons.setLayoutData((Object)modeButtonsData);
        this.m_basicModeButton = new Button(modeButtons, 2);
        this.m_basicModeButton.setText(Messages.AUTConfigComponentShowBasic);
        this.m_basicModeButton.setSelection(true);
        this.m_buttonToModeMap.put(this.m_basicModeButton, Mode.BASIC);
        this.m_advancedModeButton = new Button(modeButtons, 2);
        this.m_advancedModeButton.setText(Messages.AUTConfigComponentShowAdvanced);
        this.m_buttonToModeMap.put(this.m_advancedModeButton, Mode.ADVANCED);
        this.m_expertModeButton = new Button(modeButtons, 2);
        this.m_expertModeButton.setText(Messages.AUTConfigComponentShowExpert);
        this.m_buttonToModeMap.put(this.m_expertModeButton, Mode.EXPERT);
    }

    protected void installListeners() {
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        WidgetModifyListener modifyListener = this.getModifyListener();
        if (this.m_isMultiMode) {
            this.m_basicModeButton.addSelectionListener((SelectionListener)selectionListener);
            this.m_advancedModeButton.addSelectionListener((SelectionListener)selectionListener);
            this.m_expertModeButton.addSelectionListener((SelectionListener)selectionListener);
        }
        this.m_addServerButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_autConfigNameTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_autIdTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_autWorkingDirectoryButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_autWorkingDirectoryTextField.addModifyListener((ModifyListener)modifyListener);
    }

    protected void deinstallListeners() {
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        WidgetModifyListener modifyListener = this.getModifyListener();
        if (this.m_isMultiMode) {
            this.m_basicModeButton.removeSelectionListener((SelectionListener)selectionListener);
            this.m_advancedModeButton.removeSelectionListener((SelectionListener)selectionListener);
            this.m_expertModeButton.removeSelectionListener((SelectionListener)selectionListener);
        }
        this.m_addServerButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_autConfigNameTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_autIdTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_autWorkingDirectoryButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_autWorkingDirectoryTextField.removeModifyListener((ModifyListener)modifyListener);
    }

    protected boolean putConfigValue(String key, String value) {
        boolean areBothEmpty;
        String previousValue = StringUtils.defaultString((String)this.getAutConfig().put(key, value));
        boolean wasEmpty = previousValue.length() == 0;
        boolean isEmpty = StringUtils.defaultString((String)value).length() == 0;
        boolean bl = areBothEmpty = wasEmpty && isEmpty;
        if (isEmpty) {
            this.getAutConfig().remove(key);
        }
        return !this.m_isinitialized && !areBothEmpty || !value.equals(previousValue);
    }

    protected String getConfigValue(String key) {
        String value = this.getAutConfig().get(key);
        return value != null ? value : "";
    }

    protected void setConfig(Map<String, String> newConfig) {
        Utils.makeAutConfigCopy(newConfig, this.getAutConfig());
    }

    protected boolean checkLocalhostServer() {
        boolean enable = this.isLocalhost();
        this.m_autWorkingDirectoryButton.setEnabled(enable || this.isRemoteRequest());
        return enable;
    }

    private boolean isLocalhost() {
        boolean enable;
        try {
            String serverComboText = this.getServerCombo().getText();
            InetAddress localHost = InetAddress.getLocalHost();
            String canonicalHostName = localHost.getCanonicalHostName();
            enable = "localhost".equals(serverComboText.toLowerCase()) || "127.0.0.1".equals(serverComboText) || localHost.getHostName().equals(serverComboText) || localHost.getHostAddress().equals(serverComboText) || canonicalHostName != null && canonicalHostName.equals(serverComboText);
        }
        catch (UnknownHostException unknownHostException) {
            enable = false;
        }
        return enable;
    }

    public void handleAddServerButtonEvent() {
        this.openServerPrefPage();
    }

    public DialogStatusParameter modifyAutConfigFieldAction() {
        this.m_nameModified = !this.m_autConfigNameTextField.getText().equals(NLS.bind((String)Messages.AUTConfigComponentDefaultAUTConfigName, (Object[])new String[]{this.m_autName, this.m_serverCombo.getText()}));
        DialogStatusParameter error = null;
        this.putConfigValue("CONFIG_NAME", this.m_autConfigNameTextField.getText());
        if (!this.isValid((Widget)this.m_autConfigNameTextField, false)) {
            error = this.m_autConfigNameTextField.getText().length() == 0 ? this.createErrorStatus(Messages.AUTConfigComponentEmptyAUTConfigName) : this.createErrorStatus(Messages.AUTConfigComponentWrongAUTConfigName);
        }
        return error;
    }

    public DialogStatusParameter modifyAutIdFieldAction() {
        IStatus validationStatus;
        DialogStatusParameter error = null;
        String newAutIdValue = this.m_autIdTextField.getText();
        if (this.m_autIdValidator != null && !(validationStatus = this.m_autIdValidator.validate((Object)newAutIdValue)).isOK()) {
            error = validationStatus.getSeverity() == 4 ? this.createErrorStatus(validationStatus.getMessage()) : this.createWarningStatus(validationStatus.getMessage());
        }
        this.putConfigValue("AUT_ID", newAutIdValue);
        return error;
    }

    protected void openServerPrefPage() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.jubula.client.ui.rcp.preferences.AutAgentPrefPage", null, null);
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        this.m_listOfServers = ServerManager.getInstance();
        String oldServer = this.m_serverCombo.getText();
        this.fillServerCombo();
        this.m_serverCombo.setText(oldServer);
    }

    protected Combo getServerCombo() {
        return this.m_serverCombo;
    }

    protected ServerManager getServerList() {
        return this.m_listOfServers;
    }

    protected boolean isValid(Widget modifiedWidget, boolean emptyAllowed) {
        if (modifiedWidget instanceof DirectCombo) {
            DirectCombo combo = (DirectCombo)modifiedWidget;
            int textLength = combo.getText().length();
            String text = combo.getText();
            return this.checkTextInput(emptyAllowed, textLength, text);
        }
        if (modifiedWidget instanceof Text) {
            Text textField = (Text)modifiedWidget;
            int textLength = textField.getText().length();
            String text = textField.getText();
            return this.checkTextInput(emptyAllowed, textLength, text);
        }
        return true;
    }

    protected boolean isRemoteRequest() {
        boolean enable;
        ServerManager.Server currentServer;
        block5: {
            block4: {
                currentServer = ConnectServerBP.getInstance().getCurrentServer();
                if (currentServer != null) break block4;
                return false;
            }
            if (!this.isLocalhost()) break block5;
            return false;
        }
        try {
            String serverName = this.getServerCombo().getText().toLowerCase();
            InetAddress serverAddress = InetAddress.getByName(serverName);
            String canonicalServerName = serverAddress.getCanonicalHostName().toLowerCase();
            String currentServerName = currentServer.getName().toLowerCase();
            InetAddress currentServerAddress = InetAddress.getByName(currentServerName);
            String canonicalCurrentServerName = currentServerAddress.getCanonicalHostName().toLowerCase();
            enable = currentServerName.equals(serverName) || currentServerAddress.equals(serverAddress) || canonicalCurrentServerName.equals(canonicalServerName);
        }
        catch (UnknownHostException unknownHostException) {
            enable = false;
        }
        return enable;
    }

    private boolean checkTextInput(boolean emptyAllowed, int textLength, String text) {
        return (textLength != 0 || emptyAllowed) && !text.startsWith(" ") && !text.endsWith(" ");
    }

    private void fireError() {
        DataEventDispatcher.getInstance().getDialogStatusListenerMgr().fireNotification(this.m_paramList);
    }

    protected DialogStatusParameter createWarningStatus(String message) {
        DialogStatusParameter param = new DialogStatusParameter();
        param.setButtonState(true);
        param.setStatusType(2);
        param.setMessage(message);
        return param;
    }

    protected DialogStatusParameter createErrorStatus(String message) {
        DialogStatusParameter param = new DialogStatusParameter();
        param.setButtonState(false);
        param.setStatusType(3);
        param.setMessage(message);
        return param;
    }

    private void setIsValid(boolean noEntries) {
        if (noEntries) {
            DialogStatusParameter param = new DialogStatusParameter();
            param.setButtonState(true);
            param.setStatusType(0);
            param.setMessage(Messages.ProjectWizardAUTData);
            this.m_paramList.clear();
            this.m_paramList.add(param);
        }
        DataEventDispatcher.getInstance().getDialogStatusListenerMgr().fireNotification(this.m_paramList);
    }

    protected boolean isConfigNew() {
        return this.m_autConfig == null || this.m_autConfig.isEmpty();
    }

    private void selectModeButton(Button button) {
        this.setCurrentMode(this.m_buttonToModeMap.get(button));
    }

    protected void init() {
        this.initState();
        this.installListeners();
        this.checkAll(this.m_paramList);
    }

    public final void checkAll() {
        this.checkAll(this.m_paramList);
        if (this.m_paramList.isEmpty()) {
            this.setIsValid(true);
        } else {
            boolean isValid = true;
            for (DialogStatusParameter entry : this.m_paramList) {
                if (entry.getStatusType() != 3) continue;
                isValid = false;
                break;
            }
            if (isValid) {
                this.setIsValid(false);
            } else {
                this.fireError();
            }
        }
        this.m_paramList.clear();
    }

    protected void checkAll(List<DialogStatusParameter> paramList) {
        this.addError(paramList, this.modifyAutConfigFieldAction());
        this.addError(paramList, this.modifyAutIdFieldAction());
        this.addError(paramList, this.modifyServerComboAction());
        this.addError(paramList, this.modifyWorkingDirFieldAction());
    }

    protected void addError(List<DialogStatusParameter> paramList, DialogStatusParameter error) {
        if (error != null) {
            paramList.add(error);
        }
    }

    protected void addError(DialogStatusParameter error) {
        if (error != null) {
            this.m_paramList.add(error);
        }
    }

    protected void initState() {
        this.m_autConfigNameTextField.setEnabled(true);
        this.m_serverCombo.setEnabled(true);
    }

    public DialogStatusParameter modifyServerComboAction() {
        boolean isValid = false;
        if (this.m_serverCombo.getSelectionIndex() != -1) {
            this.putConfigValue("SERVER", this.m_serverCombo.getItem(this.m_serverCombo.getSelectionIndex()));
            isValid = true;
        }
        if (isValid) {
            if (!this.m_nameModified) {
                boolean checkListeners;
                boolean bl = checkListeners = this.m_selectionListener != null;
                if (checkListeners) {
                    this.deinstallListeners();
                }
                this.m_autConfigNameTextField.setText(NLS.bind((String)Messages.AUTConfigComponentDefaultAUTConfigName, (Object[])new String[]{this.m_autName, this.m_serverCombo.getText()}));
                if (checkListeners) {
                    this.installListeners();
                }
            }
            return null;
        }
        return this.createErrorStatus(Messages.AUTConfigComponentNoServer);
    }

    private WidgetSelectionListener getSelectionListener() {
        if (this.m_selectionListener == null) {
            this.m_selectionListener = new WidgetSelectionListener();
        }
        return this.m_selectionListener;
    }

    private WidgetModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new WidgetModifyListener();
        }
        return this.m_modifyListener;
    }

    protected Text getAutConfigNameTextField() {
        return this.m_autConfigNameTextField;
    }

    public DialogStatusParameter modifyWorkingDirFieldAction() {
        boolean isEmpty;
        DialogStatusParameter error = null;
        boolean bl = isEmpty = this.m_autWorkingDirectoryTextField.getText().length() <= 0;
        if (this.isValid((Widget)this.m_autWorkingDirectoryTextField, true) && !isEmpty) {
            if (this.checkLocalhostServer()) {
                File dir = new File(this.m_autWorkingDirectoryTextField.getText());
                if (!dir.isAbsolute()) {
                    dir = new File("../server/" + this.m_autWorkingDirectoryTextField.getText());
                }
                if (!dir.isDirectory()) {
                    try {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentNoDir, (Object)dir.getCanonicalPath()));
                    }
                    catch (IOException iOException) {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)this.m_autWorkingDirectoryTextField.getText()));
                    }
                }
            }
        } else if (!isEmpty) {
            error = this.createErrorStatus(Messages.AUTConfigComponentWrongWorkDir);
        }
        this.putConfigValue("WORKING_DIR", this.m_autWorkingDirectoryTextField.getText());
        return error;
    }

    protected Text getWorkingDirTextField() {
        return this.m_autWorkingDirectoryTextField;
    }

    public void handleWorkDirButtonEvent(DirectoryDialog directoryDialog) {
        directoryDialog.setMessage(Messages.AUTConfigComponentSelectWorkDir);
        File path = new File(this.m_autWorkingDirectoryTextField.getText());
        String filterPath = Utils.getLastDirPath();
        if (path.exists()) {
            try {
                filterPath = path.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        directoryDialog.setFilterPath(filterPath);
        String directory = directoryDialog.open();
        if (directory != null) {
            this.m_autWorkingDirectoryTextField.setText(directory);
            Utils.storeLastDirPath(directoryDialog.getFilterPath());
            this.putConfigValue("WORKING_DIR", this.m_autWorkingDirectoryTextField.getText());
        }
    }

    protected boolean remoteBrowse(boolean folderSelection, String configVarKey, Text textfield, String title) {
        boolean valueChanged = false;
        RemoteFileBrowserDialog directoryDialog = new RemoteFileBrowserDialog(this.getShell(), false, folderSelection ? 2 : 1);
        try {
            RemoteFileStore resDir;
            String oldPath = this.getConfigValue(configVarKey);
            if (oldPath == null || oldPath.length() == 0) {
                oldPath = ".";
            }
            RemoteFileStore baseRemoteFS = new RemoteFileStore(ServerConnection.getInstance().getCommunicator(), ".", folderSelection);
            StringBuilder modPath = new StringBuilder(oldPath);
            baseRemoteFS = this.handleOldPath(baseRemoteFS, modPath);
            directoryDialog.setInput((Object)baseRemoteFS);
            directoryDialog.setInitialSelection((Object)new RemoteFileStore(ServerConnection.getInstance().getCommunicator(), oldPath.toString(), folderSelection));
            directoryDialog.setFSRoots(baseRemoteFS.getRootFSs());
            directoryDialog.setTitle(title);
            directoryDialog.setMessage(Messages.AUTConfigComponentSelectEntries);
            if (directoryDialog.open() == 0 && (resDir = (RemoteFileStore)((Object)directoryDialog.getFirstResult())) != null) {
                String path = resDir.getPath();
                textfield.setText(path);
                this.putConfigValue(configVarKey, path);
                valueChanged = true;
            }
        }
        catch (ConnectionException connectionException) {
            ErrorDialog.openError((Shell)Plugin.getShell(), (String)I18n.getString((String)"AutConfigComponent.ERROR_TITLE"), null, (IStatus)new Status(2, "org.eclipse.jubula.client.ui.rcp", I18n.getString((String)"AutConfigComponent.ERROR_COMM")));
        }
        return valueChanged;
    }

    private RemoteFileStore handleOldPath(RemoteFileStore remoteFS, StringBuilder path) {
        for (String root : remoteFS.getRootFSs()) {
            if (!path.toString().startsWith(root)) continue;
            path.delete(0, root.length());
            return new RemoteFileStore(remoteFS.getCommunicator(), root, remoteFS.fetchInfo().isDirectory());
        }
        return remoteFS;
    }

    public void setAutIdValidator(IValidator validator) {
        this.m_autIdValidator = validator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        BASIC,
        ADVANCED,
        EXPERT;

    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            boolean checked = false;
            if (source.equals(AutConfigComponent.this.m_autConfigNameTextField)) {
                checked = true;
            } else if (source.equals(AutConfigComponent.this.m_autIdTextField)) {
                checked = true;
            } else if (source.equals(AutConfigComponent.this.m_autWorkingDirectoryTextField)) {
                checked = true;
            }
            if (checked) {
                AutConfigComponent.this.checkAll();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "."));
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source.equals(AutConfigComponent.this.m_addServerButton)) {
                AutConfigComponent.this.handleAddServerButtonEvent();
                return;
            }
            if (source.equals(AutConfigComponent.this.m_basicModeButton) || source.equals(AutConfigComponent.this.m_advancedModeButton) || source.equals(AutConfigComponent.this.m_expertModeButton)) {
                AutConfigComponent.this.selectModeButton((Button)source);
                return;
            }
            if (source.equals(AutConfigComponent.this.m_autWorkingDirectoryButton)) {
                if (AutConfigComponent.this.isRemoteRequest()) {
                    AutConfigComponent.this.remoteBrowse(true, "WORKING_DIR", AutConfigComponent.this.m_autWorkingDirectoryTextField, Messages.AUTConfigComponentSelectWorkDir);
                } else {
                    DirectoryDialog directoryDialog = new DirectoryDialog(Plugin.getShell(), 81920);
                    AutConfigComponent.this.handleWorkDirButtonEvent(directoryDialog);
                }
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "(" + source + ")" + "."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

