/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.LogManager;
import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.communication.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.message.AUTServerStateMessage;
import org.eclipse.jubula.communication.message.AUTStartMessage;
import org.eclipse.jubula.communication.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.commands.AUTStartCommand;
import org.eclipse.jubula.rc.common.commands.ChangeAUTModeCommand;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.common.listener.IAutListenerAppender;
import org.eclipse.jubula.rc.common.registration.AgentRegisterAut;
import org.eclipse.jubula.rc.common.registration.IRegisterAut;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.exception.JBVersionException;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AUTServer {
    private static Logger log;
    private static AUTServer instance;
    private static String autServerName;
    private Communicator m_communicator;
    private Communicator m_serverCommunicator;
    private ICommunicationErrorListener m_communicationListener;
    private ICommunicationErrorListener m_serverCommunicationListener;
    private String m_autMainClassName;
    private Class m_autMainClass;
    private Method m_autMainMethod;
    private Thread m_autThread;
    private String[] m_autArgs;
    private int m_mode = 1;
    private boolean m_isAutRunning = false;
    private boolean m_isObservingDialogOpen = false;
    private long m_observTimestamp = 0L;
    private AUTEventListener m_mappingListener;
    private AUTEventListener m_recordListener;
    private AUTEventListener m_checkListener;
    private boolean m_isRcpAccessible;
    private boolean m_isAgentSet = false;
    private List m_inspectorListenerAppenders = new ArrayList();
    private String m_autAgentHost;
    private String m_autAgentPort;
    private String m_autName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.AUTServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        instance = null;
    }

    protected AUTServer(AUTEventListener mappingListener, AUTEventListener recordListener, AUTEventListener checkListener) {
        this.m_communicationListener = new ClientCommunicationListener();
        this.m_serverCommunicationListener = new AgentCommunicationListener();
        this.m_mappingListener = mappingListener;
        this.m_recordListener = recordListener;
        this.m_checkListener = checkListener;
    }

    protected void setArgs(String[] args) {
        this.m_autMainClassName = args[1];
        this.m_autAgentHost = args[4];
        this.m_autAgentPort = args[5];
        this.m_autName = args[6];
        int numberAutArgs = args.length - 8;
        this.m_autArgs = new String[numberAutArgs];
        int i = 0;
        while (i < numberAutArgs) {
            this.m_autArgs[i] = args[8 + i];
            ++i;
        }
        if (args.length == 8 && args[7].equals("true")) {
            this.m_isAgentSet = true;
        }
    }

    public String[] getAutArgs() {
        return this.m_autArgs;
    }

    public String getAutMainClassName() {
        return this.m_autMainClassName;
    }

    public Class getAutMainClass() {
        return this.m_autMainClass;
    }

    public Method getAutMainMethod() {
        return this.m_autMainMethod;
    }

    public synchronized Communicator getCommunicator() {
        return this.m_communicator;
    }

    public synchronized Communicator getServerCommunicator() {
        return this.m_serverCommunicator;
    }

    public static AUTServer getInstance() {
        if (instance == null) {
            try {
                instance = (AUTServer)Class.forName(autServerName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                log.error("creating an AUTServer sharedInstance for " + autServerName + "failed:" + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                log.error("creating an AUTServer sharedInstance for " + autServerName + "failed:" + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                log.error("creating an AUTServer sharedInstance for " + autServerName + "failed:" + iae.getMessage());
            }
            AdapterFactoryRegistry.initRegistration();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        block19: {
            InputStream logPropertiesStream = null;
            try {
                block18: {
                    try {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.AUTServer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((logPropertiesStream = clazz.getClassLoader().getResourceAsStream("resources/logging.properties")) != null) {
                            LogManager.getLogManager().readConfiguration(logPropertiesStream);
                            break block18;
                        }
                        System.err.println("RC logging.properties not found.");
                    }
                    catch (SecurityException e) {
                        System.err.println("RC logging.properties not loaded: " + e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        System.err.println("RC logging.properties not loaded: " + e.getLocalizedMessage());
                    }
                }
                Object var3_7 = null;
                if (logPropertiesStream == null) break block19;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                if (logPropertiesStream == null) throw throwable;
                try {
                    logPropertiesStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            logPropertiesStream.close();
        }
        if (args.length < 8) {
            log.error("wrong number of arguments: must be at least " + String.valueOf(8) + ", but were " + Arrays.asList(args).toString());
            System.exit(2);
        }
        if (log.isDebugEnabled()) {
            StringBuffer logMessage = new StringBuffer("Arguments to AUTServer\n");
            int i = 0;
            while (i < args.length) {
                logMessage.append(String.valueOf(i));
                logMessage.append(String.valueOf(args[i]) + "\n");
                ++i;
            }
            log.debug(logMessage.toString());
        }
        if (log.isInfoEnabled()) {
            log.info(System.getProperty("java.version"));
            log.info("user.dir:" + System.getProperty("user.dir"));
        }
        autServerName = args[3];
        AUTServer.getInstance().setArgs(args);
        AUTServer.getInstance().start(false);
    }

    public void startAUT() {
        if (this.isRcpAccessible()) {
            return;
        }
        if (this.isAgentSet()) {
            this.startToolkitThread();
            this.addToolKitEventListenerToAUT();
            return;
        }
        this.setAutThread(new Thread(new Runnable(){

            public void run() {
                try {
                    AUTServer.this.startTasks();
                }
                catch (ExceptionInInitializerError e) {
                    log.error(String.valueOf(e), (Throwable)e);
                    System.exit(25);
                }
                catch (InvocationTargetException e) {
                    String exception = String.valueOf(e);
                    String targetException = String.valueOf(e.getTargetException());
                    String message = String.valueOf(exception) + " TargetException: " + targetException;
                    log.error(message, (Throwable)e);
                    System.exit(25);
                }
                catch (NoSuchMethodException e) {
                    log.error(String.valueOf(e), (Throwable)e);
                    System.exit(25);
                }
            }
        }, "Main (AUT)"));
        this.getAutThread().setDaemon(false);
        this.getAutThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        this.getAutThread().start();
    }

    public boolean stopAUT() {
        return this.closeAUT();
    }

    protected abstract boolean closeAUT();

    public void start(boolean isRcpAccessible) {
        this.m_isRcpAccessible = isRcpAccessible;
        try {
            IRegisterAut autReg = this.parseAutReg();
            if (autReg == null) {
                String errorMessage = "Unable to initialize connection to AUT Agent: No connection information provided.";
                log.error(errorMessage);
                this.sendExitReason(errorMessage, 12);
            }
            if (!isRcpAccessible && !this.isAgentSet()) {
                this.loadAUT();
            }
            if (this.m_isAgentSet || isRcpAccessible) {
                this.setAutThread(Thread.currentThread());
            }
            if (this.m_communicator != null) {
                this.m_communicator.send((Message)new AUTServerStateMessage(0));
            } else {
                new Thread("Start AUT Server"){

                    public void run() {
                        AUTStartCommand startCommand = new AUTStartCommand();
                        startCommand.setMessage((Message)new AUTStartMessage());
                        startCommand.execute();
                    }
                }.start();
            }
            while (!(this.getAutThread() != null && this.getAutThread().isAlive() || this.isAutRunning())) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (autReg != null) {
                try {
                    autReg.register();
                }
                catch (IOException ioe) {
                    log.error("Exception during AUT registration", (Throwable)ioe);
                    System.exit(25);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            log.error("Exception in start()", (Throwable)iae);
            System.exit(1);
        }
        catch (CommunicationException ce) {
            log.error("Exception in start()", (Throwable)ce);
            System.exit(11);
        }
        catch (SecurityException se) {
            log.error("Exception in start()", (Throwable)se);
            System.exit(23);
        }
        catch (ClassNotFoundException cnfe) {
            this.sendExitReason(cnfe, 1);
            System.exit(3);
        }
        catch (NoSuchMethodException nsme) {
            this.sendExitReason(nsme, 2);
            System.exit(3);
        }
        catch (UnsupportedClassVersionError ucve) {
            this.sendExitReason(ucve, 3);
            System.exit(4);
        }
        catch (JBVersionException ve) {
            this.sendExitReason(ve, 3);
            System.exit(10);
        }
    }

    protected IRegisterAut parseAutReg() {
        if (this.m_autAgentHost != null && this.m_autAgentPort != null && this.m_autName != null) {
            try {
                int autAgentPort = Integer.parseInt(this.m_autAgentPort);
                InetSocketAddress agentAddr = new InetSocketAddress(this.m_autAgentHost, autAgentPort);
                AutIdentifier autIdentifier = new AutIdentifier(this.m_autName);
                return new AgentRegisterAut(agentAddr, autIdentifier);
            }
            catch (NumberFormatException nfe) {
                log.warn("Unable to parse port number for Aut Agent. Continuing as if no Aut Agent information was provided.", (Throwable)nfe);
            }
        }
        return null;
    }

    public void initClientCommunication(String clientHostName, int clientPort) throws UnknownHostException {
        if (log.isDebugEnabled()) {
            log.debug("initializing communication");
        }
        InetAddress clientAddress = InetAddress.getByName(clientHostName);
        this.createCommunicator(new InetSocketAddress(clientAddress, clientPort));
        this.connectGdClient();
    }

    protected void connectGdClient() {
        try {
            this.m_communicator.run();
        }
        catch (SecurityException se) {
            log.error("Exception in start()", (Throwable)se);
            System.exit(20);
        }
        catch (JBVersionException e) {
            log.error(e.toString());
        }
    }

    protected void sendExitReason(Throwable e, int exitCode) {
        log.error("Exception in start()", e);
        this.sendExitReason(e.getMessage(), exitCode);
    }

    protected void sendExitReason(String errorMessage, int exitCode) {
        try {
            this.m_communicator.send((Message)new AUTServerStateMessage(exitCode, errorMessage));
        }
        catch (CommunicationException ce) {
            log.error("Exception in start()", (Throwable)ce);
        }
    }

    private void createCommunicator(InetSocketAddress clientAddress) {
        this.m_communicator = this.createComm(clientAddress);
        this.m_communicator.addCommunicationErrorListener(this.m_communicationListener);
    }

    protected Communicator createComm(InetSocketAddress clientAddress) {
        return new Communicator(clientAddress.getAddress(), clientAddress.getPort(), Thread.currentThread().getContextClassLoader());
    }

    public void initAutAgentCommunicator(InetAddress agentAddress, int agentPort) throws SecurityException, JBVersionException {
        this.m_serverCommunicator = new Communicator(agentAddress, agentPort, Thread.currentThread().getContextClassLoader());
        this.m_serverCommunicator.addCommunicationErrorListener(this.m_serverCommunicationListener);
        this.m_serverCommunicator.run();
    }

    protected abstract void startToolkitThread();

    public void addToolKitEventListenerToAUT() {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.addToolkitEventListeners();
        Thread.currentThread().setContextClassLoader(oldCL);
    }

    protected abstract void addToolkitEventListeners();

    private void loadAUT() throws SecurityException, ClassNotFoundException, NoSuchMethodException, UnsupportedClassVersionError {
        if (log.isInfoEnabled()) {
            log.info("loading the AUT");
        }
        this.m_autMainClass = ClassLoader.getSystemClassLoader().loadClass(this.m_autMainClassName);
        this.m_autMainMethod = this.m_autMainClass.getMethod("main", this.m_autArgs.getClass());
        this.m_autMainMethod.setAccessible(true);
        int mods = this.m_autMainMethod.getModifiers();
        if (this.m_autMainMethod.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            this.m_autMainMethod = null;
            throw new NoSuchMethodException("no public static main");
        }
    }

    public void invokeAUT() throws ExceptionInInitializerError, InvocationTargetException, NoSuchMethodException {
        if (this.m_autMainMethod == null) {
            log.error("the main method of the AUT could not be found!");
            throw new NoSuchMethodException("no public static main in AUT");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("invoking main method of the AUT");
            }
            this.m_isAutRunning = true;
            this.m_autMainMethod.invoke(null, new Object[]{this.m_autArgs});
        }
        catch (IllegalArgumentException iae) {
            this.m_isAutRunning = false;
            log.error("An error occured: ", (Throwable)iae);
        }
        catch (IllegalAccessException iae) {
            this.m_isAutRunning = false;
            log.error("An error occured: ", (Throwable)iae);
        }
        catch (NullPointerException npe) {
            this.m_isAutRunning = false;
            log.error("An error occured: ", (Throwable)npe);
        }
        catch (RuntimeException re) {
            this.m_isAutRunning = false;
            log.error("unexpected exception thrown by AUT: ", (Throwable)re);
            throw re;
        }
    }

    public void setMode(int newMode) {
        if (log.isInfoEnabled()) {
            log.info("changing mode from " + String.valueOf(this.m_mode) + " to " + String.valueOf(newMode));
        }
        int oldMode = this.m_mode;
        this.m_mode = newMode;
        switch (newMode) {
            case 2: {
                this.removeToolkitEventListener(this.m_mappingListener);
                this.removeToolkitEventListener(this.m_recordListener);
                this.removeToolkitEventListener(this.m_checkListener);
                this.refreshMode();
                this.addToolkitEventListener(this.m_mappingListener);
                break;
            }
            case 3: {
                this.removeToolkitEventListener(this.m_mappingListener);
                this.removeToolkitEventListener(this.m_recordListener);
                this.removeToolkitEventListener(this.m_checkListener);
                this.m_mappingListener.cleanUp();
                this.addToolkitEventListener(this.m_recordListener);
                if (oldMode == 4) break;
                this.setObservTimestamp(0L);
                break;
            }
            case 4: {
                this.removeToolkitEventListener(this.m_mappingListener);
                this.removeToolkitEventListener(this.m_recordListener);
                this.removeToolkitEventListener(this.m_checkListener);
                this.m_mappingListener.cleanUp();
                this.addToolkitEventListener(this.m_checkListener);
                break;
            }
            case 1: {
                this.removeToolkitEventListener(this.m_mappingListener);
                this.removeToolkitEventListener(this.m_recordListener);
                this.removeToolkitEventListener(this.m_checkListener);
                this.m_recordListener.cleanUp();
                this.m_checkListener.cleanUp();
                break;
            }
            default: {
                log.error("unkown mode: " + String.valueOf(newMode));
                this.m_mode = oldMode;
            }
        }
    }

    public void refreshMode() {
        this.m_mappingListener.cleanUp();
        this.m_recordListener.cleanUp();
        this.m_checkListener.cleanUp();
    }

    protected abstract void addToolkitEventListener(BaseAUTListener var1);

    protected abstract void removeToolkitEventListener(BaseAUTListener var1);

    public int getMode() {
        return this.m_mode;
    }

    public boolean highlightComponent(IComponentIdentifier comp) {
        return this.m_mappingListener.highlightComponent(comp);
    }

    public void updateHighLighter() {
        this.m_mappingListener.update();
    }

    protected abstract void startTasks() throws ExceptionInInitializerError, InvocationTargetException, NoSuchMethodException;

    protected Thread getAutThread() {
        return this.m_autThread;
    }

    public boolean isAutRunning() {
        return this.m_isAutRunning;
    }

    public abstract IRobot getRobot();

    public final void startInspector() {
        IAutListenerAppender[] inspectorAppenders = this.m_inspectorListenerAppenders.toArray(new IAutListenerAppender[this.m_inspectorListenerAppenders.size()]);
        int i = 0;
        while (i < inspectorAppenders.length) {
            inspectorAppenders[i].addAutListener();
            ++i;
        }
    }

    public final void addInspectorListenerAppender(IAutListenerAppender appender) {
        this.m_inspectorListenerAppenders.add(appender);
    }

    public static AUTServer getInstance(String swtAutServerName) {
        autServerName = swtAutServerName;
        return AUTServer.getInstance();
    }

    public void setAutStarterPort(String autStarterPort) {
    }

    public boolean isRcpAccessible() {
        return this.m_isRcpAccessible;
    }

    public boolean isAgentSet() {
        return this.m_isAgentSet;
    }

    public boolean isObservingDialogOpen() {
        return this.m_isObservingDialogOpen;
    }

    public void setObservingDialogOpen(boolean isObservingDialogOpen) {
        this.m_isObservingDialogOpen = isObservingDialogOpen;
    }

    public long getObservTimestamp() {
        return this.m_observTimestamp;
    }

    public void setObservTimestamp(long timestamp) {
        this.m_observTimestamp = timestamp;
    }

    private void setAutThread(Thread autThread) {
        this.m_autThread = autThread;
    }

    protected static void setInstance(AUTServer singletonInstance) {
        instance = singletonInstance;
    }

    public void shutdown() {
    }

    public void setAutAgentHost(String autAgentHost) {
        this.m_autAgentHost = autAgentHost;
    }

    public void setAutAgentPort(String autAgentPort) {
        this.m_autAgentPort = autAgentPort;
    }

    public void setAutName(String autName) {
        this.m_autName = autName;
    }

    private abstract class AbstractCommunicationListener
    implements ICommunicationErrorListener {
        private AbstractCommunicationListener() {
        }

        public void acceptingFailed(int port) {
            log.debug("acceptingFailed() called although this is a client");
            this.terminate();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void connectingFailed(InetAddress inetAddress, int port) {
            String message = "";
            try {
                try {
                    message = "connecting to " + inetAddress.getHostName() + ":" + String.valueOf(port) + " failed()";
                    log.error(message);
                }
                catch (SecurityException securityException) {
                    log.error("security violation during getting the  host name from ip address in connectingFailed()");
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.terminate();
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.terminate();
                return;
            }
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            if (log.isInfoEnabled()) {
                String message;
                try {
                    message = "connected to " + inetAddress.getHostName() + ":" + String.valueOf(port);
                }
                catch (SecurityException securityException) {
                    log.debug("security violation during getting the host name from ip address in connectingGained()");
                    message = " connected";
                }
                log.info(message);
            }
        }

        public void sendFailed(Message message) {
            log.error("sending message " + message.toString() + "failed");
            this.terminate();
        }

        public void shutDown() {
            if (log.isInfoEnabled()) {
                log.info("connection closed");
                log.info("exiting with " + String.valueOf(11));
            }
            this.terminate();
        }

        protected abstract void terminate();
    }

    private class AgentCommunicationListener
    extends AbstractCommunicationListener {
        private AgentCommunicationListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void terminate() {
            try {
                AUTServer.this.shutdown();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                System.exit(11);
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            System.exit(11);
        }
    }

    private class ClientCommunicationListener
    extends AbstractCommunicationListener {
        private ClientCommunicationListener() {
        }

        protected void terminate() {
            ChangeAUTModeMessage message = new ChangeAUTModeMessage();
            message.setMode(1);
            ChangeAUTModeCommand changeModeCmd = new ChangeAUTModeCommand();
            changeModeCmd.setMessage((Message)message);
            changeModeCmd.execute();
            if (AUTServer.this.m_communicator != null) {
                AUTServer.this.m_communicator.close();
            }
        }
    }
}

